/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.awt.geom.RectangularShape;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.type1.AFMCharMetrics;
import org.apache.fop.fonts.type1.AFMFile;
import org.apache.fop.fonts.type1.AFMParser;
import org.apache.fop.fonts.type1.PFMFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type1FontLoader
extends FontLoader {
    private SingleByteFont singleFont;
    private static final String[] AFM_EXTENSIONS = new String[]{".AFM", ".afm", ".Afm"};

    public Type1FontLoader(String fontFileURI, boolean embedded, boolean useKerning, FontResolver resolver) throws IOException {
        super(fontFileURI, embedded, useKerning, true, resolver);
    }

    private String getPFMURI(String pfbURI) {
        String pfbExt = pfbURI.substring(pfbURI.length() - 3, pfbURI.length());
        String pfmExt = pfbExt.substring(0, 2) + (Character.isUpperCase(pfbExt.charAt(2)) ? "M" : "m");
        return pfbURI.substring(0, pfbURI.length() - 4) + "." + pfmExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void read() throws IOException {
        AFMFile afm = null;
        PFMFile pfm = null;
        InputStream afmIn = null;
        String afmUri = null;
        for (int i = 0; i < AFM_EXTENSIONS.length; ++i) {
            try {
                afmUri = this.fontFileURI.substring(0, this.fontFileURI.length() - 4) + AFM_EXTENSIONS[i];
                afmIn = Type1FontLoader.openFontUri(this.resolver, afmUri);
                if (afmIn == null) continue;
                break;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (afmIn != null) {
            try {
                AFMParser afmParser = new AFMParser();
                afm = afmParser.parse(afmIn, afmUri);
            }
            finally {
                IOUtils.closeQuietly(afmIn);
            }
        }
        String pfmUri = this.getPFMURI(this.fontFileURI);
        InputStream pfmIn = null;
        try {
            pfmIn = Type1FontLoader.openFontUri(this.resolver, pfmUri);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (pfmIn != null) {
            try {
                pfm = new PFMFile();
                pfm.load(pfmIn);
            }
            catch (IOException ioe) {
                if (afm == null) {
                    throw ioe;
                }
            }
            finally {
                IOUtils.closeQuietly(pfmIn);
            }
        }
        if (afm == null && pfm == null) {
            throw new FileNotFoundException("Neither an AFM nor a PFM file was found for " + this.fontFileURI);
        }
        this.buildFont(afm, pfm);
        this.loaded = true;
    }

    private void buildFont(AFMFile afm, PFMFile pfm) {
        if (afm == null && pfm == null) {
            throw new IllegalArgumentException("Need at least an AFM or a PFM!");
        }
        this.singleFont = new SingleByteFont();
        this.singleFont.setFontType(FontType.TYPE1);
        this.singleFont.setResolver(this.resolver);
        if (this.embedded) {
            this.singleFont.setEmbedFileName(this.fontFileURI);
        }
        this.returnFont = this.singleFont;
        this.handleEncoding(afm, pfm);
        this.handleFontName(afm, pfm);
        this.handleMetrics(afm, pfm);
    }

    private void handleEncoding(AFMFile afm, PFMFile pfm) {
        if (afm != null) {
            String encoding = afm.getEncodingScheme();
            this.singleFont.setUseNativeEncoding(true);
            if ("AdobeStandardEncoding".equals(encoding)) {
                this.singleFont.setEncoding("StandardEncoding");
                this.addUnencodedBasedOnEncoding(afm);
            } else {
                String effEncodingName = "FontSpecific".equals(encoding) ? afm.getFontName() + "Encoding" : encoding;
                if (log.isDebugEnabled()) {
                    log.debug("Unusual font encoding encountered: " + encoding + " -> " + effEncodingName);
                }
                CodePointMapping mapping = this.buildCustomEncoding(effEncodingName, afm);
                this.singleFont.setEncoding(mapping);
                this.addUnencodedBasedOnAFM(afm);
            }
        } else if (pfm.getCharSet() >= 0 && pfm.getCharSet() <= 2) {
            this.singleFont.setEncoding(pfm.getCharSetName() + "Encoding");
        } else {
            log.warn("The PFM reports an unsupported encoding (" + pfm.getCharSetName() + "). The font may not work as expected.");
            this.singleFont.setEncoding("WinAnsiEncoding");
        }
    }

    private Set<String> toGlyphSet(String[] glyphNames) {
        HashSet<String> glyphSet = new HashSet<String>();
        for (String name : glyphNames) {
            glyphSet.add(name);
        }
        return glyphSet;
    }

    private void addUnencodedBasedOnEncoding(AFMFile afm) {
        SingleByteEncoding encoding = this.singleFont.getEncoding();
        Set<String> glyphNames = this.toGlyphSet(encoding.getCharNameMap());
        List<AFMCharMetrics> charMetrics = afm.getCharMetrics();
        for (AFMCharMetrics metrics : charMetrics) {
            String charName = metrics.getCharName();
            if (charName == null || glyphNames.contains(charName)) continue;
            this.singleFont.addUnencodedCharacter(metrics.getCharacter(), (int)Math.round(metrics.getWidthX()));
        }
    }

    private void addUnencodedBasedOnAFM(AFMFile afm) {
        List<AFMCharMetrics> charMetrics = afm.getCharMetrics();
        int c = afm.getCharCount();
        for (int i = 0; i < c; ++i) {
            AFMCharMetrics metrics = charMetrics.get(i);
            if (metrics.hasCharCode() || metrics.getCharacter() == null) continue;
            this.singleFont.addUnencodedCharacter(metrics.getCharacter(), (int)Math.round(metrics.getWidthX()));
        }
    }

    private void handleFontName(AFMFile afm, PFMFile pfm) {
        if (afm != null) {
            this.returnFont.setFontName(afm.getFontName());
            this.returnFont.setFullName(afm.getFullName());
            HashSet<String> names = new HashSet<String>();
            names.add(afm.getFamilyName());
            this.returnFont.setFamilyNames(names);
        } else {
            this.returnFont.setFontName(pfm.getPostscriptName());
            String fullName = pfm.getPostscriptName();
            fullName = fullName.replace('-', ' ');
            this.returnFont.setFullName(fullName);
            HashSet<String> names = new HashSet<String>();
            names.add(pfm.getWindowsName());
            this.returnFont.setFamilyNames(names);
        }
    }

    private void handleMetrics(AFMFile afm, PFMFile pfm) {
        RectangularShape rect;
        AFMCharMetrics chm;
        if (afm != null) {
            if (afm.getCapHeight() != null) {
                this.returnFont.setCapHeight(afm.getCapHeight().intValue());
            }
            if (afm.getXHeight() != null) {
                this.returnFont.setXHeight(afm.getXHeight().intValue());
            }
            if (afm.getAscender() != null) {
                this.returnFont.setAscender(afm.getAscender().intValue());
            }
            if (afm.getDescender() != null) {
                this.returnFont.setDescender(afm.getDescender().intValue());
            }
            this.returnFont.setFontBBox(afm.getFontBBoxAsIntArray());
            if (afm.getStdVW() != null) {
                this.returnFont.setStemV(afm.getStdVW().intValue());
            } else {
                this.returnFont.setStemV(80);
            }
            this.returnFont.setItalicAngle((int)afm.getWritingDirectionMetrics(0).getItalicAngle());
        } else {
            this.returnFont.setFontBBox(pfm.getFontBBox());
            this.returnFont.setStemV(pfm.getStemV());
            this.returnFont.setItalicAngle(pfm.getItalicAngle());
        }
        if (pfm != null) {
            if (this.returnFont.getCapHeight() == 0) {
                this.returnFont.setCapHeight(pfm.getCapHeight());
            }
            if (this.returnFont.getXHeight(1) == 0) {
                this.returnFont.setXHeight(pfm.getXHeight());
            }
            if (this.returnFont.getAscender() == 0) {
                this.returnFont.setAscender(pfm.getLowerCaseAscent());
            }
            if (this.returnFont.getDescender() == 0) {
                this.returnFont.setDescender(pfm.getLowerCaseDescent());
            }
        }
        if (this.returnFont.getXHeight(1) == 0) {
            int xHeight = 0;
            if (afm != null && (chm = afm.getChar("x")) != null && (rect = chm.getBBox()) != null) {
                xHeight = (int)Math.round(rect.getMinX());
            }
            if (xHeight == 0) {
                xHeight = Math.round((float)this.returnFont.getFontBBox()[3] * 0.6f);
            }
            this.returnFont.setXHeight(xHeight);
        }
        if (this.returnFont.getAscender() == 0) {
            int asc = 0;
            if (afm != null && (chm = afm.getChar("d")) != null && (rect = chm.getBBox()) != null) {
                asc = (int)Math.round(rect.getMinX());
            }
            if (asc == 0) {
                asc = Math.round((float)this.returnFont.getFontBBox()[3] * 0.9f);
            }
            this.returnFont.setAscender(asc);
        }
        if (this.returnFont.getDescender() == 0) {
            int desc = 0;
            if (afm != null && (chm = afm.getChar("p")) != null && (rect = chm.getBBox()) != null) {
                desc = (int)Math.round(rect.getMinX());
            }
            if (desc == 0) {
                desc = this.returnFont.getFontBBox()[1];
            }
            this.returnFont.setDescender(desc);
        }
        if (this.returnFont.getCapHeight() == 0) {
            this.returnFont.setCapHeight(this.returnFont.getAscender());
        }
        if (afm != null) {
            String charSet = afm.getCharacterSet();
            int flags = 0;
            flags = "Special".equals(charSet) ? (flags |= 4) : (this.singleFont.getEncoding().mapChar('A') == 'A' ? (flags |= 0x20) : (flags |= 4));
            if (afm.getWritingDirectionMetrics(0).isFixedPitch()) {
                flags |= 1;
            }
            if (afm.getWritingDirectionMetrics(0).getItalicAngle() != 0.0) {
                flags |= 0x40;
            }
            this.returnFont.setFlags(flags);
            this.returnFont.setFirstChar(afm.getFirstChar());
            this.returnFont.setLastChar(afm.getLastChar());
            for (AFMCharMetrics chm2 : afm.getCharMetrics()) {
                if (!chm2.hasCharCode()) continue;
                this.singleFont.setWidth(chm2.getCharCode(), (int)Math.round(chm2.getWidthX()));
            }
            if (this.useKerning) {
                this.returnFont.replaceKerningMap(afm.createXKerningMapEncoded());
            }
        } else {
            this.returnFont.setFlags(pfm.getFlags());
            this.returnFont.setFirstChar(pfm.getFirstChar());
            this.returnFont.setLastChar(pfm.getLastChar());
            for (short i = pfm.getFirstChar(); i <= pfm.getLastChar(); i = (short)(i + 1)) {
                this.singleFont.setWidth(i, pfm.getCharWidth(i));
            }
            if (this.useKerning) {
                this.returnFont.replaceKerningMap(pfm.getKerning());
            }
        }
    }

    private CodePointMapping buildCustomEncoding(String encodingName, AFMFile afm) {
        int mappingCount = 0;
        List<AFMCharMetrics> chars = afm.getCharMetrics();
        for (AFMCharMetrics charMetrics : chars) {
            String u;
            if (charMetrics.getCharCode() < 0 || (u = charMetrics.getUnicodeSequence()) == null || u.length() != 1) continue;
            ++mappingCount;
        }
        int[] table = new int[mappingCount * 2];
        String[] charNameMap = new String[256];
        int idx = 0;
        for (AFMCharMetrics charMetrics : chars) {
            if (charMetrics.getCharCode() < 0) continue;
            charNameMap[charMetrics.getCharCode()] = charMetrics.getCharName();
            String unicodes = charMetrics.getUnicodeSequence();
            if (unicodes == null) {
                log.info("No Unicode mapping for glyph: " + charMetrics);
                continue;
            }
            if (unicodes.length() == 1) {
                table[idx] = charMetrics.getCharCode();
                table[++idx] = unicodes.charAt(0);
                ++idx;
                continue;
            }
            log.warn("Multi-character representation of glyph not currently supported: " + charMetrics);
        }
        return new CodePointMapping(encodingName, table, charNameMap);
    }
}

