/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BaseLoader2;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Extension;
import com.ibm.xmi.framework.ExtensionImpl;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.ObjectInfo;
import com.ibm.xmi.framework.ReaderAdapter;
import com.ibm.xmi.framework.ValueInfo;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIObject;
import com.ibm.xmi.framework.XMLElement;
import com.ibm.xmi.framework.XMLElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class BaseLoader
extends DefaultHandler {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected XMIFile file;
    protected int option;
    protected MyStack tagNames;
    protected MyStack types;
    protected MyStack objects;
    protected MyStack extensionInfos;
    protected MyStack xmlElements;
    protected boolean isContent = false;
    protected boolean debug = false;
    protected StringBuffer text = new StringBuffer("");
    protected HashMap idsToObjects = new HashMap();
    protected HashMap namesToModels = new HashMap();
    protected ArrayList featuresToSet;
    protected ReaderAdapter adapter;
    protected ObjectInfo objectInfo = new ObjectInfo();
    protected ValueInfo valueInfo = new ValueInfo();
    private BaseLoader2 loader2 = null;

    public BaseLoader(XMIFile xMIFile, int n, ReaderAdapter readerAdapter) {
        this.file = xMIFile;
        this.option = n;
        this.adapter = readerAdapter;
        this.tagNames = new MyStack();
        this.types = new MyStack();
        this.objects = new MyStack();
        this.extensionInfos = new MyStack();
        this.xmlElements = new MyStack();
        if (n == 2) {
            readerAdapter.setXMIFile(xMIFile);
            this.isContent = true;
        }
    }

    protected Object createObject(ObjectInfo objectInfo) {
        objectInfo.setModel(this.getModel(objectInfo.getNamespace()));
        Object object = this.adapter.createObject(objectInfo);
        if (object != null) {
            if (this.addToFile()) {
                this.file.add(object);
            }
            if (objectInfo.getId() != null) {
                this.idsToObjects.put(objectInfo.getId(), object);
            }
        }
        return object;
    }

    protected boolean addToFile() {
        if (!this.tagNames.isEmpty() && this.tagNames.peek().equals("XMI.content") && this.option != 2) {
            return true;
        }
        return this.tagNames.isEmpty() && this.option == 2;
    }

    protected void createObject(String string, Attributes attributes) {
        if (this.debug) {
            System.out.println("createObject " + string);
        }
        this.objectInfo.clear();
        String[] stringArray = this.processAttribs(this.objectInfo, attributes);
        int n = string.indexOf(":");
        if (n == -1) {
            this.objectInfo.setXMIName(string);
        } else {
            this.objectInfo.setXMIName(string.substring(n + 1));
        }
        this.objectInfo.setNamespace(this.getNamespace(string));
        Object object = this.createObject(this.objectInfo);
        if (!this.objects.isEmpty() && !this.types.peek().equals("Extension")) {
            this.handleFeature(object, this.objectInfo.getIdref());
        }
        this.types.push("Object");
        if (object != null) {
            this.objects.push(object);
            this.processOtherAttribs(object, stringArray, string);
        } else {
            this.objects.push(new Object());
        }
    }

    protected Object createFeature(ValueInfo valueInfo, int n, String string) {
        if (this.debug) {
            System.out.println("BaseLoader createFeature:");
            System.out.println("info: " + valueInfo);
            System.out.println("type: " + n);
            System.out.println("idref: " + string);
        }
        if (valueInfo.getValue() == null && string != null) {
            valueInfo.setValue(this.idsToObjects.get(string));
        }
        valueInfo.setModel(this.getModel(valueInfo.getNamespace()));
        Object object = this.createFeatureFromAdapter(valueInfo, n);
        if (object != null && valueInfo.getValue() == null && string != null) {
            if (this.featuresToSet == null) {
                this.featuresToSet = new ArrayList();
            }
            this.featuresToSet.add(valueInfo.getObject());
            this.featuresToSet.add(object);
            this.featuresToSet.add(string);
        }
        return object;
    }

    protected Object createFeatureFromAdapter(ValueInfo valueInfo, int n) {
        if (this.debug) {
            System.out.println("MatchBaseLoader createFeatureFromAdapter:");
            System.out.println("info: " + valueInfo);
            System.out.println("type: " + n);
        }
        valueInfo.setType(n);
        if (n == 8) {
            return this.adapter.setValue(valueInfo);
        }
        if (n == -1) {
            if (valueInfo.getValue() != null && valueInfo.getValue() instanceof String) {
                n = 7;
            } else if (valueInfo.getValue() == null || !(valueInfo.getValue() instanceof String)) {
                n = 8;
            }
            valueInfo.setType(n);
        }
        if (n == 7 || n == 6 || n == 8 || n == 4 || n == 3 || n == 2) {
            return this.adapter.setValue(valueInfo);
        }
        return null;
    }

    private void createXMLElement(String string, Attributes attributes) {
        if (this.debug) {
            System.out.println("createXMLElement " + string);
        }
        XMLElementImpl xMLElementImpl = new XMLElementImpl(string);
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getQName(n);
            String string3 = attributes.getValue(n);
            xMLElementImpl.add(string2, string3);
            ++n;
        }
        if (!this.types.isEmpty() && this.types.peek().equals("Extension") && !this.extensionInfos.isEmpty()) {
            ((ExtensionInfo)this.extensionInfos.peek()).getExtension().add(xMLElementImpl);
        } else if (!this.types.isEmpty() && this.types.peek().equals("XMLElement") && !this.xmlElements.isEmpty()) {
            ((XMLElement)this.xmlElements.peek()).add(xMLElementImpl);
        }
        this.xmlElements.push(xMLElementImpl);
        this.types.push("XMLElement");
    }

    protected String getClassName(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(".")) == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    protected String[] getIdrefs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    protected XMIFile.Model getModel(Namespace namespace) {
        if (namespace == null || namespace.getPrefix() == null) {
            return null;
        }
        return (XMIFile.Model)this.namesToModels.get(namespace.getPrefix());
    }

    protected Namespace getNamespace(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return this.file.getNamespace(string2);
    }

    protected String getSimpleName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected int getTypeFromTypeStack() {
        if (this.types.isEmpty()) {
            return -1;
        }
        if (this.types.peek().equals("ObjectProperty") || this.types.peek().equals("Property")) {
            return 8;
        }
        if (this.types.peek().equals("ContainerLink")) {
            return 3;
        }
        if (this.types.peek().equals("ContainLink")) {
            return 4;
        }
        if (this.types.peek().equals("RefLink")) {
            return 2;
        }
        return -1;
    }

    private void handleExtension(Attributes attributes) {
        String string = attributes.getValue(this.getExtenderName());
        String string2 = attributes.getValue(this.getExtenderIDName());
        ExtensionInfo extensionInfo = new ExtensionInfo();
        ExtensionInfo extensionInfo2 = null;
        if (!this.extensionInfos.isEmpty()) {
            extensionInfo2 = (ExtensionInfo)this.extensionInfos.peek();
        }
        if (extensionInfo2 != null && extensionInfo2.getHandler() != null) {
            extensionInfo.setHandler(extensionInfo2.getHandler());
        } else {
            extensionInfo.setHandler(this.adapter.createExtension(this.objects.peek(), string, string2));
        }
        if (extensionInfo.getHandler() == null) {
            if (extensionInfo2 != null && extensionInfo2.getIgnore() || !(this.objects.peek() instanceof XMIObject)) {
                extensionInfo.setIgnore(true);
            } else if (this.objects.peek() instanceof XMIObject) {
                ExtensionImpl extensionImpl = new ExtensionImpl(string, string2);
                ((XMIObject)this.objects.peek()).add(extensionImpl);
                extensionInfo.setExtension(extensionImpl);
            }
        }
        this.types.push("Extension");
        this.extensionInfos.push(extensionInfo);
    }

    protected String getExtenderName() {
        return "xmi.extender";
    }

    protected String getExtenderIDName() {
        return "xmi.extenderID";
    }

    private void handleHeaderData(String string, Attributes attributes) {
        String string2 = attributes.getValue(this.getNameAttrib());
        String string3 = attributes.getValue(this.getVersionAttrib());
        String string4 = attributes.getValue(this.getHrefAttrib());
        if (string.equals(this.getImportElementName())) {
            this.file.add(new XMIFile.Import(string2, string3, string4));
        } else if (string.equals(this.getModelElementName())) {
            XMIFile.Model model = new XMIFile.Model(string2, string3, string4);
            if (string2 != null) {
                this.namesToModels.put(string2, model);
            }
            this.file.add(model);
        } else if (string.equals(this.getMetamodelElementName())) {
            XMIFile.Metamodel metamodel = new XMIFile.Metamodel(string2, string3, string4);
            if (string2 != null) {
                this.namesToModels.put(string2, metamodel);
            }
            this.file.add((XMIFile.Model)metamodel);
        } else if (string.equals(this.getMetametamodelElementName())) {
            XMIFile.Metametamodel metametamodel = new XMIFile.Metametamodel(string2, string3, string4);
            if (string2 != null) {
                this.namesToModels.put(string2, metametamodel);
            }
            this.file.add((XMIFile.Model)metametamodel);
        }
    }

    protected String getNameAttrib() {
        return "xmi.name";
    }

    protected String getVersionAttrib() {
        return "xmi.version";
    }

    protected String getHrefAttrib() {
        return "href";
    }

    protected void handleFeature(Object object, String string) {
        this.valueInfo.clear();
        this.valueInfo.setObject(this.objects.peek());
        this.valueInfo.setXMIName(this.stripNamespace((String)this.tagNames.peek()));
        this.valueInfo.setNamespace(this.getNamespace((String)this.tagNames.peek()));
        this.valueInfo.setValue(object);
        int n = this.getTypeFromTypeStack();
        this.createFeature(this.valueInfo, n, string);
        if (this.types.peek().equals("Property")) {
            this.types.pop();
            this.types.push("ObjectProperty");
        }
    }

    private void handleXMIElement(Attributes attributes) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getQName(n);
            if (string.equals("xmi.version")) {
                this.file.setXMIVersion(attributes.getValue(n));
            } else if (string.equals("timestamp")) {
                this.file.setTimestamp(attributes.getValue(n));
            } else if (string.equals("verified")) {
                if (attributes.getValue(n).equals("true")) {
                    this.file.setVerified(true);
                }
            } else {
                this.processNamespaceAttrib(string, attributes.getValue(n));
            }
            ++n;
        }
    }

    protected void processNamespaceAttrib(String string, String string2) {
        if (!string.startsWith("xmlns")) {
            return;
        }
        int n = string.indexOf(":");
        String string3 = n == -1 ? "" : string.substring(n + 1);
        Namespace namespace = new Namespace(string3, string2);
        this.file.add(namespace);
    }

    protected String[] processAttribs(ObjectInfo objectInfo, Attributes attributes) {
        String[] stringArray = new String[attributes.getLength() * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < attributes.getLength()) {
            String string = attributes.getQName(n2);
            if (string.equals(this.getXMIID())) {
                objectInfo.setId(attributes.getValue(n2));
            } else if (string.equals(this.getXMIUUID())) {
                objectInfo.setUUID(attributes.getValue(n2));
            } else if (string.equals(this.getXMILabel())) {
                objectInfo.setLabel(attributes.getValue(n2));
            } else if (string.equals("xmi.idref")) {
                objectInfo.setIdref(attributes.getValue(n2));
            } else if (string.equals("href")) {
                objectInfo.setHref(attributes.getValue(n2));
            } else {
                stringArray[n++] = string;
                stringArray[n++] = attributes.getValue(n2);
            }
            ++n2;
        }
        return stringArray;
    }

    protected String getXMIID() {
        return "xmi.id";
    }

    protected String getXMIUUID() {
        return "xmi.uuid";
    }

    protected String getXMILabel() {
        return "xmi.label";
    }

    protected void processOtherAttribs(Object object, String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n] == null) {
                return;
            }
            this.valueInfo.clear();
            this.valueInfo.setObject(object);
            this.valueInfo.setClassName(string);
            this.valueInfo.setXMIName(this.stripNamespace(stringArray[n]));
            this.valueInfo.setNamespace(this.getNamespace(stringArray[n]));
            int n2 = this.adapter.getType(this.valueInfo);
            if (this.featureHasObjectValues(n2)) {
                String[] stringArray2 = this.getIdrefs(stringArray[n + 1]);
                this.processRefsInOrder(this.valueInfo, stringArray2, n2);
            } else {
                this.valueInfo.setValue(stringArray[n + 1]);
                this.createFeature(this.valueInfo, n2, null);
            }
            n += 2;
        }
    }

    protected void processRefsInOrder(ValueInfo valueInfo, String[] stringArray, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.idsToObjects.get(stringArray[n2]) == null) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.processReferences(valueInfo, stringArray, n);
        } else {
            valueInfo.setModel(this.getModel(valueInfo.getNamespace()));
            Object object = this.createFeatureFromAdapter(valueInfo, n);
            if (object != null) {
                if (this.featuresToSet == null) {
                    this.featuresToSet = new ArrayList();
                }
                int n3 = 0;
                while (n3 < stringArray.length) {
                    this.featuresToSet.add(valueInfo.getObject());
                    this.featuresToSet.add(object);
                    this.featuresToSet.add(stringArray[n3]);
                    ++n3;
                }
            }
        }
    }

    protected void processReferences(ValueInfo valueInfo, String[] stringArray, int n) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            ObjectInfo objectInfo = new ObjectInfo();
            objectInfo.setIdref(stringArray[n2]);
            Object object = this.createObject(objectInfo);
            valueInfo.setValue(object);
            this.createFeature(valueInfo, n, stringArray[n2]);
            ++n2;
        }
    }

    protected boolean featureHasObjectValues(int n) {
        return n == 8 || n == 4 || n == 3 || n == 2;
    }

    protected void handleContent(String string, Attributes attributes) {
        if (this.debug) {
            System.out.println("handleContent " + string);
        }
        if (this.objects.isEmpty() || this.getTypeFromTypeStack() != -1) {
            this.createObject(string, attributes);
        } else if (!this.types.isEmpty() && this.types.peek().equals("XMLElement")) {
            this.createXMLElement(string, attributes);
        } else if (!this.types.isEmpty() && this.types.peek().equals("Extension")) {
            if (this.isObject(string, attributes)) {
                this.createObject(string, attributes);
                if (!this.extensionInfos.isEmpty()) {
                    ((ExtensionInfo)this.extensionInfos.peek()).getExtension().add((Data)this.objects.peek());
                }
            } else {
                this.createXMLElement(string, attributes);
            }
        } else {
            this.pushFeature(string);
            this.setText(attributes);
        }
    }

    protected boolean isObject(String string, Attributes attributes) {
        if (attributes.getValue(this.getXMIID()) != null || attributes.getValue(this.getXMILabel()) != null || attributes.getValue(this.getXMIUUID()) != null) {
            return true;
        }
        ObjectInfo objectInfo = new ObjectInfo();
        this.processAttribs(objectInfo, attributes);
        int n = string.indexOf(":");
        if (n == -1) {
            objectInfo.setXMIName(string);
        } else {
            objectInfo.setXMIName(string.substring(n + 1));
        }
        objectInfo.setNamespace(this.getNamespace(string));
        objectInfo.setModel(this.getModel(this.getNamespace(string)));
        return this.adapter.getType(objectInfo) == 10;
    }

    protected void pushFeature(String string) {
        this.valueInfo.clear();
        if (!this.objects.isEmpty()) {
            this.valueInfo.setObject(this.objects.peek());
        }
        this.valueInfo.setXMIName(this.getSimpleName(string));
        this.valueInfo.setClassName(this.getClassName(string));
        this.valueInfo.setNamespace(this.getNamespace(string));
        this.valueInfo.setModel(this.getModel(this.getNamespace(string)));
        int n = this.adapter.getType(this.valueInfo);
        if (n == 3) {
            this.types.push("ContainerLink");
        } else if (n == 2) {
            this.types.push("RefLink");
        } else if (n == 4) {
            this.types.push("ContainLink");
        } else if (n == 8) {
            this.types.push("ObjectProperty");
        } else if (n == 6) {
            this.types.push("EnumProperty");
        } else if (n == 7) {
            this.types.push("BasicProperty");
        } else {
            this.types.push("Property");
        }
    }

    private void setText(Attributes attributes) {
        int n = 0;
        while (n < attributes.getLength()) {
            if (attributes.getQName(n).equals("xmi.value")) {
                this.text = new StringBuffer(attributes.getValue(n));
            }
            ++n;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.debug) {
            System.out.println("startElement " + string3);
        }
        if (this.loader2 != null) {
            this.loader2.startElement(string, string2, string3, attributes);
            return;
        }
        this.text = new StringBuffer("");
        if (!this.extensionInfos.isEmpty()) {
            ExtensionInfo extensionInfo = (ExtensionInfo)this.extensionInfos.peek();
            if (extensionInfo.getHandler() != null) {
                extensionInfo.getHandler().startElement(string, string2, string3, attributes);
            }
            if (string3.equals(this.getExtensionName())) {
                this.handleExtension(attributes);
                return;
            }
            if (extensionInfo.getIgnore() || extensionInfo.getHandler() != null) {
                return;
            }
        }
        if (string3.equals("XMI")) {
            this.handleXMIElement(attributes);
        } else {
            if (this.isXMI2(attributes)) {
                this.loader2 = new BaseLoader2(this.file, this.option, this.adapter);
                this.loader2.startElement(string, string2, string3, attributes);
                return;
            }
            if (string3.equals(this.getImportElementName()) || string3.equals(this.getModelElementName()) || string3.equals(this.getMetamodelElementName()) || string3.equals(this.getMetametamodelElementName())) {
                this.handleHeaderData(string3, attributes);
            } else if (string3.equals("XMI.content")) {
                this.isContent = true;
                this.adapter.setXMIFile(this.file);
            } else {
                if (string3.equals(this.getExtensionName())) {
                    this.handleExtension(attributes);
                    return;
                }
                if (this.isContent) {
                    this.handleContent(string3, attributes);
                }
            }
        }
        this.tagNames.push(string3);
    }

    protected String getImportElementName() {
        return "XMI.import";
    }

    protected String getModelElementName() {
        return "XMI.model";
    }

    protected String getMetamodelElementName() {
        return "XMI.metamodel";
    }

    protected String getMetametamodelElementName() {
        return "XMI.metametamodel";
    }

    protected String getExtensionName() {
        return "XMI.extension";
    }

    protected boolean isXMI2(Attributes attributes) {
        return attributes.getValue("xmi:version") != null;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        if (this.debug) {
            System.out.println("endElement " + string3);
        }
        if (this.loader2 != null) {
            this.loader2.endElement(string, string2, string3);
            return;
        }
        if (!this.extensionInfos.isEmpty()) {
            object = (ExtensionInfo)this.extensionInfos.peek();
            if (((ExtensionInfo)object).getHandler() != null) {
                ((ExtensionInfo)object).getHandler().endElement(string, string2, string3);
            }
            if (string3.equals(this.getExtensionName())) {
                this.types.pop();
                this.extensionInfos.pop();
                return;
            }
            if (((ExtensionInfo)object).getIgnore() || ((ExtensionInfo)object).getHandler() != null) {
                return;
            }
        }
        if (string3.equals("XMI.content")) {
            this.isContent = false;
        }
        if (string3.equals(this.getExporterName())) {
            this.file.setExporter(this.text.toString());
        } else if (string3.equals(this.getExporterVersionName())) {
            this.file.setExporterVersion(this.text.toString());
        } else if (string3.equals(this.getOwnerName())) {
            this.file.setOwner(this.text.toString());
        } else if (string3.equals(this.getContactName())) {
            this.file.setContact(this.text.toString());
        } else if (string3.equals(this.getNoticeName())) {
            this.file.setNotice(this.text.toString());
        } else if (string3.equals(this.getLongDescriptionName())) {
            this.file.setLongDescription(this.text.toString());
        } else if (string3.equals(this.getShortDescriptionName())) {
            this.file.setShortDescription(this.text.toString());
        }
        if (this.isContent && !this.types.isEmpty() && this.types.peek().equals("Object")) {
            this.objects.pop();
        } else if (this.isContent && this.isBasicProperty()) {
            object = (String)this.tagNames.peek();
            this.valueInfo.clear();
            this.valueInfo.setObject(this.objects.peek());
            this.valueInfo.setClassName(this.getClassName((String)object));
            this.valueInfo.setXMIName(this.getSimpleName((String)object));
            this.valueInfo.setNamespace(this.getNamespace((String)object));
            this.valueInfo.setValue(this.text.toString());
            this.createFeature(this.valueInfo, this.getPropertyType(), null);
        } else if (this.isContent && !this.types.isEmpty() && this.types.peek().equals("XMLElement")) {
            if (!this.text.toString().equals("") && !this.xmlElements.isEmpty()) {
                ((XMLElement)this.xmlElements.peek()).add(this.text.toString());
            }
            if (!this.xmlElements.isEmpty()) {
                this.xmlElements.pop();
            }
        }
        this.tagNames.pop();
        if (!this.types.isEmpty()) {
            this.types.pop();
        }
    }

    protected String getExporterName() {
        return "XMI.exporter";
    }

    protected String getExporterVersionName() {
        return "XMI.exporterVersion";
    }

    protected String getOwnerName() {
        return "XMI.owner";
    }

    protected String getContactName() {
        return "XMI.contact";
    }

    protected String getNoticeName() {
        return "XMI.notice";
    }

    protected String getLongDescriptionName() {
        return "XMI.longDescription";
    }

    protected String getShortDescriptionName() {
        return "XMI.shortDescription";
    }

    protected boolean isBasicProperty() {
        return !this.types.isEmpty() && (this.types.peek().equals("BasicProperty") || this.types.peek().equals("EnumProperty") || this.types.peek().equals("Property"));
    }

    protected int getPropertyType() {
        if (!this.types.isEmpty() && this.types.peek().equals("EnumProperty")) {
            return 6;
        }
        return 7;
    }

    public void endDocument() throws SAXException {
        if (this.debug) {
            System.out.println("endDocument");
        }
        if (this.loader2 != null) {
            this.loader2.endDocument();
            return;
        }
        if (this.featuresToSet != null) {
            int n = 0;
            while (n < this.featuresToSet.size() - 2) {
                this.adapter.setValue(this.featuresToSet.get(n), this.featuresToSet.get(n + 1), this.idsToObjects.get(this.featuresToSet.get(n + 2)));
                n += 3;
            }
        }
        this.featuresToSet = new ArrayList();
        this.idsToObjects = new HashMap();
        this.adapter.endFile();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.loader2 != null) {
            this.loader2.characters(cArray, n, n2);
            return;
        }
        if (!this.extensionInfos.isEmpty() && ((ExtensionInfo)this.extensionInfos.peek()).getHandler() != null) {
            ((ExtensionInfo)this.extensionInfos.peek()).getHandler().characters(cArray, n, n2);
        } else {
            this.text.append(cArray, n, n2);
        }
    }

    protected String stripNamespace(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
        if (this.option == 1) {
            throw sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.option == 1) {
            throw sAXParseException;
        }
    }

    protected static class MyStack {
        private ArrayList list = new ArrayList();

        MyStack() {
        }

        boolean isEmpty() {
            return this.list.size() == 0;
        }

        Object peek() {
            if (this.list.size() == 0) {
                return null;
            }
            return this.list.get(this.list.size() - 1);
        }

        void push(Object object) {
            this.list.add(object);
        }

        Object pop() {
            if (this.list.size() == 0) {
                return null;
            }
            return this.list.remove(this.list.size() - 1);
        }
    }

    private static class ExtensionInfo {
        private ContentHandler handler;
        private boolean ignore = false;
        private Extension extension;

        ExtensionInfo() {
        }

        void setHandler(ContentHandler contentHandler) {
            this.handler = contentHandler;
        }

        void setIgnore(boolean bl) {
            this.ignore = bl;
        }

        void setExtension(Extension extension) {
            this.extension = extension;
        }

        ContentHandler getHandler() {
            return this.handler;
        }

        boolean getIgnore() {
            return this.ignore;
        }

        Extension getExtension() {
            return this.extension;
        }
    }
}

