/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;

public class CodeRegionSnapshotPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String PANEL_NAME = messages.getString("CodeRegionSnapshotPanel_PanelName");
    private static final String NO_RESULTS_REGION_MSG = messages.getString("CodeRegionSnapshotPanel_NoResultsRegionMsg");
    private static final String INDIVIDUAL_TIMES_MSG = messages.getString("CodeRegionSnapshotPanel_IndividualTimesMsg");
    private static final String SUMMARY_TIMES_MSG = messages.getString("CodeRegionSnapshotPanel_SummaryTimesMsg");
    private static final String TOTAL_INVOCATIONS_MSG = messages.getString("CodeRegionSnapshotPanel_TotalInvocationsMsg");
    private static final String ALL_REMEMBERED_MSG = messages.getString("CodeRegionSnapshotPanel_AllRememberedMsg");
    private static final String LAST_REMEMBERED_MSG = messages.getString("CodeRegionSnapshotPanel_LastRememberedMsg");
    private static final String INVOCATIONS_LISTED_MSG = messages.getString("CodeRegionSnapshotPanel_InvocationsListedMsg");
    private static final String AREA_ACCESS_NAME = messages.getString("CodeRegionSnapshotPanel_AreaAccessName");
    private CodeRegionResultsSnapshot snapshot;

    public CodeRegionSnapshotPanel(CodeRegionResultsSnapshot codeRegionResultsSnapshot) {
        this.snapshot = codeRegionResultsSnapshot;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        long[] lArray = codeRegionResultsSnapshot.getTimes();
        long l = codeRegionResultsSnapshot.getTimerCountsInSecond();
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 10);
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        if (lArray.length < 2) {
            stringBuilder.append("<i>").append(NO_RESULTS_REGION_MSG).append("</i>");
        } else {
            long l3;
            long l4 = l3 = lArray[1];
            int n = lArray.length - 1;
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 1; i < lArray.length; ++i) {
                long l5 = lArray[i];
                l2 += l5;
                if (l5 > l3) {
                    l3 = l5;
                } else if (l5 < l4) {
                    l4 = l5;
                }
                stringBuffer2.append(MessageFormat.format(INDIVIDUAL_TIMES_MSG, StringUtils.mcsTimeToString((long)(l5 * 1000000L / l))));
                stringBuffer2.append("<br>");
            }
            stringBuffer.append(MessageFormat.format(SUMMARY_TIMES_MSG, StringUtils.mcsTimeToString((long)(l2 * 1000000L / l)), StringUtils.mcsTimeToString((long)((long)((double)l2 * 1000000.0 / (double)n / (double)l))), StringUtils.mcsTimeToString((long)(l4 * 1000000L / l)), StringUtils.mcsTimeToString((long)(l3 * 1000000L / l))));
            stringBuilder.append(MessageFormat.format(TOTAL_INVOCATIONS_MSG, "" + lArray[0]));
            stringBuilder.append(", ");
            if (lArray[0] <= (long)n) {
                stringBuilder.append(ALL_REMEMBERED_MSG);
            } else {
                stringBuilder.append(MessageFormat.format(LAST_REMEMBERED_MSG, "" + n));
            }
            stringBuilder.append("<br>");
            stringBuilder.append(stringBuffer);
            stringBuilder.append("<br><br><hr><br>");
            stringBuilder.append(stringBuffer2);
            stringBuilder.append("<br><hr><br>");
            stringBuilder.append(MessageFormat.format(INVOCATIONS_LISTED_MSG, "" + n));
            stringBuilder.append(", ");
            stringBuilder.append(stringBuffer);
        }
        HTMLTextArea hTMLTextArea = new HTMLTextArea(stringBuilder.toString());
        hTMLTextArea.getAccessibleContext().setAccessibleName(AREA_ACCESS_NAME);
        this.add((Component)new JScrollPane(hTMLTextArea), "Center");
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_NAME, StringUtils.formatUserDate((Date)new Date(this.snapshot.getTimeTaken())));
    }
}

