/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import com.google.dart.compiler.backend.js.ast.metadata.SideEffectKind;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslatorKt;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B%\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/google/dart/compiler/backend/js/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "isNativeFunctionCall", "", "removeLastUndefinedArguments", "", "result", "", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "ArgumentsInfo", "Companion", "kotlin-compiler"})
public final class CallArgumentTranslator
extends AbstractTranslator {
    private final boolean isNativeFunctionCall;
    private final ResolvedCall<?> resolvedCall;
    private final JsExpression receiver;
    public static final Companion Companion = new Companion(null);

    private final void removeLastUndefinedArguments(List<JsExpression> result2) {
        int i;
        for (i = CollectionsKt.getLastIndex(result2); i >= 0 && JsAstUtils.isUndefinedExpression(result2.get(i)); --i) {
        }
        result2.subList(i + 1, result2.size()).clear();
    }

    /*
     * WARNING - void declaration
     */
    private final ArgumentsInfo translate() {
        Object actualArgument;
        List<ValueParameterDescriptor> valueParameters = this.resolvedCall.getResultingDescriptor().getValueParameters();
        if (valueParameters.isEmpty()) {
            ArgumentsInfo argumentsInfo;
            ArgumentsInfo argumentsInfo2 = argumentsInfo;
            ArgumentsInfo argumentsInfo3 = argumentsInfo;
            List list2 = CollectionsKt.emptyList();
            argumentsInfo2(list2, false, null, null, 8, null);
            return argumentsInfo3;
        }
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        List result2 = new ArrayList(valueParameters.size());
        List<ResolvedValueArgument> list3 = this.resolvedCall.getValueArgumentsByIndex();
        if (list3 == null) {
            throw (Throwable)new IllegalStateException("Failed to arrange value arguments by index: " + this.resolvedCall.getResultingDescriptor());
        }
        List<ResolvedValueArgument> valueArgumentsByIndex = list3;
        List argsBeforeVararg = null;
        boolean argumentsShouldBeExtractedToTmpVars = false;
        SmartList<TranslationContext> argContexts = new SmartList<TranslationContext>();
        List concatArguments = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters) {
            actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            TranslationContext argContext = this.context().innerBlock();
            if (actualArgument instanceof VarargValueArgument) {
                int size;
                List<ValueArgument> arguments2;
                block22: {
                    arguments2 = actualArgument.getArguments();
                    size = arguments2.size();
                    if (!hasSpreadOperator) {
                        boolean bl;
                        void $receiver$iv;
                        Iterable iterable = arguments2;
                        for (Object element$iv : $receiver$iv) {
                            ValueArgument it = (ValueArgument)element$iv;
                            if (!(it.getSpreadElement() != null)) continue;
                            bl = true;
                            break block22;
                        }
                        bl = hasSpreadOperator = false;
                    }
                }
                if (hasSpreadOperator) {
                    if (this.isNativeFunctionCall) {
                        argsBeforeVararg = result2;
                        result2 = new SmartList();
                        SmartList list4 = new SmartList();
                        List<ValueArgument> list5 = arguments2;
                        Intrinsics.checkExpressionValueIsNotNull(list5, "arguments");
                        List list6 = list4;
                        TranslationContext translationContext = argContext;
                        Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                        CallArgumentTranslator.Companion.translateValueArguments(list5, list6, translationContext);
                        List<ValueArgument> list7 = arguments2;
                        Intrinsics.checkExpressionValueIsNotNull(list7, "arguments");
                        concatArguments = CallArgumentTranslator.Companion.prepareConcatArguments(list7, list4);
                    } else {
                        List<ValueArgument> list8 = arguments2;
                        Intrinsics.checkExpressionValueIsNotNull(list8, "arguments");
                        TranslationContext translationContext = argContext;
                        Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                        CallArgumentTranslator.Companion.translateVarargArgument(list8, result2, translationContext, size > 1);
                    }
                } else if (this.isNativeFunctionCall) {
                    List<ValueArgument> list9 = arguments2;
                    Intrinsics.checkExpressionValueIsNotNull(list9, "arguments");
                    TranslationContext translationContext = argContext;
                    Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                    CallArgumentTranslator.Companion.translateValueArguments(list9, result2, translationContext);
                } else {
                    List<ValueArgument> list10 = arguments2;
                    Intrinsics.checkExpressionValueIsNotNull(list10, "arguments");
                    TranslationContext translationContext = argContext;
                    Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                    CallArgumentTranslator.Companion.translateVarargArgument(list10, result2, translationContext, true);
                }
            } else {
                Object object = actualArgument;
                Intrinsics.checkExpressionValueIsNotNull(object, "actualArgument");
                TranslationContext translationContext = argContext;
                Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                CallArgumentTranslator.Companion.translateSingleArgument((ResolvedValueArgument)object, result2, translationContext);
            }
            this.context().moveVarsFrom(argContext);
            argContexts.add(argContext);
            argumentsShouldBeExtractedToTmpVars = argumentsShouldBeExtractedToTmpVars || !argContext.currentBlockIsEmpty();
        }
        if (argumentsShouldBeExtractedToTmpVars) {
            List list11 = argContexts;
            TranslationContext translationContext = this.context();
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
            CallArgumentTranslator.Companion.extractArguments(result2, list11, translationContext);
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            boolean bl = argsBeforeVararg != null;
            if (_Assertions.ENABLED && !bl) {
                actualArgument = "argsBeforeVararg should not be null";
                throw (Throwable)((Object)new AssertionError(actualArgument));
            }
            bl = concatArguments != null;
            if (_Assertions.ENABLED && !bl) {
                actualArgument = "concatArguments should not be null";
                throw (Throwable)((Object)new AssertionError(actualArgument));
            }
            List list12 = concatArguments;
            if (list12 == null) {
                Intrinsics.throwNpe();
            }
            list12.addAll(result2);
            List list13 = argsBeforeVararg;
            if (list13 == null) {
                Intrinsics.throwNpe();
            }
            if (!list13.isEmpty()) {
                JsArrayLiteral jsArrayLiteral = new JsArrayLiteral(argsBeforeVararg);
                int n = 0;
                List list14 = concatArguments;
                JsArrayLiteral $receiver = jsArrayLiteral;
                MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                JsArrayLiteral jsArrayLiteral2 = jsArrayLiteral;
                list14.add(n, jsArrayLiteral2);
            }
            result2 = new SmartList<JsExpression>(CallArgumentTranslator.Companion.concatArgumentsIfNeeded(concatArguments));
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                JsNameRef jsNameRef = cachedReceiver.reference();
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "cachedReceiver.reference()");
                result2.add(0, jsNameRef);
            } else {
                JsNullLiteral jsNullLiteral = JsLiteral.NULL;
                Intrinsics.checkExpressionValueIsNotNull(jsNullLiteral, "JsLiteral.NULL");
                result2.add(0, jsNullLiteral);
            }
        }
        this.removeLastUndefinedArguments(result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver, null, 8, null);
    }

    private CallArgumentTranslator(ResolvedCall<?> resolvedCall2, JsExpression receiver, TranslationContext context) {
        super(context);
        this.resolvedCall = resolvedCall2;
        this.receiver = receiver;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject((DeclarationDescriptor)this.resolvedCall.getCandidateDescriptor());
    }

    public /* synthetic */ CallArgumentTranslator(@NotNull ResolvedCall resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context, DefaultConstructorMarker $constructor_marker) {
        this(resolvedCall2, receiver, context);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return Companion.translate(resolvedCall2, receiver, context);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context, @NotNull JsBlock block) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        return Companion.translate(resolvedCall2, receiver, context, block);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "", "valueArguments", "", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "hasSpreadOperator", "", "cachedReceiver", "Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "reifiedArguments", "(Ljava/util/List;ZLorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;Ljava/util/List;)V", "getCachedReceiver", "()Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "getHasSpreadOperator", "()Z", "getReifiedArguments", "()Ljava/util/List;", "translateArguments", "getTranslateArguments", "getValueArguments", "component1", "component2", "component3", "component4", "copy", "kotlin-compiler"})
    public static final class ArgumentsInfo {
        @NotNull
        private final List<JsExpression> valueArguments;
        private final boolean hasSpreadOperator;
        @Nullable
        private final TemporaryConstVariable cachedReceiver;
        @NotNull
        private final List<JsExpression> reifiedArguments;

        @NotNull
        public final List<JsExpression> getTranslateArguments() {
            return CollectionsKt.plus((Collection)this.reifiedArguments, (Iterable)this.valueArguments);
        }

        @NotNull
        public final List<JsExpression> getValueArguments() {
            return this.valueArguments;
        }

        public final boolean getHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> getReifiedArguments() {
            return this.reifiedArguments;
        }

        public ArgumentsInfo(@NotNull List<? extends JsExpression> valueArguments2, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkParameterIsNotNull(valueArguments2, "valueArguments");
            Intrinsics.checkParameterIsNotNull(reifiedArguments, "reifiedArguments");
            this.valueArguments = valueArguments2;
            this.hasSpreadOperator = hasSpreadOperator;
            this.cachedReceiver = cachedReceiver;
            this.reifiedArguments = reifiedArguments;
        }

        public /* synthetic */ ArgumentsInfo(List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            ArgumentsInfo argumentsInfo = this;
            List list4 = list2;
            boolean bl2 = bl;
            TemporaryConstVariable temporaryConstVariable2 = temporaryConstVariable;
            if ((n & 8) != 0) {
                TemporaryConstVariable temporaryConstVariable3 = temporaryConstVariable2;
                boolean bl3 = bl2;
                List list5 = list4;
                ArgumentsInfo argumentsInfo2 = argumentsInfo;
                List list6 = CollectionsKt.emptyList();
                argumentsInfo = argumentsInfo2;
                list4 = list5;
                bl2 = bl3;
                temporaryConstVariable2 = temporaryConstVariable3;
                list3 = list6;
            }
            argumentsInfo(list4, bl2, temporaryConstVariable2, list3);
        }

        @NotNull
        public final List<JsExpression> component1() {
            return this.valueArguments;
        }

        public final boolean component2() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable component3() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> component4() {
            return this.reifiedArguments;
        }

        @NotNull
        public final ArgumentsInfo copy(@NotNull List<? extends JsExpression> valueArguments2, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkParameterIsNotNull(valueArguments2, "valueArguments");
            Intrinsics.checkParameterIsNotNull(reifiedArguments, "reifiedArguments");
            return new ArgumentsInfo(valueArguments2, hasSpreadOperator, cachedReceiver, reifiedArguments);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ArgumentsInfo copy$default(ArgumentsInfo argumentsInfo, List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                list2 = argumentsInfo.valueArguments;
            }
            if ((n & 2) != 0) {
                bl = argumentsInfo.hasSpreadOperator;
            }
            if ((n & 4) != 0) {
                temporaryConstVariable = argumentsInfo.cachedReceiver;
            }
            if ((n & 8) != 0) {
                list3 = argumentsInfo.reifiedArguments;
            }
            return argumentsInfo.copy(list2, bl, temporaryConstVariable, (List<? extends JsExpression>)list3);
        }

        public String toString() {
            return "ArgumentsInfo(valueArguments=" + this.valueArguments + ", hasSpreadOperator=" + this.hasSpreadOperator + ", cachedReceiver=" + this.cachedReceiver + ", reifiedArguments=" + this.reifiedArguments + ")";
        }

        public int hashCode() {
            List<JsExpression> list2 = this.valueArguments;
            int n = (list2 != null ? ((Object)list2).hashCode() : 0) * 31;
            int n2 = this.hasSpreadOperator ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            TemporaryConstVariable temporaryConstVariable = this.cachedReceiver;
            List<JsExpression> list3 = this.reifiedArguments;
            return ((n + n2) * 31 + (temporaryConstVariable != null ? temporaryConstVariable.hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArgumentsInfo)) break block3;
                    ArgumentsInfo argumentsInfo = (ArgumentsInfo)object;
                    if (!Intrinsics.areEqual(this.valueArguments, argumentsInfo.valueArguments) || !(this.hasSpreadOperator == argumentsInfo.hasSpreadOperator) || !Intrinsics.areEqual(this.cachedReceiver, argumentsInfo.cachedReceiver) || !Intrinsics.areEqual(this.reifiedArguments, argumentsInfo.reifiedArguments)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J,\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\fH\u0002J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J&\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\fH\u0007J.\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J&\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\fH\u0002J,\u0010\u001d\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\fH\u0002J4\u0010\u001e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion;", "", "()V", "concatArgumentsIfNeeded", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "concatArguments", "", "extractArguments", "", "argExpressions", "", "argContexts", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "context", "prepareConcatArguments", "arguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "list", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "block", "Lcom/google/dart/compiler/backend/js/ast/JsBlock;", "translateSingleArgument", "actualArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "result", "translateValueArguments", "translateVarargArgument", "shouldWrapVarargInArray", "", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBlock jsBlock = context.dynamicContext().jsBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "context.dynamicContext().jsBlock()");
            return this.translate(resolvedCall2, receiver, context, jsBlock);
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context, @NotNull JsBlock block) {
            TranslationContext innerContext;
            Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull(block, "block");
            TranslationContext translationContext = innerContext = context.innerBlock(block);
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "innerContext");
            CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall2, receiver, translationContext, null);
            ArgumentsInfo result2 = argumentTranslator.translate();
            context.moveVarsFrom(innerContext);
            Object callDescriptor = resolvedCall2.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(callDescriptor)) {
                Map<TypeParameterDescriptor, KotlinType> typeArgs = resolvedCall2.getTypeArguments();
                return CallArgumentTranslatorKt.access$addReifiedTypeArgsTo(typeArgs, result2, context);
            }
            return result2;
        }

        private final void translateSingleArgument(ResolvedValueArgument actualArgument, List<JsExpression> result2, TranslationContext context) {
            JsExpression jsExpression;
            List<ValueArgument> valueArguments2 = actualArgument.getArguments();
            if (actualArgument instanceof DefaultValueArgument) {
                Collection collection = result2;
                JsExpression jsExpression2 = Namer.getUndefinedExpression();
                collection.add(jsExpression2);
                return;
            }
            boolean bl = actualArgument instanceof ExpressionValueArgument;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = valueArguments2.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpression ktExpression = valueArguments2.get(0).getArgumentExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression argumentExpression = ktExpression;
            JsExpression jsExpression3 = jsExpression = Translation.translateAsExpression(argumentExpression, context);
            Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "jsExpression");
            result2.add(jsExpression3);
        }

        private final void translateVarargArgument(List<? extends ValueArgument> arguments2, List<JsExpression> result2, TranslationContext context, boolean shouldWrapVarargInArray) {
            if (arguments2.isEmpty()) {
                if (shouldWrapVarargInArray) {
                    JsArrayLiteral jsArrayLiteral;
                    JsArrayLiteral jsArrayLiteral2 = jsArrayLiteral;
                    JsArrayLiteral jsArrayLiteral3 = jsArrayLiteral;
                    List list2 = result2;
                    List<JsExpression> list3 = CollectionsKt.emptyList();
                    jsArrayLiteral2(list3);
                    JsArrayLiteral jsArrayLiteral4 = jsArrayLiteral3;
                    JsArrayLiteral $receiver = jsArrayLiteral4;
                    MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                    jsArrayLiteral3 = jsArrayLiteral4;
                    list2.add(jsArrayLiteral3);
                }
                return;
            }
            List list4 = shouldWrapVarargInArray ? (arguments2.size() == 1 ? (List)new SmartList() : (List)new ArrayList(arguments2.size())) : result2;
            this.translateValueArguments(arguments2, list4, context);
            if (shouldWrapVarargInArray) {
                List<JsExpression> concatArguments = this.prepareConcatArguments(arguments2, list4);
                JsExpression concatExpression = this.concatArgumentsIfNeeded(concatArguments);
                result2.add(concatExpression);
            } else if (result2.size() == 1) {
                JsInvocation jsInvocation = JsAstUtils.invokeMethod((JsExpression)result2.get(0), "slice", new JsExpression[0]);
                Intrinsics.checkExpressionValueIsNotNull(jsInvocation, "JsAstUtils.invokeMethod(result[0], \"slice\")");
                result2.set(0, jsInvocation);
            }
        }

        private final void translateValueArguments(List<? extends ValueArgument> arguments2, List<JsExpression> list2, TranslationContext context) {
            SmartList<TranslationContext> argContexts = new SmartList<TranslationContext>();
            boolean argumentsShouldBeExtractedToTmpVars = false;
            for (ValueArgument valueArgument : arguments2) {
                KtExpression argumentExpression;
                JsExpression argExpression;
                if (valueArgument.getArgumentExpression() == null) {
                    Intrinsics.throwNpe();
                }
                TranslationContext argContext = context.innerBlock();
                JsExpression jsExpression = argExpression = Translation.translateAsExpression(argumentExpression, argContext);
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "argExpression");
                list2.add(jsExpression);
                context.moveVarsFrom(argContext);
                argContexts.add(argContext);
                argumentsShouldBeExtractedToTmpVars = argumentsShouldBeExtractedToTmpVars || !argContext.currentBlockIsEmpty();
            }
            if (argumentsShouldBeExtractedToTmpVars) {
                this.extractArguments(list2, (List<? extends TranslationContext>)argContexts, context);
            }
        }

        private final JsExpression concatArgumentsIfNeeded(List<? extends JsExpression> concatArguments) {
            boolean bl = concatArguments.size() > 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "concatArguments.size should not be 0";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (concatArguments.size() > 1) {
                return new JsInvocation((JsExpression)new JsNameRef("concat", concatArguments.get(0)), concatArguments.subList(1, concatArguments.size()));
            }
            return concatArguments.get(0);
        }

        /*
         * WARNING - void declaration
         */
        private final List<JsExpression> prepareConcatArguments(List<? extends ValueArgument> arguments2, List<? extends JsExpression> list2) {
            JsArrayLiteral jsArrayLiteral;
            SmartList<JsExpression> smartList;
            boolean bl = arguments2.size() != 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "arguments.size should not be 0";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = arguments2.size() == list2.size();
            if (_Assertions.ENABLED && !bl) {
                String string = "arguments.size: " + arguments2.size() + " != list.size: " + list2.size();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            SmartList<JsExpression> concatArguments = new SmartList<JsExpression>();
            List lastArrayContent = new SmartList();
            int n = 0;
            int size = arguments2.size();
            int n2 = size - 1;
            if (n <= n2) {
                while (true) {
                    void index2;
                    ValueArgument valueArgument = arguments2.get((int)index2);
                    JsExpression expressionArgument = list2.get((int)index2);
                    if (valueArgument.getSpreadElement() != null) {
                        if (lastArrayContent.size() > 0) {
                            JsArrayLiteral jsArrayLiteral2 = new JsArrayLiteral(lastArrayContent);
                            smartList = concatArguments;
                            JsArrayLiteral $receiver = jsArrayLiteral2;
                            MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                            jsArrayLiteral = jsArrayLiteral2;
                            smartList.add(jsArrayLiteral);
                            concatArguments.add(expressionArgument);
                            lastArrayContent = new SmartList();
                        } else {
                            concatArguments.add(expressionArgument);
                        }
                    } else {
                        lastArrayContent.add(expressionArgument);
                    }
                    if (index2 == n2) break;
                    ++index2;
                }
            }
            if (lastArrayContent.size() > 0) {
                JsArrayLiteral jsArrayLiteral3 = new JsArrayLiteral(lastArrayContent);
                smartList = concatArguments;
                JsArrayLiteral $receiver = jsArrayLiteral3;
                MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                jsArrayLiteral = jsArrayLiteral3;
                smartList.add(jsArrayLiteral);
            }
            return concatArguments;
        }

        /*
         * WARNING - void declaration
         */
        private final void extractArguments(List<JsExpression> argExpressions, List<? extends TranslationContext> argContexts, TranslationContext context) {
            int n = 0;
            int n2 = ((Collection)argExpressions).size() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    TranslationContext argContext = argContexts.get((int)i);
                    JsExpression jsArgExpression = argExpressions.get((int)i);
                    if (argContext.currentBlockIsEmpty() && TranslationUtils.isCacheNeeded(jsArgExpression)) {
                        JsExpression jsExpression = context.defineTemporary(jsArgExpression);
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "context.defineTemporary(jsArgExpression)");
                        argExpressions.set((int)i, jsExpression);
                    } else {
                        context.addStatementsToCurrentBlockFrom(argContext);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

