/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.LazyJavaTypeResolver;
import org.jetbrains.kotlin.load.java.sam.SamAdapterConstructorDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterFunctionDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JavaResolverUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

public class SingleAbstractMethodUtils {
    private SingleAbstractMethodUtils() {
    }

    @NotNull
    public static List<CallableMemberDescriptor> getAbstractMembers(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getAbstractMembers"));
        }
        ArrayList<CallableMemberDescriptor> abstractMembers = new ArrayList<CallableMemberDescriptor>();
        for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors(type2.getMemberScope())) {
            if (!(member instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)member).getModality() != Modality.ABSTRACT) continue;
            abstractMembers.add((CallableMemberDescriptor)member);
        }
        ArrayList<CallableMemberDescriptor> arrayList = abstractMembers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getAbstractMembers"));
        }
        return arrayList;
    }

    @Nullable
    public static KotlinType getFunctionTypeForSamType(@NotNull KotlinType samType) {
        KotlinType functionTypeDefault;
        if (samType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samType", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForSamType"));
        }
        ClassifierDescriptor classifier2 = samType.getConstructor().getDeclarationDescriptor();
        if (classifier2 instanceof JavaClassDescriptor && (functionTypeDefault = ((JavaClassDescriptor)classifier2).getFunctionTypeForSamInterface()) != null) {
            KotlinType noProjectionsSamType = SingleAbstractMethodUtilsKt.nonProjectionParametrization(samType);
            if (noProjectionsSamType == null) {
                return null;
            }
            KotlinType type2 = TypeSubstitutor.create(noProjectionsSamType).substitute(functionTypeDefault, Variance.IN_VARIANCE);
            assert (type2 != null) : "Substitution based on type with no projections '" + noProjectionsSamType + "' should not end with conflict";
            if (FlexibleTypesKt.isNullabilityFlexible(samType)) {
                return LazyJavaTypeResolver.FlexibleJavaClassifierTypeFactory.INSTANCE.create(type2, TypeUtils.makeNullable(type2));
            }
            return TypeUtils.makeNullableAsSpecified(type2, samType.isMarkedNullable());
        }
        return null;
    }

    @NotNull
    public static KotlinType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForAbstractMethod"));
        }
        KotlinType returnType = function.getReturnType();
        assert (returnType != null) : "function is not initialized: " + function;
        List<ValueParameterDescriptor> valueParameters = function.getValueParameters();
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters.size());
        for (ValueParameterDescriptor parameter : valueParameters) {
            parameterTypes.add(parameter.getType());
        }
        KotlinType kotlinType = FunctionTypeResolveUtilsKt.createFunctionType(DescriptorUtilsKt.getBuiltIns(function), Annotations.Companion.getEMPTY(), null, parameterTypes, returnType);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForAbstractMethod"));
        }
        return kotlinType;
    }

    @Nullable
    public static FunctionDescriptor getSingleAbstractMethodOrNull(@NotNull ClassDescriptor klass) {
        CallableMemberDescriptor member;
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getSingleAbstractMethodOrNull"));
        }
        if (klass.getKind() != ClassKind.INTERFACE) {
            return null;
        }
        List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(klass.getDefaultType());
        if (abstractMembers.size() == 1 && (member = abstractMembers.get(0)) instanceof SimpleFunctionDescriptor) {
            return member.getTypeParameters().isEmpty() ? (FunctionDescriptor)member : null;
        }
        return null;
    }

    @NotNull
    public static SamConstructorDescriptor createSamConstructorFunction(@NotNull DeclarationDescriptor owner, @NotNull JavaClassDescriptor samInterface) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        if (samInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samInterface", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        assert (SingleAbstractMethodUtils.getSingleAbstractMethodOrNull(samInterface) != null) : samInterface;
        SamConstructorDescriptor result2 = new SamConstructorDescriptor(owner, samInterface);
        TypeParameters typeParameters = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(samInterface.getTypeConstructor().getParameters(), result2);
        KotlinType parameterTypeUnsubstituted = SingleAbstractMethodUtils.getFunctionTypeForSamType(samInterface.getDefaultType());
        assert (parameterTypeUnsubstituted != null) : "couldn't get function type for SAM type " + samInterface.getDefaultType();
        KotlinType parameterType = typeParameters.substitutor.substitute(parameterTypeUnsubstituted, Variance.IN_VARIANCE);
        assert (parameterType != null) : "couldn't substitute type: " + parameterTypeUnsubstituted + ", substitutor = " + typeParameters.substitutor;
        ValueParameterDescriptorImpl parameter = new ValueParameterDescriptorImpl(result2, null, 0, Annotations.Companion.getEMPTY(), Name.identifier("function"), parameterType, false, false, false, null, SourceElement.NO_SOURCE);
        KotlinType returnType = typeParameters.substitutor.substitute(samInterface.getDefaultType(), Variance.OUT_VARIANCE);
        assert (returnType != null) : "couldn't substitute type: " + samInterface.getDefaultType() + ", substitutor = " + typeParameters.substitutor;
        result2.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, typeParameters.descriptors, Collections.singletonList(parameter), returnType, Modality.FINAL, samInterface.getVisibility());
        SamConstructorDescriptor samConstructorDescriptor = result2;
        if (samConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        return samConstructorDescriptor;
    }

    public static boolean isSamType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "isSamType"));
        }
        return SingleAbstractMethodUtils.getFunctionTypeForSamType(type2) != null;
    }

    public static boolean isSamAdapterNecessary(@NotNull FunctionDescriptor fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "isSamAdapterNecessary"));
        }
        for (ValueParameterDescriptor param : fun.getValueParameters()) {
            if (!SingleAbstractMethodUtils.isSamType(param.getType())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SamAdapterDescriptor<JavaMethodDescriptor> createSamAdapterFunction(final @NotNull JavaMethodDescriptor original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamAdapterFunction"));
        }
        final SamAdapterFunctionDescriptor result2 = new SamAdapterFunctionDescriptor(original);
        SamAdapterDescriptor<JavaMethodDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull KotlinType returnType) {
                if (typeParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$1", "initialize"));
                }
                if (valueParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$1", "initialize"));
                }
                if (returnType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$1", "initialize"));
                }
                result2.initialize((KotlinType)null, original.getDispatchReceiverParameter(), typeParameters, (List)valueParameters, returnType, Modality.FINAL, original.getVisibility());
            }
        });
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamAdapterFunction"));
        }
        return samAdapterDescriptor;
    }

    @NotNull
    public static SamAdapterDescriptor<JavaConstructorDescriptor> createSamAdapterConstructor(final @NotNull JavaConstructorDescriptor original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamAdapterConstructor"));
        }
        final SamAdapterConstructorDescriptor result2 = new SamAdapterConstructorDescriptor(original);
        SamAdapterDescriptor<JavaConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull KotlinType returnType) {
                if (typeParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$2", "initialize"));
                }
                if (valueParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$2", "initialize"));
                }
                if (returnType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$2", "initialize"));
                }
                result2.initialize(valueParameters, original.getVisibility());
                result2.setReturnType(returnType);
            }
        });
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamAdapterConstructor"));
        }
        return samAdapterDescriptor;
    }

    @NotNull
    private static <F extends FunctionDescriptor> SamAdapterDescriptor<F> initSamAdapter(@NotNull F original, @NotNull SamAdapterDescriptor<F> adapter, @NotNull FunctionInitializer initializer2) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        if (initializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        TypeParameters typeParameters = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(original.getTypeParameters(), adapter);
        KotlinType returnTypeUnsubstituted = original.getReturnType();
        assert (returnTypeUnsubstituted != null) : "Creating SAM adapter for not initialized original: " + original;
        TypeSubstitutor substitutor2 = typeParameters.substitutor;
        KotlinType returnType = substitutor2.substitute(returnTypeUnsubstituted, Variance.INVARIANT);
        assert (returnType != null) : "couldn't substitute type: " + returnTypeUnsubstituted + ", substitutor = " + substitutor2;
        List<ValueParameterDescriptor> valueParameters = SingleAbstractMethodUtils.createValueParametersForSamAdapter(original, adapter, substitutor2);
        initializer2.initialize(typeParameters.descriptors, valueParameters, returnType);
        SamAdapterDescriptor<F> samAdapterDescriptor = adapter;
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        return samAdapterDescriptor;
    }

    public static List<ValueParameterDescriptor> createValueParametersForSamAdapter(@NotNull FunctionDescriptor original, @NotNull FunctionDescriptor samAdapter, @NotNull TypeSubstitutor substitutor2) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createValueParametersForSamAdapter"));
        }
        if (samAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samAdapter", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createValueParametersForSamAdapter"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createValueParametersForSamAdapter"));
        }
        List<ValueParameterDescriptor> originalValueParameters = original.getValueParameters();
        ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(originalValueParameters.size());
        for (ValueParameterDescriptor originalParam : originalValueParameters) {
            KotlinType originalType = originalParam.getType();
            KotlinType functionType = SingleAbstractMethodUtils.getFunctionTypeForSamType(originalType);
            KotlinType newTypeUnsubstituted = functionType != null ? functionType : originalType;
            KotlinType newType = substitutor2.substitute(newTypeUnsubstituted, Variance.IN_VARIANCE);
            assert (newType != null) : "couldn't substitute type: " + newTypeUnsubstituted + ", substitutor = " + substitutor2;
            ValueParameterDescriptorImpl newParam = new ValueParameterDescriptorImpl(samAdapter, null, originalParam.getIndex(), originalParam.getAnnotations(), originalParam.getName(), newType, false, false, false, null, SourceElement.NO_SOURCE);
            valueParameters.add(newParam);
        }
        return valueParameters;
    }

    @NotNull
    private static TypeParameters recreateAndInitializeTypeParameters(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        if (originalParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "recreateAndInitializeTypeParameters"));
        }
        if (newOwner instanceof SamAdapterConstructorDescriptor) {
            TypeParameters typeParameters = new TypeParameters(originalParameters, TypeSubstitutor.EMPTY);
            if (typeParameters == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "recreateAndInitializeTypeParameters"));
            }
            return typeParameters;
        }
        Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> traitToFunTypeParameters = JavaResolverUtils.recreateTypeParametersAndReturnMapping(originalParameters, newOwner);
        TypeSubstitutor typeParametersSubstitutor = JavaResolverUtils.createSubstitutorForTypeParameters(traitToFunTypeParameters);
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> mapEntry : traitToFunTypeParameters.entrySet()) {
            TypeParameterDescriptor traitTypeParameter = mapEntry.getKey();
            TypeParameterDescriptorImpl funTypeParameter = mapEntry.getValue();
            for (KotlinType upperBound : traitTypeParameter.getUpperBounds()) {
                KotlinType upperBoundSubstituted = typeParametersSubstitutor.substitute(upperBound, Variance.INVARIANT);
                assert (upperBoundSubstituted != null) : "couldn't substitute type: " + upperBound + ", substitutor = " + typeParametersSubstitutor;
                funTypeParameter.addUpperBound(upperBoundSubstituted);
            }
            funTypeParameter.setInitialized();
        }
        ArrayList<TypeParameterDescriptorImpl> typeParameters = new ArrayList<TypeParameterDescriptorImpl>(traitToFunTypeParameters.values());
        TypeParameters typeParameters2 = new TypeParameters(typeParameters, typeParametersSubstitutor);
        if (typeParameters2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "recreateAndInitializeTypeParameters"));
        }
        return typeParameters2;
    }

    private static abstract class FunctionInitializer {
        private FunctionInitializer() {
        }

        public abstract void initialize(@NotNull List<TypeParameterDescriptor> var1, @NotNull List<ValueParameterDescriptor> var2, @NotNull KotlinType var3);
    }

    private static class TypeParameters {
        public final List<TypeParameterDescriptor> descriptors;
        public final TypeSubstitutor substitutor;

        private TypeParameters(List<TypeParameterDescriptor> descriptors, TypeSubstitutor substitutor2) {
            this.descriptors = descriptors;
            this.substitutor = substitutor2;
        }
    }
}

