/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\n2\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020&J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020)J\u001c\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020.2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020+J\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u0002042\u0006\u0010\u0007\u001a\u000205J\u000e\u00106\u001a\u0002072\u0006\u0010\u0007\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "", "builtins", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "createAnnotationValue", "Lorg/jetbrains/kotlin/resolve/constants/AnnotationValue;", "value", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "createArrayValue", "Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createBooleanValue", "Lorg/jetbrains/kotlin/resolve/constants/BooleanValue;", "", "createByteValue", "Lorg/jetbrains/kotlin/resolve/constants/ByteValue;", "", "createCharValue", "Lorg/jetbrains/kotlin/resolve/constants/CharValue;", "", "createConstantValue", "createDoubleValue", "Lorg/jetbrains/kotlin/resolve/constants/DoubleValue;", "", "createEnumValue", "Lorg/jetbrains/kotlin/resolve/constants/EnumValue;", "enumEntryClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createErrorValue", "Lorg/jetbrains/kotlin/resolve/constants/ErrorValue;", "message", "", "createFloatValue", "Lorg/jetbrains/kotlin/resolve/constants/FloatValue;", "", "createIntValue", "Lorg/jetbrains/kotlin/resolve/constants/IntValue;", "", "createIntegerConstantValue", "", "expectedType", "createKClassValue", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "createLongValue", "Lorg/jetbrains/kotlin/resolve/constants/LongValue;", "createNullValue", "Lorg/jetbrains/kotlin/resolve/constants/NullValue;", "createShortValue", "Lorg/jetbrains/kotlin/resolve/constants/ShortValue;", "", "createStringValue", "Lorg/jetbrains/kotlin/resolve/constants/StringValue;", "kotlin-compiler"})
public final class ConstantValueFactory {
    private final KotlinBuiltIns builtins;

    @NotNull
    public final LongValue createLongValue(long value) {
        return new LongValue(value, this.builtins);
    }

    @NotNull
    public final IntValue createIntValue(int value) {
        return new IntValue(value, this.builtins);
    }

    @NotNull
    public final ErrorValue createErrorValue(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        return ErrorValue.Companion.create(message);
    }

    @NotNull
    public final ShortValue createShortValue(short value) {
        return new ShortValue(value, this.builtins);
    }

    @NotNull
    public final ByteValue createByteValue(byte value) {
        return new ByteValue(value, this.builtins);
    }

    @NotNull
    public final DoubleValue createDoubleValue(double value) {
        return new DoubleValue(value, this.builtins);
    }

    @NotNull
    public final FloatValue createFloatValue(float value) {
        return new FloatValue(value, this.builtins);
    }

    @NotNull
    public final BooleanValue createBooleanValue(boolean value) {
        return new BooleanValue(value, this.builtins);
    }

    @NotNull
    public final CharValue createCharValue(char value) {
        return new CharValue(value, this.builtins);
    }

    @NotNull
    public final StringValue createStringValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return new StringValue(value, this.builtins);
    }

    @NotNull
    public final NullValue createNullValue() {
        return new NullValue(this.builtins);
    }

    @NotNull
    public final EnumValue createEnumValue(@NotNull ClassDescriptor enumEntryClass) {
        Intrinsics.checkParameterIsNotNull(enumEntryClass, "enumEntryClass");
        return new EnumValue(enumEntryClass);
    }

    @NotNull
    public final ArrayValue createArrayValue(@NotNull List<? extends ConstantValue<?>> value, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return new ArrayValue(value, type2, this.builtins);
    }

    @NotNull
    public final AnnotationValue createAnnotationValue(@NotNull AnnotationDescriptor value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return new AnnotationValue(value);
    }

    @NotNull
    public final KClassValue createKClassValue(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return new KClassValue(type2);
    }

    @Nullable
    public final ConstantValue<?> createConstantValue(@Nullable Object value) {
        Object object = value;
        return object instanceof Byte ? (ConstantValue)this.createByteValue(((Number)value).byteValue()) : (object instanceof Short ? (ConstantValue)this.createShortValue(((Number)value).shortValue()) : (object instanceof Integer ? (ConstantValue)this.createIntValue(((Number)value).intValue()) : (object instanceof Long ? (ConstantValue)this.createLongValue(((Number)value).longValue()) : (object instanceof Character ? (ConstantValue)this.createCharValue(((Character)value).charValue()) : (object instanceof Float ? (ConstantValue)this.createFloatValue(((Number)value).floatValue()) : (object instanceof Double ? (ConstantValue)this.createDoubleValue(((Number)value).doubleValue()) : (object instanceof Boolean ? (ConstantValue)this.createBooleanValue((Boolean)value) : (object instanceof String ? (ConstantValue)this.createStringValue((String)value) : (Intrinsics.areEqual(object, null) ? (ConstantValue)this.createNullValue() : (ConstantValue)null)))))))));
    }

    @Nullable
    public final ConstantValue<?> createIntegerConstantValue(long value, @NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        KotlinType notNullExpected = TypeUtils.makeNotNullable(expectedType);
        return KotlinBuiltIns.isLong(notNullExpected) ? (ConstantValue)this.createLongValue(value) : (KotlinBuiltIns.isInt(notNullExpected) && value == (long)((int)value) ? (ConstantValue)this.createIntValue((int)value) : (KotlinBuiltIns.isShort(notNullExpected) && value == (long)((short)value) ? (ConstantValue)this.createShortValue((short)value) : (KotlinBuiltIns.isByte(notNullExpected) && value == (long)((byte)value) ? (ConstantValue)this.createByteValue((byte)value) : (KotlinBuiltIns.isChar(notNullExpected) ? (ConstantValue)this.createIntValue((int)value) : (ConstantValue)null))));
    }

    public ConstantValueFactory(@NotNull KotlinBuiltIns builtins) {
        Intrinsics.checkParameterIsNotNull(builtins, "builtins");
        this.builtins = builtins;
    }
}

