package Lire::Config::Object;

use strict;

use base qw/Lire::Config::Dictionary/;

use Carp;

=pod

=head1 NAME

Lire::Config::Object - Configuration value which instantiates an object.

=head1 SYNOPSIS

  use Lire::Config::Object;

=head1 DESCRIPTION

Configuration parameter which contain a bunch of named parameters
values accessible by name. The as_value() method will return an
object of the class defined in the specification. The object is
instantiated using the new_from_config() method which should be
defined in the specified class.

=cut

sub new {
    my $self = shift->SUPER::new(@_);

    croak "'spec' parameter should be a Lire::Config::ObjectSpec instance"
      unless $self->{'spec'}->isa( "Lire::Config::ObjectSpec" );

    return $self;
}

sub as_value {
    my $self = $_[0];

    eval "use " . $self->spec()->class() . ";";
    die if $@;

    return $self->spec()->class()->new_from_config( $self );
}

1; # whine, whine

__END__

=pod

=head1 AUTHORS

 Francis J. Lacoste <flacoste@logreport.org>
 Wolfgang Sourdeau <wolfgang@contre.com>

=head1 VERSION

$Id: Object.pm,v 1.5 2006/07/23 13:16:30 vanbaal Exp $

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut
