/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texosquery;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Locale;

public class TeXOSQuery {
    private static final String VERSION_NUMBER = "1.1";
    private static final String VERSION_DATE = "2016-07-14";
    private static final char BACKSLASH = '\\';
    private static final char FORWARDSLASH = '/';
    private static final long ZERO = 0L;

    private static String escapeHash(String string) {
        return string.replaceAll("#", "\\\\#");
    }

    private static String getLocale(Locale locale) {
        return TeXOSQuery.getLocale(locale, false);
    }

    private static String getLocale(Locale locale, boolean bl) {
        String string = "";
        if (locale != null) {
            String string2;
            String string3;
            String string4;
            String string5 = locale.getLanguage();
            if (string5 != null) {
                string = string5;
            }
            if ((string4 = locale.getCountry()) != null && !"".equals(string4)) {
                string = "".equals(string) ? string4 : string.concat("-").concat(string4);
            }
            if ((string3 = System.getProperty("file.encoding", "UTF-8")) != null && !"".equals(string3)) {
                if (bl) {
                    string3 = string3.toLowerCase().replaceAll("-", "");
                }
                string = string.concat(".").concat(string3);
            }
            if ((string2 = locale.getScript()) != null && !"".equals(string2)) {
                string = string.concat("@").concat(TeXOSQuery.escapeHash(string2));
            }
        }
        return string;
    }

    private static String getOSname() {
        return TeXOSQuery.getSystemProperty("os.name");
    }

    private static String getOSarch() {
        return TeXOSQuery.getSystemProperty("os.arch");
    }

    private static String getOSversion() {
        return TeXOSQuery.getSystemProperty("os.version");
    }

    private static String getUserHome() {
        return TeXOSQuery.getSystemProperty("user.home");
    }

    private static String toTeXPath(String string) {
        String string2 = "";
        if (string != null) {
            if (File.separatorChar == '\\') {
                string = string.replaceAll("\\\\", "/");
            }
            string2 = TeXOSQuery.escapeHash(string);
        }
        return string2;
    }

    private static String fromTeXPath(String string) {
        if (File.separatorChar != '/') {
            string = string.replaceAll("/", File.separator);
        }
        return string;
    }

    private static File fileFromTeXPath(String string) {
        File file = new File(string = TeXOSQuery.fromTeXPath(string));
        if (!file.exists() && file.getParent() == null) {
            try {
                InputStream inputStream;
                Process process = new ProcessBuilder("kpsewhich", string).start();
                if (process.waitFor() == 0 && (inputStream = process.getInputStream()) != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String string2 = bufferedReader.readLine();
                    bufferedReader.close();
                    if (string2 != null && !"".equals(string2)) {
                        file = new File(TeXOSQuery.fromTeXPath(string2));
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file;
    }

    private static String getCwd() {
        return TeXOSQuery.getSystemProperty("user.dir");
    }

    private static String getTmpDir() {
        return TeXOSQuery.getSystemProperty("java.io.tmpdir");
    }

    private static String pdfnow() {
        return TeXOSQuery.pdfDate(Calendar.getInstance());
    }

    private static String pdfDate(Calendar calendar) {
        String string = String.format("%1$tz", calendar);
        return String.format("D:%1$tY%1$tm%1td%1$tH%1$tM%1$tS%2$s'%3$s'", calendar, string.substring(0, 3), string.substring(3));
    }

    private static String pdfDate(File file) {
        String string = "";
        try {
            long l = file.lastModified();
            if (l > 0L) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                string = TeXOSQuery.pdfDate(calendar);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    private static String getFileLength(File file) {
        String string = "";
        try {
            long l = file.length();
            if (l > 0L) {
                string = String.format("%d", l);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    private static String getFileList(String string, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        if (file.isDirectory()) {
            try {
                String[] stringArray = file.list();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(string);
                        }
                        stringBuilder.append(TeXOSQuery.escapeHash(stringArray[i]));
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    private static String getFilterFileList(String string, final String string2, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        if (file.isDirectory()) {
            if (string2 == null || "".equals(string2)) {
                stringBuilder.append(TeXOSQuery.getFileList(string, file));
            } else {
                try {
                    String[] stringArray = file.list(new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return string.matches(string2);
                        }
                    });
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (i > 0) {
                                stringBuilder.append(string);
                            }
                            stringBuilder.append(TeXOSQuery.escapeHash(stringArray[i]));
                        }
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String fileURI(File file) {
        String string = "";
        if (file.exists()) {
            try {
                string = file.toURI().toString();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return string;
    }

    private static String filePath(File file) {
        String string = "";
        if (file.exists()) {
            try {
                string = TeXOSQuery.toTeXPath(file.getCanonicalPath());
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    private static String parentPath(File file) {
        String string = "";
        if (file.exists()) {
            try {
                string = TeXOSQuery.toTeXPath(file.getCanonicalFile().getParent());
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    private static void syntax() {
        System.out.println("Usage: texosquery <option>...");
        System.out.println();
        System.out.println("Cross-platform OS query application");
        System.out.println("for use with TeX's shell escape.");
        System.out.println();
        System.out.println("Each query displays the result in a single line.");
        System.out.println("A blank line is printed if the requested");
        System.out.println("information is unavailable.");
        System.out.println();
        System.out.println("-h or --help\tDisplay this help message and exit");
        System.out.println("-v or --version\tDisplay version information and exit");
        System.out.println();
        System.out.println("General:");
        System.out.println();
        System.out.println("-L or --locale\t\tDisplay locale information");
        System.out.println("-l or --locale-lcs\tAs --locale but codeset ");
        System.out.println("\t\t\tin lowercase with hyphens stripped");
        System.out.println("-c or --cwd\t\tDisplay current working directory");
        System.out.println("-m or --userhome\tDisplay user's home directory");
        System.out.println("-t or --tmpdir\t\tDisplay temporary directory");
        System.out.println("-o or --osname\t\tDisplay OS name");
        System.out.println("-r or --osversion\tDisplay OS version");
        System.out.println("-a or --osarch\t\tDisplay OS architecture");
        System.out.println("-n or --pdfnow\t\tDisplay current date-time in PDF format");
        System.out.println();
        System.out.println("File Queries:");
        System.out.println();
        System.out.println("Paths should use / for the directory divider.");
        System.out.println();
        System.out.println("-d <file> or --pdfdate <file>");
        System.out.println("  Display date stamp of <file> in PDF format");
        System.out.println();
        System.out.println("-s <file> or --filesize <file>");
        System.out.println("  Display size of <file> in bytes");
        System.out.println();
        System.out.println("-i <sep> <dir> or --list <sep> <dir>");
        System.out.println("  Display list of all files in <dir> separated by <sep>");
        System.out.println();
        System.out.println("-f <sep> <regex> <dir> or --filterlist <sep> <regex> <dir>");
        System.out.println("  Display list of files in <dir> that match <regex> separated by <sep>");
        System.out.println();
        System.out.println("-u <file> or --uri <file>");
        System.out.println("  Display the URI of <file>");
        System.out.println();
        System.out.println("-p <file> or --path <file>");
        System.out.println("  Display the canonical path of <file>");
        System.out.println();
        System.out.println("-e <file> or --dirname <file>");
        System.out.println("  Display the canonical path of the parent of <file>");
    }

    private static void version() {
        System.out.println(String.format("texosquery %s %s", VERSION_NUMBER, VERSION_DATE));
        System.out.println("Copyright 2016 Nicola Talbot");
        System.out.println("License LPPL 1.3+ (http://ctan.org/license/lppl1.3)");
    }

    private static void print(boolean bl, String string) {
        if (bl) {
            System.out.println(String.format("{%s}", string));
        } else {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Missing argument. Try texosquery --help");
            System.exit(1);
        }
        boolean bl = false;
        int n = stringArray.length - 1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-L") || stringArray[i].equals("--locale")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getLocale(Locale.getDefault()));
                continue;
            }
            if (stringArray[i].equals("-l") || stringArray[i].equals("--locale-lcs")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getLocale(Locale.getDefault(), true));
                continue;
            }
            if (stringArray[i].equals("-c") || stringArray[i].equals("--cwd")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getCwd());
                continue;
            }
            if (stringArray[i].equals("-m") || stringArray[i].equals("--userhome")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getUserHome());
                continue;
            }
            if (stringArray[i].equals("-t") || stringArray[i].equals("--tmpdir")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getTmpDir());
                continue;
            }
            if (stringArray[i].equals("-r") || stringArray[i].equals("--osversion")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getOSversion());
                continue;
            }
            if (stringArray[i].equals("-a") || stringArray[i].equals("--osarch")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getOSarch());
                continue;
            }
            if (stringArray[i].equals("-o") || stringArray[i].equals("--osname")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getOSname());
                continue;
            }
            if (stringArray[i].equals("-n") || stringArray[i].equals("--pdfnow")) {
                if (i < n) {
                    bl = true;
                }
                TeXOSQuery.print(bl, TeXOSQuery.pdfnow());
                continue;
            }
            if (stringArray[i].equals("-d") || stringArray[i].equals("--pdfdate")) {
                if (++i >= stringArray.length) {
                    System.err.println(String.format("filename expected after %s", stringArray[i - 1]));
                    System.exit(1);
                }
                if (i < n) {
                    bl = true;
                }
                if ("".equals(stringArray[i])) {
                    TeXOSQuery.print(bl, "");
                    continue;
                }
                TeXOSQuery.print(bl, TeXOSQuery.pdfDate(TeXOSQuery.fileFromTeXPath(stringArray[i])));
                continue;
            }
            if (stringArray[i].equals("-s") || stringArray[i].equals("--filesize")) {
                if (++i >= stringArray.length) {
                    System.err.println(String.format("filename expected after %s", stringArray[i - 1]));
                    System.exit(1);
                }
                if (i < n) {
                    bl = true;
                }
                if ("".equals(stringArray[i])) {
                    TeXOSQuery.print(bl, "");
                    continue;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getFileLength(TeXOSQuery.fileFromTeXPath(stringArray[i])));
                continue;
            }
            if (stringArray[i].equals("-i") || stringArray[i].equals("--list")) {
                if (++i >= stringArray.length) {
                    System.err.println(String.format("separator and directory name expected after %s", stringArray[i - 1]));
                    System.exit(1);
                }
                if (++i >= stringArray.length) {
                    System.err.println(String.format("directory name expected after %s %s", stringArray[i - 2], stringArray[i - 1]));
                    System.exit(1);
                }
                if (i < n) {
                    bl = true;
                }
                if ("".equals(stringArray[i])) {
                    TeXOSQuery.print(bl, "");
                    continue;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getFileList(stringArray[i - 1], new File(TeXOSQuery.fromTeXPath(stringArray[i]))));
                continue;
            }
            if (stringArray[i].equals("-f") || stringArray[i].equals("--filterlist")) {
                if (++i >= stringArray.length) {
                    System.err.println(String.format("separator, regex and directory name expected after %s", stringArray[i - 1]));
                    System.exit(1);
                }
                if (++i >= stringArray.length) {
                    System.err.println(String.format("regex and directory name expected after %s %s", stringArray[i - 2], stringArray[i - 1]));
                    System.exit(1);
                }
                if (++i >= stringArray.length) {
                    System.err.println(String.format("directory name expected after %s %s", stringArray[i - 3], stringArray[i - 2], stringArray[i - 1]));
                    System.exit(1);
                }
                if (i < n) {
                    bl = true;
                }
                if ("".equals(stringArray[i])) {
                    TeXOSQuery.print(bl, "");
                    continue;
                }
                TeXOSQuery.print(bl, TeXOSQuery.getFilterFileList(stringArray[i - 2], stringArray[i - 1], new File(TeXOSQuery.fromTeXPath(stringArray[i]))));
                continue;
            }
            if (stringArray[i].equals("-u") || stringArray[i].equals("--uri")) {
                if (++i >= stringArray.length) {
                    System.err.println(String.format("filename expected after %s", stringArray[i - 1]));
                    System.exit(1);
                }
                if (i < n) {
                    bl = true;
                }
                if ("".equals(stringArray[i])) {
                    TeXOSQuery.print(bl, "");
                    continue;
                }
                TeXOSQuery.print(bl, TeXOSQuery.fileURI(TeXOSQuery.fileFromTeXPath(stringArray[i])));
                continue;
            }
            if (stringArray[i].equals("-p") || stringArray[i].equals("--path")) {
                if (++i >= stringArray.length) {
                    System.err.println(String.format("filename expected after %s", stringArray[i - 1]));
                    System.exit(1);
                }
                if (i < n) {
                    bl = true;
                }
                if ("".equals(stringArray[i])) {
                    TeXOSQuery.print(bl, "");
                    continue;
                }
                TeXOSQuery.print(bl, TeXOSQuery.filePath(TeXOSQuery.fileFromTeXPath(stringArray[i])));
                continue;
            }
            if (stringArray[i].equals("-e") || stringArray[i].equals("--dirname")) {
                if (++i >= stringArray.length) {
                    System.err.println(String.format("filename expected after %s", stringArray[i - 1]));
                    System.exit(1);
                }
                if (i < n) {
                    bl = true;
                }
                if ("".equals(stringArray[i])) {
                    TeXOSQuery.print(bl, "");
                    continue;
                }
                TeXOSQuery.print(bl, TeXOSQuery.parentPath(TeXOSQuery.fileFromTeXPath(stringArray[i])));
                continue;
            }
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help")) {
                TeXOSQuery.syntax();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-v") || stringArray[i].equals("--version")) {
                TeXOSQuery.version();
                System.exit(0);
                continue;
            }
            System.err.println(String.format("unknown option '%s'", stringArray[i]));
            System.exit(1);
        }
    }

    private static String getSystemProperty(String string) {
        String string2 = "";
        try {
            string2 = System.getProperty(string, "");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2;
    }
}

