/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.Utils;

public final class QuadTiling {
    public static final int NR_LEVELS = 24;
    public static final double WORLD_PARTS = 1.6777216E7;
    public static final int TILES_PER_LEVEL_SHIFT = 2;
    public static final int TILES_PER_LEVEL = 4;
    public static final int X_PARTS = 360;
    public static final int X_BIAS = -180;
    public static final int Y_PARTS = 180;
    public static final int Y_BIAS = -90;

    private QuadTiling() {
    }

    public static LatLon tile2LatLon(long l) {
        double d = 180.0;
        double d2 = 90.0;
        long l2 = 46L;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < 24; ++i) {
            long l3 = l >> (int)l2 & 3L;
            if ((l3 & 2L) != 0L) {
                d3 += d;
            }
            if ((l3 & 1L) != 0L) {
                d4 += d2;
            }
            d /= 2.0;
            d2 /= 2.0;
            l2 -= 2L;
        }
        return new LatLon(d4 += -90.0, d3 += -180.0);
    }

    static long xy2tile(long l, long l2) {
        long l3 = 0L;
        for (int i = 23; i >= 0; --i) {
            long l4 = l >> i & 1L;
            long l5 = l2 >> i & 1L;
            l3 <<= 2;
            l3 |= l4 << 1 | l5;
        }
        return l3;
    }

    static long lon2x(double d) {
        long l = (long)((d + 180.0) * 1.6777216E7 / 360.0);
        if (Utils.equalsEpsilon(l, 1.6777216E7)) {
            --l;
        }
        return l;
    }

    static long lat2y(double d) {
        long l = (long)((d + 90.0) * 1.6777216E7 / 180.0);
        if (Utils.equalsEpsilon(l, 1.6777216E7)) {
            --l;
        }
        return l;
    }

    public static long quadTile(LatLon latLon) {
        return QuadTiling.xy2tile(QuadTiling.lon2x(latLon.lon()), QuadTiling.lat2y(latLon.lat()));
    }

    public static int index(int n, long l) {
        long l2 = 3L;
        int n2 = 2 * (24 - n - 1);
        return (int)(l2 & l >> n2);
    }

    public static int index(LatLon latLon, int n) {
        if (latLon == null) {
            return 0;
        }
        return QuadTiling.index(latLon.lat(), latLon.lon(), n);
    }

    public static int index(double d, double d2, int n) {
        long l = QuadTiling.lon2x(d2);
        long l2 = QuadTiling.lat2y(d);
        int n2 = 24 - n - 1;
        return (int)((l >> n2 & 1L) * 2L + (l2 >> n2 & 1L));
    }
}

