-- EFL LuaJIT bindings: elm_photocam.eo (class Elm.Photocam)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_photocam_class_get()
    eo.class_register("Elm_Photocam", {"Elm_Widget"}, {"Elm_Interface_Scrollable", "Elm_Interface_Atspi_Widget_Action", "Efl_File", "Efl_Ui_Clickable", "Efl_Ui_Scrollable", "Efl_Ui_Zoomable"}, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_photocam_class_get(void);
    void elm_obj_photocam_paused_set(Eina_Bool paused);
    Eina_Bool elm_obj_photocam_paused_get(void);
    void elm_obj_photocam_gesture_enabled_set(Eina_Bool gesture);
    Eina_Bool elm_obj_photocam_gesture_enabled_get(void);
    void elm_obj_photocam_zoom_set(double zoom);
    double elm_obj_photocam_zoom_get(void);
    void elm_obj_photocam_zoom_mode_set(Elm_Photocam_Zoom_Mode mode);
    Elm_Photocam_Zoom_Mode elm_obj_photocam_zoom_mode_get(void);
    void elm_obj_photocam_image_region_get(int *x, int *y, int *w, int *h);
    Efl_Canvas_Object *elm_obj_photocam_internal_image_get(void);
    void elm_obj_photocam_image_size_get(int *w, int *h);
    void elm_obj_photocam_image_orient_set(Evas_Image_Orient orient);
    Evas_Image_Orient elm_obj_photocam_image_orient_get(void);
    void elm_obj_photocam_image_region_show(int x, int y, int w, int h);
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_PRESS;
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_LOAD;
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_LOADED;
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_LOAD_DETAIL;
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_LOADED_DETAIL;
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_DOWNLOAD_START;
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_DOWNLOAD_PROGRESS;
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_DOWNLOAD_DONE;
    extern const Eo_Event_Description _ELM_PHOTOCAM_EVENT_DOWNLOAD_ERROR;
]]

__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    paused_set = function(self, paused)
        eo.__do_start(self, __class)
        __lib.elm_obj_photocam_paused_set(paused)
        eo.__do_end()
    end,

    paused_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_photocam_paused_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    gesture_enabled_set = function(self, gesture)
        eo.__do_start(self, __class)
        __lib.elm_obj_photocam_gesture_enabled_set(gesture)
        eo.__do_end()
    end,

    gesture_enabled_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_photocam_gesture_enabled_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    zoom_set = function(self, zoom)
        eo.__do_start(self, __class)
        __lib.elm_obj_photocam_zoom_set(zoom)
        eo.__do_end()
    end,

    zoom_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_photocam_zoom_get()
        eo.__do_end()
        return tonumber(v)
    end,

    zoom_mode_set = function(self, mode)
        eo.__do_start(self, __class)
        __lib.elm_obj_photocam_zoom_mode_set(mode)
        eo.__do_end()
    end,

    zoom_mode_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_photocam_zoom_mode_get()
        eo.__do_end()
        return v
    end,

    image_region_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("int[1]")
        local y = ffi.new("int[1]")
        local w = ffi.new("int[1]")
        local h = ffi.new("int[1]")
        __lib.elm_obj_photocam_image_region_get(x, y, w, h)
        eo.__do_end()
        return tonumber(x[0]), tonumber(y[0]), tonumber(w[0]), tonumber(h[0])
    end,

    internal_image_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_photocam_internal_image_get()
        eo.__do_end()
    end,

    image_size_get = function(self)
        eo.__do_start(self, __class)
        local w = ffi.new("int[1]")
        local h = ffi.new("int[1]")
        __lib.elm_obj_photocam_image_size_get(w, h)
        eo.__do_end()
        return tonumber(w[0]), tonumber(h[0])
    end,

    image_orient_set = function(self, orient)
        eo.__do_start(self, __class)
        __lib.elm_obj_photocam_image_orient_set(orient)
        eo.__do_end()
    end,

    image_orient_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_photocam_image_orient_get()
        eo.__do_end()
        return v
    end,

    image_region_show = function(self, x, y, w, h)
        eo.__do_start(self, __class)
        __lib.elm_obj_photocam_image_region_show(x, y, w, h)
        eo.__do_end()
    end,

    __events = {
        ["press"] = __lib._ELM_PHOTOCAM_EVENT_PRESS,
        ["load"] = __lib._ELM_PHOTOCAM_EVENT_LOAD,
        ["loaded"] = __lib._ELM_PHOTOCAM_EVENT_LOADED,
        ["load,detail"] = __lib._ELM_PHOTOCAM_EVENT_LOAD_DETAIL,
        ["loaded,detail"] = __lib._ELM_PHOTOCAM_EVENT_LOADED_DETAIL,
        ["download,start"] = __lib._ELM_PHOTOCAM_EVENT_DOWNLOAD_START,
        ["download,progress"] = __lib._ELM_PHOTOCAM_EVENT_DOWNLOAD_PROGRESS,
        ["download,done"] = __lib._ELM_PHOTOCAM_EVENT_DOWNLOAD_DONE,
        ["download,error"] = __lib._ELM_PHOTOCAM_EVENT_DOWNLOAD_ERROR
    },

    __properties = {
        ["gesture_enabled"] = { 0, 0, 1, 1, true, true },
        ["image_region"] = { 0, 0, 4, 0, true, false },
        ["image_size"] = { 0, 0, 2, 0, true, false },
        ["image_orient"] = { 0, 0, 1, 1, true, true },
        ["paused"] = { 0, 0, 1, 1, true, true },
        ["zoom_mode"] = { 0, 0, 1, 1, true, true },
        ["internal_image"] = { 0, 0, 1, 0, true, false },
        ["zoom"] = { 0, 0, 1, 1, true, true }
    }
}

M.Photocam = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_Photocam").__eo_ctor,
                            1, ...)
end

return M
