-- EFL LuaJIT bindings: elm_progressbar.eo (class Elm.Progressbar)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_progressbar_class_get()
    eo.class_register("Elm_Progressbar", {"Elm_Layout"}, {"Efl_Ui_Progress", "Efl_Orientation"}, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_progressbar_class_get(void);
    void elm_obj_progressbar_pulse_set(Eina_Bool pulse);
    Eina_Bool elm_obj_progressbar_pulse_get(void);
    void elm_obj_progressbar_part_value_set(const char * part, double val);
    double elm_obj_progressbar_part_value_get(const char * part);
    void elm_obj_progressbar_pulse(Eina_Bool state);
    extern const Eo_Event_Description _ELM_PROGRESSBAR_EVENT_CHANGED;
]]

__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    pulse_set = function(self, pulse)
        eo.__do_start(self, __class)
        __lib.elm_obj_progressbar_pulse_set(pulse)
        eo.__do_end()
    end,

    pulse_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_progressbar_pulse_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    part_value_set = function(self, part, val)
        eo.__do_start(self, __class)
        __lib.elm_obj_progressbar_part_value_set(part, val)
        eo.__do_end()
    end,

    part_value_get = function(self, part)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_progressbar_part_value_get(part)
        eo.__do_end()
        return tonumber(v)
    end,

    pulse = function(self, state)
        eo.__do_start(self, __class)
        __lib.elm_obj_progressbar_pulse(state)
        eo.__do_end()
    end,

    __events = {
        ["changed"] = __lib._ELM_PROGRESSBAR_EVENT_CHANGED
    },

    __properties = {
        ["pulse"] = { 0, 0, 1, 1, true, true }
    }
}

M.Progressbar = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_Progressbar").__eo_ctor,
                            1, ...)
end

return M
