/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;

public final class DESKeyFactory
extends SecretKeyFactorySpi {
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESKey desKey = null;
        try {
            if (!(keySpec instanceof DESKeySpec)) {
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            DESKeySpec desKeySpec = (DESKeySpec)keySpec;
            desKey = new DESKey(desKeySpec.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return desKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        try {
            if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (keySpec != null && DESKeySpec.class.isAssignableFrom(keySpec)) {
                    return new DESKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof DESKey) {
                    return key;
                }
                DESKeySpec desKeySpec = (DESKeySpec)this.engineGetKeySpec(key, (Class)DESKeySpec.class);
                return this.engineGenerateSecret(desKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

