/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;

public abstract class AbstractColorChooserPanel
extends JPanel {
    private final PropertyChangeListener enabledListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                AbstractColorChooserPanel.this.setEnabled((Boolean)value);
            }
        }
    };
    private JColorChooser chooser;

    public abstract void updateChooser();

    protected abstract void buildChooser();

    public abstract String getDisplayName();

    public int getMnemonic() {
        return 0;
    }

    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    public abstract Icon getSmallDisplayIcon();

    public abstract Icon getLargeDisplayIcon();

    public void installChooserPanel(JColorChooser enclosingChooser) {
        if (this.chooser != null) {
            throw new RuntimeException("This chooser panel is already installed");
        }
        this.chooser = enclosingChooser;
        this.chooser.addPropertyChangeListener("enabled", this.enabledListener);
        this.setEnabled(this.chooser.isEnabled());
        this.buildChooser();
        this.updateChooser();
    }

    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        this.chooser.removePropertyChangeListener("enabled", this.enabledListener);
        this.chooser = null;
    }

    public ColorSelectionModel getColorSelectionModel() {
        return this.chooser != null ? this.chooser.getSelectionModel() : null;
    }

    protected Color getColorFromModel() {
        ColorSelectionModel model = this.getColorSelectionModel();
        return model != null ? model.getSelectedColor() : null;
    }

    void setSelectedColor(Color color) {
        ColorSelectionModel model = this.getColorSelectionModel();
        if (model != null) {
            model.setSelectedColor(color);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key, this.getLocale());
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

