/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.Version;
import org.elasticsearch.action.TimestampParsingException;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.EnabledAttributeMapper;
import org.elasticsearch.index.mapper.LegacyDateFieldMapper;
import org.elasticsearch.index.mapper.LegacyLongFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;

public class TimestampFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_timestamp";
    public static final String CONTENT_TYPE = "_timestamp";
    public static final String DEFAULT_DATE_TIME_FORMAT = "epoch_millis||strictDateOptionalTime";
    private EnabledAttributeMapper enabledState;
    private final String defaultTimestamp;
    private final Boolean ignoreMissing;

    private TimestampFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing != null ? existing : Defaults.FIELD_TYPE, (MappedFieldType)Defaults.FIELD_TYPE, Defaults.ENABLED, "now", null, indexSettings);
    }

    private TimestampFieldMapper(MappedFieldType fieldType, MappedFieldType defaultFieldType, EnabledAttributeMapper enabledState, String defaultTimestamp, Boolean ignoreMissing, Settings indexSettings) {
        super("_timestamp", fieldType, defaultFieldType, indexSettings);
        if (enabledState.enabled && Version.indexCreated(indexSettings).onOrAfter(Version.V_5_0_0_alpha4)) {
            throw new IllegalArgumentException("[_timestamp] is removed in 5.0. As a replacement, you can use an ingest pipeline to add a field with the current timestamp to your documents.");
        }
        this.enabledState = enabledState;
        this.defaultTimestamp = defaultTimestamp;
        this.ignoreMissing = ignoreMissing;
    }

    @Override
    public TimestampFieldType fieldType() {
        return (TimestampFieldType)super.fieldType();
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public String defaultTimestamp() {
        return this.defaultTimestamp;
    }

    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (this.enabledState.enabled) {
            long timestamp = context.sourceToParse().timestamp();
            if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
                fields.add(new LegacyLongFieldMapper.CustomLongNumericField(timestamp, (MappedFieldType)this.fieldType()));
            }
            if (this.fieldType().hasDocValues()) {
                fields.add((Field)new NumericDocValuesField(this.fieldType().name(), timestamp));
            }
        }
    }

    @Override
    protected String contentType() {
        return "_timestamp";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabledState == Defaults.ENABLED && this.fieldType().dateTimeFormatter().format().equals(Defaults.DATE_TIME_FORMATTER.format()) && "now".equals(this.defaultTimestamp)) {
            return builder;
        }
        builder.startObject("_timestamp");
        if (includeDefaults || this.enabledState != Defaults.ENABLED) {
            builder.field("enabled", this.enabledState.enabled);
        }
        String defaultDateFormat = Defaults.DATE_TIME_FORMATTER.format();
        if (includeDefaults || !this.fieldType().dateTimeFormatter().format().equals(defaultDateFormat)) {
            builder.field("format", this.fieldType().dateTimeFormatter().format());
        }
        if (includeDefaults || !"now".equals(this.defaultTimestamp)) {
            builder.field("default", this.defaultTimestamp);
        }
        if (includeDefaults || this.ignoreMissing != null) {
            builder.field("ignore_missing", this.ignoreMissing);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        TimestampFieldMapper timestampFieldMapperMergeWith = (TimestampFieldMapper)mergeWith;
        super.doMerge(mergeWith, updateAllTypes);
        if (timestampFieldMapperMergeWith.enabledState != this.enabledState && !timestampFieldMapperMergeWith.enabledState.unset()) {
            this.enabledState = timestampFieldMapperMergeWith.enabledState;
        }
        if (timestampFieldMapperMergeWith.defaultTimestamp() == null && this.defaultTimestamp == null) {
            return;
        }
        ArrayList<String> conflicts = new ArrayList<String>();
        if (this.defaultTimestamp == null) {
            conflicts.add("Cannot update default in _timestamp value. Value is null now encountering " + timestampFieldMapperMergeWith.defaultTimestamp());
        } else if (timestampFieldMapperMergeWith.defaultTimestamp() == null) {
            conflicts.add("Cannot update default in _timestamp value. Value is \" + defaultTimestamp.toString() + \" now encountering null");
        } else if (!timestampFieldMapperMergeWith.defaultTimestamp().equals(this.defaultTimestamp)) {
            conflicts.add("Cannot update default in _timestamp value. Value is " + this.defaultTimestamp.toString() + " now encountering " + timestampFieldMapperMergeWith.defaultTimestamp());
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("Conflicts: " + conflicts);
        }
    }

    public static final class TimestampFieldType
    extends LegacyDateFieldMapper.DateFieldType {
        public TimestampFieldType() {
        }

        protected TimestampFieldType(TimestampFieldType ref) {
            super(ref);
        }

        @Override
        public TimestampFieldType clone() {
            return new TimestampFieldType(this);
        }

        @Override
        public Object valueForSearch(Object value) {
            return value;
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_5_0_0_alpha4)) {
                throw new IllegalArgumentException("[_timestamp] is removed in 5.0. As a replacement, you can use an ingest pipeline to add a field with the current timestamp to your documents.");
            }
            Builder builder = new Builder(parserContext.mapperService().fullName("_timestamp"));
            boolean defaultSet = false;
            Boolean ignoreMissing = null;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    EnabledAttributeMapper enabledState = XContentMapValues.lenientNodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
                    builder.enabled(enabledState);
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("default")) {
                    if (fieldNode == null) {
                        throw new TimestampParsingException("default timestamp can not be set to null");
                    }
                    builder.defaultTimestamp(fieldNode.toString());
                    defaultSet = true;
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("ignore_missing")) continue;
                ignoreMissing = XContentMapValues.lenientNodeBooleanValue(fieldNode);
                builder.ignoreMissing(ignoreMissing);
                iterator.remove();
            }
            if (defaultSet && ignoreMissing != null && !ignoreMissing.booleanValue()) {
                throw new TimestampParsingException("default timestamp can not be set with ignore_missing set to false");
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new TimestampFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, TimestampFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;
        private String defaultTimestamp = "now";
        private Boolean ignoreMissing = null;

        public Builder(MappedFieldType existing) {
            super("_timestamp", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        @Override
        public LegacyDateFieldMapper.DateFieldType fieldType() {
            return (LegacyDateFieldMapper.DateFieldType)this.fieldType;
        }

        public Builder enabled(EnabledAttributeMapper enabledState) {
            this.enabledState = enabledState;
            return (Builder)this.builder;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.fieldType().setDateTimeFormatter(dateTimeFormatter);
            return this;
        }

        public Builder defaultTimestamp(String defaultTimestamp) {
            this.defaultTimestamp = defaultTimestamp;
            return (Builder)this.builder;
        }

        public Builder ignoreMissing(boolean ignoreMissing) {
            this.ignoreMissing = ignoreMissing;
            return (Builder)this.builder;
        }

        @Override
        public Builder store(boolean store) {
            return (Builder)super.store(store);
        }

        @Override
        public TimestampFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new TimestampFieldMapper(this.fieldType, this.defaultFieldType, this.enabledState, this.defaultTimestamp, this.ignoreMissing, context.indexSettings());
        }
    }

    public static class Defaults
    extends LegacyDateFieldMapper.Defaults {
        public static final String NAME = "_timestamp";
        public static final TimestampFieldType FIELD_TYPE = new TimestampFieldType();
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("epoch_millis||strictDateOptionalTime");
        public static final EnabledAttributeMapper ENABLED;
        public static final String DEFAULT_TIMESTAMP = "now";

        static {
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setNumericPrecisionStep(16);
            FIELD_TYPE.setName("_timestamp");
            FIELD_TYPE.setDateTimeFormatter(DATE_TIME_FORMATTER);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.freeze();
            ENABLED = EnabledAttributeMapper.UNSET_DISABLED;
        }
    }
}

