/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Collections;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParseFieldMatcherSupplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptSettings;

public class QueryRewriteContext
implements ParseFieldMatcherSupplier {
    protected final MapperService mapperService;
    protected final ScriptService scriptService;
    protected final IndexSettings indexSettings;
    protected final IndicesQueriesRegistry indicesQueriesRegistry;
    protected final Client client;
    protected final IndexReader reader;
    protected final ClusterState clusterState;

    public QueryRewriteContext(IndexSettings indexSettings, MapperService mapperService, ScriptService scriptService, IndicesQueriesRegistry indicesQueriesRegistry, Client client, IndexReader reader, ClusterState clusterState) {
        this.mapperService = mapperService;
        this.scriptService = scriptService;
        this.indexSettings = indexSettings;
        this.indicesQueriesRegistry = indicesQueriesRegistry;
        this.client = client;
        this.reader = reader;
        this.clusterState = clusterState;
    }

    public final Client getClient() {
        return this.client;
    }

    public final IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public final MapperService getMapperService() {
        return this.mapperService;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    @Override
    public ParseFieldMatcher getParseFieldMatcher() {
        return this.indexSettings.getParseFieldMatcher();
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public QueryParseContext newParseContext(XContentParser parser) {
        return new QueryParseContext(this.indicesQueriesRegistry, parser, this.indexSettings.getParseFieldMatcher());
    }

    public QueryParseContext newParseContextWithLegacyScriptLanguage(XContentParser parser) {
        String defaultScriptLanguage = ScriptSettings.getLegacyDefaultLang(this.indexSettings.getNodeSettings());
        return new QueryParseContext(defaultScriptLanguage, this.indicesQueriesRegistry, parser, this.indexSettings.getParseFieldMatcher());
    }

    public BytesReference getTemplateBytes(Script template) {
        ExecutableScript executable = this.scriptService.executable(template, ScriptContext.Standard.SEARCH, Collections.emptyMap());
        return (BytesReference)executable.run();
    }
}

