/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.geodistance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.geodistance.GeoDistanceParser;
import org.elasticsearch.search.aggregations.bucket.range.geodistance.GeoDistanceRangeAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.geodistance.InternalGeoDistance;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class GeoDistanceAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.GeoPoint, GeoDistanceAggregationBuilder> {
    public static final String NAME = "geo_distance";
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("geo_distance");
    private final GeoPoint origin;
    private List<GeoDistanceParser.Range> ranges = new ArrayList<GeoDistanceParser.Range>();
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private GeoDistance distanceType = GeoDistance.DEFAULT;
    private boolean keyed = false;

    public GeoDistanceAggregationBuilder(String name, GeoPoint origin) {
        this(name, origin, InternalGeoDistance.FACTORY);
    }

    private GeoDistanceAggregationBuilder(String name, GeoPoint origin, InternalRange.Factory<InternalGeoDistance.Bucket, InternalGeoDistance> rangeFactory) {
        super(name, rangeFactory.type(), rangeFactory.getValueSourceType(), rangeFactory.getValueType());
        if (origin == null) {
            throw new IllegalArgumentException("[origin] must not be null: [" + name + "]");
        }
        this.origin = origin;
    }

    public GeoDistanceAggregationBuilder(StreamInput in) throws IOException {
        super(in, InternalGeoDistance.FACTORY.type(), InternalGeoDistance.FACTORY.getValueSourceType(), InternalGeoDistance.FACTORY.getValueType());
        this.origin = new GeoPoint(in.readDouble(), in.readDouble());
        int size = in.readVInt();
        this.ranges = new ArrayList<GeoDistanceParser.Range>(size);
        for (int i = 0; i < size; ++i) {
            this.ranges.add(new GeoDistanceParser.Range(in));
        }
        this.keyed = in.readBoolean();
        this.distanceType = GeoDistance.readFromStream(in);
        this.unit = DistanceUnit.readFromStream(in);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.origin.lat());
        out.writeDouble(this.origin.lon());
        out.writeVInt(this.ranges.size());
        for (GeoDistanceParser.Range range : this.ranges) {
            range.writeTo(out);
        }
        out.writeBoolean(this.keyed);
        this.distanceType.writeTo(out);
        this.unit.writeTo(out);
    }

    public GeoDistanceAggregationBuilder addRange(GeoDistanceParser.Range range) {
        if (range == null) {
            throw new IllegalArgumentException("[range] must not be null: [" + this.name + "]");
        }
        this.ranges.add(range);
        return this;
    }

    public GeoDistanceAggregationBuilder addRange(String key, double from, double to) {
        this.ranges.add(new GeoDistanceParser.Range(key, from, to));
        return this;
    }

    public GeoDistanceAggregationBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public GeoDistanceAggregationBuilder addUnboundedTo(String key, double to) {
        this.ranges.add(new GeoDistanceParser.Range(key, null, to));
        return this;
    }

    public GeoDistanceAggregationBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public GeoDistanceAggregationBuilder addUnboundedFrom(String key, double from) {
        this.addRange(new GeoDistanceParser.Range(key, from, null));
        return this;
    }

    public GeoDistanceAggregationBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    public List<GeoDistanceParser.Range> range() {
        return this.ranges;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public GeoDistanceAggregationBuilder unit(DistanceUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("[unit] must not be null: [" + this.name + "]");
        }
        this.unit = unit;
        return this;
    }

    public DistanceUnit unit() {
        return this.unit;
    }

    public GeoDistanceAggregationBuilder distanceType(GeoDistance distanceType) {
        if (distanceType == null) {
            throw new IllegalArgumentException("[distanceType] must not be null: [" + this.name + "]");
        }
        this.distanceType = distanceType;
        return this;
    }

    public GeoDistance distanceType() {
        return this.distanceType;
    }

    public GeoDistanceAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.GeoPoint, ?> innerBuild(AggregationContext context, ValuesSourceConfig<ValuesSource.GeoPoint> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        GeoDistanceParser.Range[] ranges = this.ranges.toArray(new GeoDistanceParser.Range[this.range().size()]);
        return new GeoDistanceRangeAggregatorFactory(this.name, this.type, config, this.origin, ranges, this.unit, this.distanceType, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(GeoDistanceParser.ORIGIN_FIELD.getPreferredName(), this.origin);
        builder.field(RangeAggregator.RANGES_FIELD.getPreferredName(), this.ranges);
        builder.field(RangeAggregator.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(GeoDistanceParser.UNIT_FIELD.getPreferredName(), this.unit);
        builder.field(GeoDistanceParser.DISTANCE_TYPE_FIELD.getPreferredName(), this.distanceType);
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.origin, this.ranges, this.keyed, this.distanceType, this.unit);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        GeoDistanceAggregationBuilder other = (GeoDistanceAggregationBuilder)obj;
        return Objects.equals(this.origin, other.origin) && Objects.equals(this.ranges, other.ranges) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.distanceType, other.distanceType) && Objects.equals(this.unit, other.unit);
    }
}

