/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ParseFieldRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParser;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class SignificantTermsParser
extends AbstractTermsParser {
    private final ParseFieldRegistry<SignificanceHeuristicParser> significanceHeuristicParserRegistry;
    private final IndicesQueriesRegistry queriesRegistry;

    public SignificantTermsParser(ParseFieldRegistry<SignificanceHeuristicParser> significanceHeuristicParserRegistry, IndicesQueriesRegistry queriesRegistry) {
        this.significanceHeuristicParserRegistry = significanceHeuristicParserRegistry;
        this.queriesRegistry = queriesRegistry;
    }

    protected SignificantTermsAggregationBuilder doCreateFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, TermsAggregator.BucketCountThresholds bucketCountThresholds, Aggregator.SubAggCollectionMode collectMode, String executionHint, IncludeExclude incExc, Map<ParseField, Object> otherOptions) {
        SignificanceHeuristic significanceHeuristic;
        QueryBuilder backgroundFilter;
        SignificantTermsAggregationBuilder factory = new SignificantTermsAggregationBuilder(aggregationName, targetValueType);
        if (bucketCountThresholds != null) {
            factory.bucketCountThresholds(bucketCountThresholds);
        }
        if (executionHint != null) {
            factory.executionHint(executionHint);
        }
        if (incExc != null) {
            factory.includeExclude(incExc);
        }
        if ((backgroundFilter = (QueryBuilder)otherOptions.get(SignificantTermsAggregationBuilder.BACKGROUND_FILTER)) != null) {
            factory.backgroundFilter(backgroundFilter);
        }
        if ((significanceHeuristic = (SignificanceHeuristic)otherOptions.get(SignificantTermsAggregationBuilder.HEURISTIC)) != null) {
            factory.significanceHeuristic(significanceHeuristic);
        }
        return factory;
    }

    @Override
    public boolean parseSpecial(String aggregationName, XContentParseContext context, XContentParser.Token token, String currentFieldName, Map<ParseField, Object> otherOptions) throws IOException {
        if (token == XContentParser.Token.START_OBJECT) {
            SignificanceHeuristicParser significanceHeuristicParser = this.significanceHeuristicParserRegistry.lookupReturningNullIfNotFound(currentFieldName, context.getParseFieldMatcher());
            if (significanceHeuristicParser != null) {
                SignificanceHeuristic significanceHeuristic = significanceHeuristicParser.parse(context);
                otherOptions.put(SignificantTermsAggregationBuilder.HEURISTIC, significanceHeuristic);
                return true;
            }
            if (context.matchField(currentFieldName, SignificantTermsAggregationBuilder.BACKGROUND_FILTER)) {
                QueryParseContext queryParseContext = new QueryParseContext(context.getDefaultScriptLanguage(), this.queriesRegistry, context.getParser(), context.getParseFieldMatcher());
                Optional<QueryBuilder> filter = queryParseContext.parseInnerQueryBuilder();
                if (filter.isPresent()) {
                    otherOptions.put(SignificantTermsAggregationBuilder.BACKGROUND_FILTER, filter.get());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected TermsAggregator.BucketCountThresholds getDefaultBucketCountThresholds() {
        return new TermsAggregator.BucketCountThresholds(SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS);
    }
}

