/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class PluginManagerOptionPane
extends AbstractOptionPane {
    private JLabel mirrorLabel;
    private JCheckBox disableObsolete;
    private JRadioButton settingsDir;
    private JCheckBox downloadSource;
    private JCheckBox deleteDownloads;
    private JSpinner cacheForSpinner;
    private SpinnerNumberModel spinnerModel;
    private MirrorModel miraModel;
    private JList miraList;
    private JButton updateMirrors;
    private final JLabel updateStatus = new JLabel();

    public PluginManagerOptionPane() {
        super("plugin-manager");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        this.mirrorLabel = new JLabel();
        this.updateMirrorLabel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = null;
        if (jEdit.getSettingsDirectory() != null) {
            this.settingsDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.settings-dir"));
            this.settingsDir.setToolTipText(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars"));
            int n = jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 10);
            this.spinnerModel = new SpinnerNumberModel(n, 0, 240, 5);
            this.cacheForSpinner = new JSpinner(this.spinnerModel);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(new JLabel(jEdit.getProperty("options.plugin-manager.list-cache.minutes")));
            jPanel2.add(this.cacheForSpinner);
            jPanel2.add(Box.createGlue());
        }
        JRadioButton jRadioButton = new JRadioButton(jEdit.getProperty("options.plugin-manager.app-dir"));
        jRadioButton.setToolTipText(MiscUtilities.constructPath(jEdit.getJEditHome(), "jars"));
        this.miraModel = new MirrorModel();
        this.miraList = new JList(this.miraModel);
        this.miraList.setSelectionModel(new SingleSelectionModel());
        this.add("North", this.mirrorLabel);
        this.add("Center", new JScrollPane(this.miraList));
        jPanel.add(Box.createVerticalStrut(6));
        this.updateMirrors = new JButton(jEdit.getProperty("options.plugin-manager.updateMirrors"));
        this.updateMirrors.addActionListener(new ActionHandler());
        this.updateMirrors.setEnabled(false);
        ThreadUtilities.runInBackground(new UpdateMirrorsThread(false));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.updateMirrors);
        if (jPanel2 != null) {
            jPanel3.add(jPanel2);
        }
        jPanel3.add(this.updateStatus);
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(6));
        this.downloadSource = new JCheckBox(jEdit.getProperty("options.plugin-manager.downloadSource"));
        this.downloadSource.setSelected(jEdit.getBooleanProperty("plugin-manager.downloadSource"));
        this.downloadSource.setAlignmentX(0.0f);
        jPanel.add(this.downloadSource);
        this.deleteDownloads = new JCheckBox(jEdit.getProperty("options.plugin-manager.deleteDownloads"));
        this.deleteDownloads.setSelected(jEdit.getBooleanProperty("plugin-manager.deleteDownloads"));
        this.deleteDownloads.setAlignmentX(0.0f);
        jPanel.add(this.deleteDownloads);
        this.disableObsolete = new JCheckBox(jEdit.getProperty("options.plugin-manager.disable-obsolete"));
        this.disableObsolete.setSelected(jEdit.getBooleanProperty("plugin-manager.disable-obsolete", true));
        this.disableObsolete.setAlignmentX(0.0f);
        jPanel.add(this.disableObsolete);
        jPanel.add(Box.createVerticalStrut(6));
        ButtonGroup buttonGroup = new ButtonGroup();
        if (jEdit.getSettingsDirectory() != null) {
            buttonGroup.add(this.settingsDir);
        }
        buttonGroup.add(jRadioButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        if (jEdit.getSettingsDirectory() != null) {
            jPanel4.add(this.settingsDir);
            jPanel4.add(Box.createVerticalStrut(3));
        }
        jPanel4.setBorder(new TitledBorder(jEdit.getProperty("options.plugin-manager.location")));
        jPanel4.add(jRadioButton);
        jPanel4.setAlignmentX(0.0f);
        jPanel.add(jPanel4);
        jPanel.add(Box.createGlue());
        this.add("South", jPanel);
        if (jEdit.getBooleanProperty("plugin-manager.installUser") && jEdit.getSettingsDirectory() != null) {
            this.settingsDir.setSelected(true);
        } else {
            jRadioButton.setSelected(true);
        }
    }

    @Override
    protected void _save() {
        jEdit.setBooleanProperty("plugin-manager.installUser", this.settingsDir != null && this.settingsDir.isSelected());
        jEdit.setBooleanProperty("plugin-manager.downloadSource", this.downloadSource.isSelected());
        jEdit.setBooleanProperty("plugin-manager.deleteDownloads", this.deleteDownloads.isSelected());
        jEdit.setIntegerProperty("plugin-manager.list-cache.minutes", this.spinnerModel.getNumber().intValue());
        jEdit.setBooleanProperty("plugin-manager.disable-obsolete", this.disableObsolete.isSelected());
        if (this.miraList.getSelectedIndex() != -1) {
            String string = this.miraModel.getID(this.miraList.getSelectedIndex());
            String string2 = jEdit.getProperty("plugin-manager.mirror.id");
            if (!string2.equals(string)) {
                jEdit.setProperty("plugin-manager.mirror.id", string);
                jEdit.setProperty("plugin-manager.mirror.name", (String)this.miraModel.getElementAt(this.miraList.getSelectedIndex()));
                this.updateMirrorLabel();
            }
        }
    }

    private void updateMirrorLabel() {
        String string;
        String string2 = jEdit.getProperty("plugin-manager.mirror.id");
        if (string2.equals("NONE")) {
            string = "Plugin Central default";
        } else {
            string = jEdit.getProperty("plugin-manager.mirror.name");
            if (string == null) {
                string = string2;
            }
        }
        this.mirrorLabel.setText(jEdit.getProperty("options.plugin-manager.mirror") + ' ' + string);
    }

    class UpdateMirrorsThread
    extends Task {
        private final boolean download;

        UpdateMirrorsThread(boolean bl) {
            this.download = bl;
        }

        @Override
        public void _run() {
            try {
                ArrayList<MirrorList.Mirror> arrayList;
                block5: {
                    this.setStatus(jEdit.getProperty("options.plugin-manager.workthread"));
                    this.setMaximum(3L);
                    this.setValue(0L);
                    arrayList = new ArrayList<MirrorList.Mirror>();
                    try {
                        MirrorList mirrorList = new MirrorList(this.download, this);
                        if (this.download) {
                            this.saveMirrorList(mirrorList.getXml());
                        }
                        arrayList.addAll(mirrorList.getMirrors());
                    }
                    catch (Exception exception) {
                        if (!this.download) break block5;
                        Log.log(9, this, exception);
                        ThreadUtilities.runInDispatchThread(new Runnable(){

                            @Override
                            public void run() {
                                GUIUtilities.error(PluginManagerOptionPane.this, "ioerror", new String[]{exception.toString()});
                            }
                        });
                    }
                }
                ThreadUtilities.runInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        PluginManagerOptionPane.this.miraModel.setList(arrayList);
                        String string = jEdit.getProperty("plugin-manager.mirror.id");
                        int n = PluginManagerOptionPane.this.miraModel.getSize();
                        for (int i = 0; i < n; ++i) {
                            if (n != 1 && !PluginManagerOptionPane.this.miraModel.getID(i).equals(string)) continue;
                            PluginManagerOptionPane.this.miraList.setSelectedIndex(i);
                            break;
                        }
                        if (n == 0) {
                            PluginManagerOptionPane.this.miraList.clearSelection();
                        }
                    }
                });
                this.setValue(3L);
            }
            catch (Throwable throwable) {
                ThreadUtilities.runInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        PluginManagerOptionPane.this.updateMirrors.setEnabled(true);
                        PluginManagerOptionPane.this.updateStatus.setText(null);
                    }
                });
                throw throwable;
            }
            ThreadUtilities.runInDispatchThread(new /* invalid duplicate definition of identical inner class */);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveMirrorList(String string) {
            String string2 = jEdit.getSettingsDirectory();
            if (string2 == null) {
                return;
            }
            File file = new File(MiscUtilities.constructPath(string2, "mirrorList.xml"));
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                IOUtilities.copyStream(null, new ByteArrayInputStream(string.getBytes()), bufferedOutputStream, false);
            }
            catch (IOException iOException) {
                try {
                    Log.log(9, this, "Unable to write cached mirror list : " + file);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(bufferedOutputStream);
                    throw throwable;
                }
                IOUtilities.closeQuietly(bufferedOutputStream);
            }
            IOUtilities.closeQuietly(bufferedOutputStream);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PluginManagerOptionPane.this.updateMirrors.setEnabled(false);
            PluginManagerOptionPane.this.updateStatus.setText(jEdit.getProperty("options.plugin-manager.workthread"));
            ThreadUtilities.runInBackground(new UpdateMirrorsThread(true));
        }
    }

    static class SingleSelectionModel
    extends DefaultListSelectionModel {
        SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
        }
    }

    static class MirrorModel
    extends AbstractListModel {
        private List<MirrorList.Mirror> mirrors = new ArrayList<MirrorList.Mirror>();

        MirrorModel() {
        }

        public String getID(int n) {
            return this.mirrors.get((int)n).id;
        }

        @Override
        public int getSize() {
            return this.mirrors.size();
        }

        @Override
        public Object getElementAt(int n) {
            MirrorList.Mirror mirror = this.mirrors.get(n);
            if (mirror.id.equals("NONE")) {
                return jEdit.getProperty("options.plugin-manager.none");
            }
            return mirror.continent + ": " + mirror.description + " (" + mirror.location + ')';
        }

        public void setList(List<MirrorList.Mirror> list) {
            this.mirrors = list;
            this.fireContentsChanged(this, 0, list.size() - 1);
        }
    }
}

