/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.FontFace;
import com.kitfox.svg.MissingGlyph;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.util.FontSystem;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Tspan
extends ShapeElement {
    public static final String TAG_NAME = "tspan";
    float[] x = null;
    float[] y = null;
    float[] dx = null;
    float[] dy = null;
    float[] rotate = null;
    private String text = "";

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public void loaderAddText(SVGLoaderHelper sVGLoaderHelper, String string) {
        this.text = this.text + string;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getFloatList();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getFloatList();
        }
        if (this.getPres(styleAttribute.setName("dx"))) {
            this.dx = styleAttribute.getFloatList();
        }
        if (this.getPres(styleAttribute.setName("dy"))) {
            this.dy = styleAttribute.getFloatList();
        }
        if (this.getPres(styleAttribute.setName("rotate"))) {
            this.rotate = styleAttribute.getFloatList();
            for (int i = 0; i < this.rotate.length; ++i) {
                this.rotate[i] = (float)Math.toRadians(this.rotate[i]);
            }
        }
    }

    public void appendToShape(GeneralPath generalPath, Point2D point2D) throws SVGException {
        Object object;
        StyleAttribute styleAttribute = new StyleAttribute();
        String string = null;
        if (this.getStyle(styleAttribute.setName("font-family"))) {
            string = styleAttribute.getStringValue();
        }
        float f = 12.0f;
        if (this.getStyle(styleAttribute.setName("font-size"))) {
            f = styleAttribute.getFloatValueWithUnits();
        }
        float f2 = 0.0f;
        if (this.getStyle(styleAttribute.setName("letter-spacing"))) {
            f2 = styleAttribute.getFloatValueWithUnits();
        }
        int n = 0;
        if (this.getStyle(styleAttribute.setName("font-style"))) {
            String string2 = styleAttribute.getStringValue();
            if ("normal".equals(string2)) {
                n = 0;
            } else if ("italic".equals(string2)) {
                n = 1;
            } else if ("oblique".equals(string2)) {
                n = 2;
            }
        } else {
            n = 0;
        }
        int n2 = 0;
        if (this.getStyle(styleAttribute.setName("font-weight"))) {
            object = styleAttribute.getStringValue();
            if ("normal".equals(object)) {
                n2 = 0;
            } else if ("bold".equals(object)) {
                n2 = 1;
            }
        } else {
            n2 = 0;
        }
        object = this.diagram.getUniverse().getFont(string);
        if (object == null) {
            object = new FontSystem(string, n, n2, (int)f);
        }
        AffineTransform affineTransform = new AffineTransform();
        float f3 = (float)point2D.getX();
        float f4 = (float)point2D.getY();
        String string3 = this.text;
        string3 = string3.trim();
        for (int i = 0; i < string3.length(); ++i) {
            String string4;
            MissingGlyph missingGlyph;
            Shape shape;
            if (this.x != null && i < this.x.length) {
                f3 = this.x[i];
            } else if (this.dx != null && i < this.dx.length) {
                f3 += this.dx[i];
            }
            if (this.y != null && i < this.y.length) {
                f4 = this.y[i];
            } else if (this.dy != null && i < this.dy.length) {
                f4 += this.dy[i];
            }
            affineTransform.setToIdentity();
            affineTransform.setToTranslation(f3, f4);
            if (this.rotate != null) {
                affineTransform.rotate(this.rotate[i]);
            }
            if ((shape = (missingGlyph = ((Font)object).getGlyph(string4 = string3.substring(i, i + 1))).getPath()) != null) {
                shape = affineTransform.createTransformedShape(shape);
                generalPath.append(shape, false);
            }
            f3 += (float)missingGlyph.getHorizAdvX() + f2;
        }
        point2D.setLocation(f3, f4);
        this.strokeWidthScalar = 1.0f;
    }

    @Override
    public void render(Graphics2D graphics2D) throws SVGException {
        Font font;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.x != null) {
            f = this.x[0];
            f2 = this.y[0];
        } else if (this.dx != null) {
            f += this.dx[0];
            f2 += this.dy[0];
        }
        StyleAttribute styleAttribute = new StyleAttribute();
        String string = null;
        if (this.getPres(styleAttribute.setName("font-family"))) {
            string = styleAttribute.getStringValue();
        }
        float f3 = 12.0f;
        if (this.getPres(styleAttribute.setName("font-size"))) {
            f3 = styleAttribute.getFloatValueWithUnits();
        }
        if ((font = this.diagram.getUniverse().getFont(string)) == null) {
            System.err.println("Could not load font");
            java.awt.Font font2 = new java.awt.Font(string, 0, (int)f3);
            this.renderSysFont(graphics2D, font2);
            return;
        }
        FontFace fontFace = font.getFontFace();
        int n = fontFace.getAscent();
        float f4 = f3 / (float)n;
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        this.strokeWidthScalar = 1.0f / f4;
        int n2 = 1;
        for (int i = 0; i < this.text.length(); ++i) {
            affineTransform2.setToTranslation(f, f2);
            affineTransform2.scale(f4, f4);
            graphics2D.transform(affineTransform2);
            String string2 = this.text.substring(i, i + 1);
            MissingGlyph missingGlyph = font.getGlyph(string2);
            Shape shape = missingGlyph.getPath();
            if (shape != null) {
                this.renderShape(graphics2D, shape);
            } else {
                missingGlyph.render(graphics2D);
            }
            if (this.x != null && n2 < this.x.length) {
                f = this.x[n2];
                f2 = this.y[n2++];
            } else if (this.dx != null && n2 < this.dx.length) {
                f += this.dx[n2];
                f2 += this.dy[n2++];
            }
            f += f4 * (float)missingGlyph.getHorizAdvX();
            graphics2D.setTransform(affineTransform);
        }
        this.strokeWidthScalar = 1.0f;
    }

    protected void renderSysFont(Graphics2D graphics2D, java.awt.Font font) throws SVGException {
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = true;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Shape shape = font.createGlyphVector(fontRenderContext, this.text).getOutline(f, f2);
        this.renderShape(graphics2D, shape);
        Rectangle2D rectangle2D = font.getStringBounds(this.text, fontRenderContext);
        f += (float)rectangle2D.getWidth();
    }

    @Override
    public Shape getShape() {
        return null;
    }

    @Override
    public Rectangle2D getBoundingBox() {
        return null;
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        return false;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }
}

