/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.object.DynamicObject;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;

public class FrozenStrings {
    private final RubyContext context;
    private final Map<Rope, DynamicObject> frozenStrings = new WeakHashMap<Rope, DynamicObject>();

    public FrozenStrings(RubyContext context) {
        this.context = context;
    }

    public synchronized DynamicObject getFrozenString(Rope rope) {
        assert (this.context.getRopeTable().contains(rope));
        DynamicObject string = this.frozenStrings.get(rope);
        if (string == null) {
            string = StringOperations.createString(this.context, rope);
            string.define(Layouts.FROZEN_IDENTIFIER, true);
            this.frozenStrings.put(rope, string);
        }
        return string;
    }
}

