/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;

public class InheritanceSearchConstInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    String constName;
    private volatile transient ConstantCache cache;

    public InheritanceSearchConstInstr(Variable result2, Operand currentModule, String constName) {
        super(Operation.INHERITANCE_SEARCH_CONST, result2, currentModule);
        assert (result2 != null) : "InheritanceSearchConstInstr result is null";
        this.constName = constName;
    }

    @Deprecated
    public InheritanceSearchConstInstr(Variable result2, Operand currentModule, String constName, boolean unused2) {
        this(result2, currentModule, constName);
    }

    public Operand getCurrentModule() {
        return this.getOperand1();
    }

    public String getConstName() {
        return this.constName;
    }

    @Deprecated
    public boolean isNoPrivateConsts() {
        return false;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new InheritanceSearchConstInstr(ii.getRenamedVariable(this.result), this.getCurrentModule().cloneForInlining(ii), this.constName);
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.constName};
    }

    private Object cache(Ruby runtime, RubyModule module) {
        IRubyObject constant = module.getConstantNoConstMissingSKipAutoload(this.constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        } else {
            Invalidator invalidator = runtime.getConstantInvalidator(this.constName);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator, module.hashCode());
        }
        return constant;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getCurrentModule());
        e.encode(this.getConstName());
    }

    public static InheritanceSearchConstInstr decode(IRReaderDecoder d) {
        return new InheritanceSearchConstInstr(d.decodeVariable(), d.decodeOperand(), d.decodeString());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object cmVal = this.getCurrentModule().retrieve(context, self2, currScope, currDynScope, temp);
        if (!(cmVal instanceof RubyModule)) {
            throw context.runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        ConstantCache cache = this.cache;
        return !ConstantCache.isCachedFrom(module, cache) ? this.cache(context.runtime, module) : cache.value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.InheritanceSearchConstInstr(this);
    }
}

