/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.Util;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObjectFactory;

public class TagExtractor {
    private static final TextObjectFactory textObjectFactory = CommonTextObjectFactories.forIndexing();
    String target_;
    int threshold_;
    StringBuilder buf_;
    String tag_;
    private int count_;

    public TagExtractor(String tag, int threshold) {
        this.target_ = tag;
        this.threshold_ = threshold;
        this.count_ = 0;
        this.clear();
    }

    public int count() {
        return this.count_;
    }

    public void clear() {
        this.buf_ = new StringBuilder(" ");
        this.tag_ = null;
    }

    public void setTag(String tag) {
        this.tag_ = tag;
    }

    public void add(String line) {
        if (this.tag_ != null && this.tag_.equals(this.target_) && line != null) {
            this.buf_.append(line);
        }
    }

    public void closeTag(LangProfile profile) {
        if (profile != null && this.tag_.equals(this.target_) && this.buf_.length() > this.threshold_ && !this.isSpace()) {
            Util.addCharSequence(profile, textObjectFactory.forText(this.buf_));
            ++this.count_;
        }
        this.clear();
    }

    private boolean isSpace() {
        return this.buf_.length() == 1 && this.buf_.toString().equals(" ");
    }
}

