/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Informational;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.concurrent.atomic.AtomicReference;

public final class BasicInformational
extends AbstractMonitor<String>
implements Informational {
    private final AtomicReference<String> info = new AtomicReference();

    public BasicInformational(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.INFORMATIONAL));
    }

    public void setValue(String value) {
        this.info.set(value);
    }

    @Override
    public String getValue(int pollerIndex) {
        return this.info.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BasicInformational)) {
            return false;
        }
        BasicInformational that = (BasicInformational)o;
        String thisInfo = this.info.get();
        String thatInfo = that.info.get();
        return this.config.equals(that.config) && (thisInfo == null ? thatInfo == null : thisInfo.equals(thatInfo));
    }

    public int hashCode() {
        int result = this.config.hashCode();
        int infoHashcode = this.info.get() != null ? this.info.get().hashCode() : 0;
        result = 31 * result + infoHashcode;
        return result;
    }

    public String toString() {
        return "BasicInformational{config=" + this.config + ", info=" + this.info + '}';
    }
}

