/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.net.HttpCookie;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;

public class HttpSession {
    private String name;
    private boolean active;
    private Map<String, Cookie> tokenValues;
    private boolean valid;
    private int messagesMatched;
    private HttpSessionTokensSet tokenNames;

    public HttpSession(String string, HttpSessionTokensSet httpSessionTokensSet) {
        this.name = string;
        this.active = false;
        this.valid = true;
        this.messagesMatched = 0;
        this.tokenValues = new HashMap<String, Cookie>(1);
        this.tokenNames = httpSessionTokensSet;
    }

    public HttpSessionTokensSet getTokensNames() {
        return this.tokenNames;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setTokenValue(String string, Cookie cookie) {
        if (cookie == null) {
            this.tokenValues.remove(string);
        } else {
            this.tokenValues.put(string, cookie);
        }
    }

    public String getTokenValue(String string) {
        Cookie cookie = this.tokenValues.get(string);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public boolean matchesToken(String string, HttpCookie httpCookie) {
        if (httpCookie == null) {
            return !this.tokenValues.containsKey(string);
        }
        String string2 = this.getTokenValue(string);
        return string2 != null && string2.equals(httpCookie.getValue());
    }

    public void removeToken(String string) {
        this.tokenValues.remove(string);
    }

    public String toString() {
        return "HttpSession [name=" + this.name + ", active=" + this.active + ", tokenValues='" + this.getTokenValuesString() + "']";
    }

    public String getTokenValuesString() {
        if (this.tokenValues.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Cookie> entry : this.tokenValues.entrySet()) {
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue().getValue()).append(';');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpSession httpSession = (HttpSession)object;
        return !(this.name == null ? httpSession.name != null : !this.name.equals(httpSession.name));
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public int getTokenValuesCount() {
        return this.tokenValues.size();
    }

    public Map<String, Cookie> getTokenValuesUnmodifiableMap() {
        return Collections.unmodifiableMap(this.tokenValues);
    }

    public int getMessagesMatched() {
        return this.messagesMatched;
    }

    public void setMessagesMatched(int n) {
        this.messagesMatched = n;
    }
}

