/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.TableModelEvent;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public class DefaultHistoryReferencesTableModel
extends AbstractHistoryReferencesTableModel<DefaultHistoryReferencesTableEntry> {
    private static final long serialVersionUID = -8628528927411108669L;
    private static final HistoryReferencesTableModel.Column[] DEFAULT_COLUMNS = new HistoryReferencesTableModel.Column[]{HistoryReferencesTableModel.Column.HREF_ID, HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP, HistoryReferencesTableModel.Column.METHOD, HistoryReferencesTableModel.Column.URL, HistoryReferencesTableModel.Column.STATUS_CODE, HistoryReferencesTableModel.Column.STATUS_REASON, HistoryReferencesTableModel.Column.RTT, HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY, HistoryReferencesTableModel.Column.HIGHEST_ALERT, HistoryReferencesTableModel.Column.NOTE, HistoryReferencesTableModel.Column.TAGS};
    private ArrayList<DefaultHistoryReferencesTableEntry> hrefList = new ArrayList();
    private SortedMap<Integer, RowIndex> historyIdToRow = new TreeMap<Integer, RowIndex>();
    private SortedSet<RowIndex> rowIndexes = new TreeSet<RowIndex>();

    public static HistoryReferencesTableModel.Column[] getDefaultColumns() {
        return Arrays.copyOf(DEFAULT_COLUMNS, DEFAULT_COLUMNS.length);
    }

    public DefaultHistoryReferencesTableModel() {
        this(DefaultHistoryReferencesTableModel.getDefaultColumns());
    }

    public DefaultHistoryReferencesTableModel(HistoryReferencesTableModel.Column[] columnArray) {
        super(columnArray);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return DefaultHistoryReferencesTableEntry.getColumnClass(this.getColumn(n));
    }

    public Class<?> getColumnClass(HistoryReferencesTableModel.Column column) {
        return DefaultHistoryReferencesTableEntry.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.hrefList.size();
    }

    @Override
    public Object getPrototypeValue(int n) {
        return DefaultHistoryReferencesTableEntry.getPrototypeValue(this.getColumn(n));
    }

    public Object getPrototypeValue(HistoryReferencesTableModel.Column column) {
        return DefaultHistoryReferencesTableEntry.getPrototypeValue(column);
    }

    @Override
    public void addEntry(DefaultHistoryReferencesTableEntry defaultHistoryReferencesTableEntry) {
        this.hrefList.add(defaultHistoryReferencesTableEntry);
        RowIndex rowIndex = new RowIndex(this.hrefList.size() - 1);
        this.historyIdToRow.put(defaultHistoryReferencesTableEntry.getHistoryReference().getHistoryId(), rowIndex);
        this.rowIndexes.add(rowIndex);
        this.fireTableRowsInserted(rowIndex.getValue(), rowIndex.getValue());
    }

    @Override
    public void refreshEntryRow(int n) {
        DefaultHistoryReferencesTableEntry defaultHistoryReferencesTableEntry = this.getEntryWithHistoryId(n);
        if (defaultHistoryReferencesTableEntry != null) {
            int n2 = this.getEntryRowIndex(n);
            this.getEntryWithHistoryId(n).refreshCachedValues();
            this.fireTableRowsUpdated(n2, n2);
        }
    }

    public void refreshEntryRows() {
        if (this.hrefList.isEmpty()) {
            return;
        }
        for (DefaultHistoryReferencesTableEntry defaultHistoryReferencesTableEntry : this.hrefList) {
            defaultHistoryReferencesTableEntry.refreshCachedValues();
        }
        this.fireTableChanged(new TableModelEvent(this, 0, this.hrefList.size() - 1, this.getColumnIndex(HistoryReferencesTableModel.Column.HIGHEST_ALERT), 0));
    }

    @Override
    public void removeEntry(int n) {
        Integer n2 = n;
        RowIndex rowIndex = (RowIndex)this.historyIdToRow.get(n2);
        if (rowIndex != null) {
            this.hrefList.remove(rowIndex.getValue());
            this.historyIdToRow.remove(n2);
            this.rowIndexes.remove(rowIndex);
            this.decreaseRowIndexes(rowIndex);
            this.fireTableRowsDeleted(rowIndex.getValue(), rowIndex.getValue());
        }
    }

    private void decreaseRowIndexes(RowIndex rowIndex) {
        RowIndex[] rowIndexArray;
        for (RowIndex rowIndex2 : rowIndexArray = this.removeRowIndexes(rowIndex)) {
            rowIndex2.decreaseValue();
        }
        this.rowIndexes.addAll(Arrays.asList(rowIndexArray));
    }

    private RowIndex[] removeRowIndexes(RowIndex rowIndex) {
        SortedSet<RowIndex> sortedSet = this.rowIndexes.tailSet(rowIndex);
        RowIndex[] rowIndexArray = new RowIndex[sortedSet.size()];
        rowIndexArray = sortedSet.toArray(rowIndexArray);
        sortedSet.clear();
        return rowIndexArray;
    }

    @Override
    public void clear() {
        this.hrefList.clear();
        this.hrefList.trimToSize();
        this.historyIdToRow = new TreeMap<Integer, RowIndex>();
        this.rowIndexes = new TreeSet<RowIndex>();
        this.fireTableDataChanged();
    }

    @Override
    public int getEntryRowIndex(int n) {
        RowIndex rowIndex = (RowIndex)this.historyIdToRow.get(n);
        if (rowIndex != null) {
            return rowIndex.getValue();
        }
        return -1;
    }

    @Override
    public DefaultHistoryReferencesTableEntry getEntryWithHistoryId(int n) {
        int n2 = this.getEntryRowIndex(n);
        if (n2 != -1) {
            return this.hrefList.get(n2);
        }
        return null;
    }

    @Override
    public DefaultHistoryReferencesTableEntry getEntry(int n) {
        return this.hrefList.get(n);
    }

    public void addHistoryReference(HistoryReference historyReference) {
        this.addEntry(new DefaultHistoryReferencesTableEntry(historyReference, this.getColumns()));
    }

    public HistoryReference getHistoryReference(int n) {
        DefaultHistoryReferencesTableEntry defaultHistoryReferencesTableEntry = this.getEntryWithHistoryId(n);
        if (defaultHistoryReferencesTableEntry != null) {
            return defaultHistoryReferencesTableEntry.getHistoryReference();
        }
        return null;
    }

    private static class RowIndex
    implements Comparable<RowIndex> {
        private int value;

        public RowIndex(int n) {
            this.value = n;
        }

        public void decreaseValue() {
            --this.value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public int compareTo(RowIndex rowIndex) {
            if (rowIndex == null) {
                return 1;
            }
            if (this.value > rowIndex.value) {
                return 1;
            }
            if (this.value < rowIndex.value) {
                return -1;
            }
            return 0;
        }
    }
}

