/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

public class InternalAprInputBuffer
extends AbstractInputBuffer {
    private static final Log log = LogFactory.getLog(InternalAprInputBuffer.class);
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected Request request;
    protected MimeHeaders headers;
    protected boolean parsingHeader;
    protected boolean swallowInput;
    protected byte[] buf;
    protected int lastValid;
    protected int pos;
    protected int end;
    protected ByteBuffer bbuf;
    protected long socket;
    protected InputBuffer inputStreamInputBuffer;
    protected InputFilter[] filterLibrary;
    protected InputFilter[] activeFilters;
    protected int lastActiveFilter;

    public InternalAprInputBuffer(Request request, int headerBufferSize) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.bbuf = headerBufferSize < 8192 ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((headerBufferSize / 1500 + 1) * 1500);
        this.inputStreamInputBuffer = new SocketInputBuffer();
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void setSocket(long socket) {
        this.socket = socket;
        Socket.setrbb(this.socket, this.bbuf);
    }

    public long getSocket() {
        return this.socket;
    }

    public void addFilter(InputFilter filter) {
        InputFilter[] newFilterLibrary = new InputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    public InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new InputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(InputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.inputStreamInputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setRequest(this.request);
    }

    public void setSwallowInput(boolean swallowInput) {
        this.swallowInput = swallowInput;
    }

    public void recycle() {
        this.request.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.socket = 0L;
        this.lastValid = 0;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void nextRequest() {
        this.request.recycle();
        if (this.lastValid - this.pos > 0 && this.pos > 0) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.lastValid - this.pos);
        }
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastValid -= this.pos;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int extraBytes = (int)this.activeFilters[this.lastActiveFilter].end();
            this.pos -= extraBytes;
        }
    }

    public boolean parseRequestLine(boolean useAvailableData) throws IOException {
        int start = 0;
        byte chr = 0;
        do {
            if (this.pos < this.lastValid) continue;
            if (useAvailableData) {
                return false;
            }
            if (this.fill()) continue;
            throw new EOFException(sm.getString("iib.eof.error"));
        } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
        --this.pos;
        start = this.pos;
        if (this.pos >= this.lastValid) {
            if (useAvailableData) {
                return false;
            }
            if (!this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
        }
        boolean space = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                this.request.method().setBytes(this.buf, start, this.pos - start);
            } else if (!HTTP_TOKEN_CHAR[this.buf[this.pos]]) {
                throw new IllegalArgumentException(sm.getString("iib.invalidmethod"));
            }
            ++this.pos;
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        int end = 0;
        int questionPos = -1;
        boolean eol = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                eol = true;
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 63 && questionPos == -1) {
                questionPos = this.pos;
            }
            ++this.pos;
        }
        this.request.unparsedURI().setBytes(this.buf, start, end - start);
        if (questionPos >= 0) {
            this.request.queryString().setBytes(this.buf, questionPos + 1, end - questionPos - 1);
            this.request.requestURI().setBytes(this.buf, start, questionPos - start);
        } else {
            this.request.requestURI().setBytes(this.buf, start, end - start);
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        end = 0;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 13) {
                end = this.pos;
            } else if (this.buf[this.pos] == 10) {
                if (end == 0) {
                    end = this.pos;
                }
                eol = true;
            }
            ++this.pos;
        }
        if (end - start > 0) {
            this.request.protocol().setBytes(this.buf, start, end - start);
        } else {
            this.request.protocol().setString("");
        }
        return true;
    }

    public void parseHeaders() throws IOException {
        while (this.parseHeader()) {
        }
        this.parsingHeader = false;
        this.end = this.pos;
    }

    public boolean parseHeader() throws IOException {
        byte chr = 0;
        while (true) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            chr = this.buf[this.pos];
            if (chr != 13) {
                if (chr != 10) break;
                ++this.pos;
                return false;
            }
            ++this.pos;
        }
        int start = this.pos;
        boolean colon = false;
        MessageBytes headerValue = null;
        while (!colon) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 58) {
                colon = true;
                headerValue = this.headers.addValue(this.buf, start, this.pos - start);
            } else if (!HTTP_TOKEN_CHAR[this.buf[this.pos]]) {
                this.skipLine(start);
                return true;
            }
            chr = this.buf[this.pos];
            if (chr >= 65 && chr <= 90) {
                this.buf[this.pos] = (byte)(chr - -32);
            }
            ++this.pos;
        }
        start = this.pos;
        int realPos = this.pos;
        boolean eol = false;
        boolean validLine = true;
        while (validLine) {
            boolean space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            int lastSignificantChar = realPos;
            while (!eol) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
                if (this.buf[this.pos] != 13) {
                    if (this.buf[this.pos] == 10) {
                        eol = true;
                    } else if (this.buf[this.pos] == 32) {
                        this.buf[realPos] = this.buf[this.pos];
                        ++realPos;
                    } else {
                        this.buf[realPos] = this.buf[this.pos];
                        lastSignificantChar = ++realPos;
                    }
                }
                ++this.pos;
            }
            realPos = lastSignificantChar;
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            chr = this.buf[this.pos];
            if (chr != 32 && chr != 9) {
                validLine = false;
                continue;
            }
            eol = false;
            this.buf[realPos] = chr;
            ++realPos;
        }
        headerValue.setBytes(this.buf, start, realPos - start);
        return true;
    }

    private void skipLine(int start) throws IOException {
        boolean eol = false;
        int lastRealByte = start;
        if (this.pos - 1 > start) {
            lastRealByte = this.pos - 1;
        }
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos] == 10) {
                    eol = true;
                } else {
                    lastRealByte = this.pos;
                }
            }
            ++this.pos;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("iib.invalidheader", new String(this.buf, start, lastRealByte - start + 1, "ISO-8859-1")));
        }
    }

    public int available() {
        int result = this.lastValid - this.pos;
        if (result == 0 && this.lastActiveFilter >= 0) {
            for (int i = 0; result == 0 && i <= this.lastActiveFilter; ++i) {
                result = this.activeFilters[i].available();
            }
        }
        return result;
    }

    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(chunk, req);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(chunk, req);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean fill() throws IOException {
        int nRead = 0;
        if (this.parsingHeader) {
            if (this.lastValid == this.buf.length) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
            this.bbuf.clear();
            nRead = Socket.recvbb(this.socket, 0, this.buf.length - this.lastValid);
            if (nRead <= 0) {
                if (-nRead != 120002) throw new IOException(sm.getString("iib.failedread"));
                return false;
            }
            this.bbuf.limit(nRead);
            this.bbuf.get(this.buf, this.pos, nRead);
            this.lastValid = this.pos + nRead;
        } else {
            if (this.buf.length - this.end < 4500) {
                this.buf = new byte[this.buf.length];
                this.end = 0;
            }
            this.lastValid = this.pos = this.end;
            this.bbuf.clear();
            nRead = Socket.recvbb(this.socket, 0, this.buf.length - this.lastValid);
            if (nRead > 0) {
                this.bbuf.limit(nRead);
                this.bbuf.get(this.buf, this.pos, nRead);
                this.lastValid = this.pos + nRead;
            } else {
                if (-nRead == 120005) throw new SocketTimeoutException(sm.getString("iib.failedread"));
                if (-nRead == 120001) {
                    throw new SocketTimeoutException(sm.getString("iib.failedread"));
                }
                if (nRead != 0) throw new IOException(sm.getString("iib.failedread"));
                return false;
            }
        }
        if (nRead <= 0) return false;
        return true;
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalAprInputBuffer.this.pos >= InternalAprInputBuffer.this.lastValid && !InternalAprInputBuffer.this.fill()) {
                return -1;
            }
            int length = InternalAprInputBuffer.this.lastValid - InternalAprInputBuffer.this.pos;
            chunk.setBytes(InternalAprInputBuffer.this.buf, InternalAprInputBuffer.this.pos, length);
            InternalAprInputBuffer.this.pos = InternalAprInputBuffer.this.lastValid;
            return length;
        }
    }
}

