/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class CourierOblique
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Courier-Oblique";
    private static final String fullName = "Courier Oblique";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 562;
    private static final int xHeight = 426;
    private static final int ascender = 629;
    private static final int descender = -157;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private boolean enableKerning = false;

    public CourierOblique() {
        this(false);
    }

    public CourierOblique(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncodingName() {
        return encoding;
    }

    public URI getFontURI() {
        return fontFileURI;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 629;
    }

    public int getCapHeight(int size) {
        return size * 562;
    }

    public int getDescender(int size) {
        return size * -157;
    }

    public int getXHeight(int size) {
        return size * 426;
    }

    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size) {
        return size * width[i];
    }

    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return false;
    }

    public Map getKerningInfo() {
        return Collections.EMPTY_MAP;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        CourierOblique.width[65] = 600;
        CourierOblique.boundingBoxes[65] = new Rectangle(3, 0, 604, 562);
        CourierOblique.width[198] = 600;
        CourierOblique.boundingBoxes[198] = new Rectangle(3, 0, 652, 562);
        CourierOblique.width[193] = 600;
        CourierOblique.boundingBoxes[193] = new Rectangle(3, 0, 657, 805);
        CourierOblique.width[194] = 600;
        CourierOblique.boundingBoxes[194] = new Rectangle(3, 0, 604, 787);
        CourierOblique.width[196] = 600;
        CourierOblique.boundingBoxes[196] = new Rectangle(3, 0, 604, 753);
        CourierOblique.width[192] = 600;
        CourierOblique.boundingBoxes[192] = new Rectangle(3, 0, 604, 805);
        CourierOblique.width[197] = 600;
        CourierOblique.boundingBoxes[197] = new Rectangle(3, 0, 604, 750);
        CourierOblique.width[195] = 600;
        CourierOblique.boundingBoxes[195] = new Rectangle(3, 0, 652, 729);
        CourierOblique.width[66] = 600;
        CourierOblique.boundingBoxes[66] = new Rectangle(43, 0, 573, 562);
        CourierOblique.width[67] = 600;
        CourierOblique.boundingBoxes[67] = new Rectangle(93, -18, 562, 598);
        CourierOblique.width[199] = 600;
        CourierOblique.boundingBoxes[199] = new Rectangle(93, -151, 565, 731);
        CourierOblique.width[68] = 600;
        CourierOblique.boundingBoxes[68] = new Rectangle(43, 0, 602, 562);
        CourierOblique.width[69] = 600;
        CourierOblique.boundingBoxes[69] = new Rectangle(53, 0, 607, 562);
        CourierOblique.width[201] = 600;
        CourierOblique.boundingBoxes[201] = new Rectangle(53, 0, 617, 805);
        CourierOblique.width[202] = 600;
        CourierOblique.boundingBoxes[202] = new Rectangle(53, 0, 607, 787);
        CourierOblique.width[203] = 600;
        CourierOblique.boundingBoxes[203] = new Rectangle(53, 0, 607, 753);
        CourierOblique.width[200] = 600;
        CourierOblique.boundingBoxes[200] = new Rectangle(53, 0, 607, 805);
        CourierOblique.width[208] = 600;
        CourierOblique.boundingBoxes[208] = new Rectangle(43, 0, 602, 562);
        CourierOblique.width[128] = 600;
        CourierOblique.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        CourierOblique.width[70] = 600;
        CourierOblique.boundingBoxes[70] = new Rectangle(53, 0, 607, 562);
        CourierOblique.width[71] = 600;
        CourierOblique.boundingBoxes[71] = new Rectangle(83, -18, 562, 598);
        CourierOblique.width[72] = 600;
        CourierOblique.boundingBoxes[72] = new Rectangle(32, 0, 655, 562);
        CourierOblique.width[73] = 600;
        CourierOblique.boundingBoxes[73] = new Rectangle(96, 0, 527, 562);
        CourierOblique.width[205] = 600;
        CourierOblique.boundingBoxes[205] = new Rectangle(96, 0, 544, 805);
        CourierOblique.width[206] = 600;
        CourierOblique.boundingBoxes[206] = new Rectangle(96, 0, 527, 787);
        CourierOblique.width[207] = 600;
        CourierOblique.boundingBoxes[207] = new Rectangle(96, 0, 527, 753);
        CourierOblique.width[204] = 600;
        CourierOblique.boundingBoxes[204] = new Rectangle(96, 0, 527, 805);
        CourierOblique.width[74] = 600;
        CourierOblique.boundingBoxes[74] = new Rectangle(52, -18, 633, 580);
        CourierOblique.width[75] = 600;
        CourierOblique.boundingBoxes[75] = new Rectangle(38, 0, 633, 562);
        CourierOblique.width[76] = 600;
        CourierOblique.boundingBoxes[76] = new Rectangle(47, 0, 560, 562);
        CourierOblique.width[77] = 600;
        CourierOblique.boundingBoxes[77] = new Rectangle(4, 0, 711, 562);
        CourierOblique.width[78] = 600;
        CourierOblique.boundingBoxes[78] = new Rectangle(7, -13, 705, 575);
        CourierOblique.width[209] = 600;
        CourierOblique.boundingBoxes[209] = new Rectangle(7, -13, 705, 742);
        CourierOblique.width[79] = 600;
        CourierOblique.boundingBoxes[79] = new Rectangle(94, -18, 531, 598);
        CourierOblique.width[140] = 600;
        CourierOblique.boundingBoxes[140] = new Rectangle(59, 0, 613, 562);
        CourierOblique.width[211] = 600;
        CourierOblique.boundingBoxes[211] = new Rectangle(94, -18, 546, 823);
        CourierOblique.width[212] = 600;
        CourierOblique.boundingBoxes[212] = new Rectangle(94, -18, 531, 805);
        CourierOblique.width[214] = 600;
        CourierOblique.boundingBoxes[214] = new Rectangle(94, -18, 531, 771);
        CourierOblique.width[210] = 600;
        CourierOblique.boundingBoxes[210] = new Rectangle(94, -18, 531, 823);
        CourierOblique.width[216] = 600;
        CourierOblique.boundingBoxes[216] = new Rectangle(94, -80, 531, 709);
        CourierOblique.width[213] = 600;
        CourierOblique.boundingBoxes[213] = new Rectangle(94, -18, 561, 747);
        CourierOblique.width[80] = 600;
        CourierOblique.boundingBoxes[80] = new Rectangle(79, 0, 565, 562);
        CourierOblique.width[81] = 600;
        CourierOblique.boundingBoxes[81] = new Rectangle(95, -138, 530, 718);
        CourierOblique.width[82] = 600;
        CourierOblique.boundingBoxes[82] = new Rectangle(38, 0, 560, 562);
        CourierOblique.width[83] = 600;
        CourierOblique.boundingBoxes[83] = new Rectangle(76, -20, 574, 600);
        CourierOblique.width[138] = 600;
        CourierOblique.boundingBoxes[138] = new Rectangle(76, -20, 596, 822);
        CourierOblique.width[84] = 600;
        CourierOblique.boundingBoxes[84] = new Rectangle(108, 0, 557, 562);
        CourierOblique.width[222] = 600;
        CourierOblique.boundingBoxes[222] = new Rectangle(79, 0, 527, 562);
        CourierOblique.width[85] = 600;
        CourierOblique.boundingBoxes[85] = new Rectangle(125, -18, 577, 580);
        CourierOblique.width[218] = 600;
        CourierOblique.boundingBoxes[218] = new Rectangle(125, -18, 577, 823);
        CourierOblique.width[219] = 600;
        CourierOblique.boundingBoxes[219] = new Rectangle(125, -18, 577, 805);
        CourierOblique.width[220] = 600;
        CourierOblique.boundingBoxes[220] = new Rectangle(125, -18, 577, 771);
        CourierOblique.width[217] = 600;
        CourierOblique.boundingBoxes[217] = new Rectangle(125, -18, 577, 823);
        CourierOblique.width[86] = 600;
        CourierOblique.boundingBoxes[86] = new Rectangle(105, -13, 618, 575);
        CourierOblique.width[87] = 600;
        CourierOblique.boundingBoxes[87] = new Rectangle(106, -13, 616, 575);
        CourierOblique.width[88] = 600;
        CourierOblique.boundingBoxes[88] = new Rectangle(23, 0, 652, 562);
        CourierOblique.width[89] = 600;
        CourierOblique.boundingBoxes[89] = new Rectangle(133, 0, 562, 562);
        CourierOblique.width[221] = 600;
        CourierOblique.boundingBoxes[221] = new Rectangle(133, 0, 562, 805);
        CourierOblique.width[159] = 600;
        CourierOblique.boundingBoxes[159] = new Rectangle(133, 0, 562, 753);
        CourierOblique.width[90] = 600;
        CourierOblique.boundingBoxes[90] = new Rectangle(86, 0, 524, 562);
        CourierOblique.width[142] = 600;
        CourierOblique.boundingBoxes[142] = new Rectangle(86, 0, 556, 802);
        CourierOblique.width[97] = 600;
        CourierOblique.boundingBoxes[97] = new Rectangle(76, -15, 493, 456);
        CourierOblique.width[225] = 600;
        CourierOblique.boundingBoxes[225] = new Rectangle(76, -15, 536, 687);
        CourierOblique.width[226] = 600;
        CourierOblique.boundingBoxes[226] = new Rectangle(76, -15, 505, 669);
        CourierOblique.width[180] = 600;
        CourierOblique.boundingBoxes[180] = new Rectangle(348, 497, 264, 175);
        CourierOblique.width[228] = 600;
        CourierOblique.boundingBoxes[228] = new Rectangle(76, -15, 499, 635);
        CourierOblique.width[230] = 600;
        CourierOblique.boundingBoxes[230] = new Rectangle(41, -15, 585, 456);
        CourierOblique.width[224] = 600;
        CourierOblique.boundingBoxes[224] = new Rectangle(76, -15, 493, 687);
        CourierOblique.width[38] = 600;
        CourierOblique.boundingBoxes[38] = new Rectangle(87, -15, 493, 558);
        CourierOblique.width[229] = 600;
        CourierOblique.boundingBoxes[229] = new Rectangle(76, -15, 493, 642);
        CourierOblique.width[94] = 600;
        CourierOblique.boundingBoxes[94] = new Rectangle(175, 354, 412, 268);
        CourierOblique.width[126] = 600;
        CourierOblique.boundingBoxes[126] = new Rectangle(116, 197, 484, 123);
        CourierOblique.width[42] = 600;
        CourierOblique.boundingBoxes[42] = new Rectangle(212, 257, 368, 350);
        CourierOblique.width[64] = 600;
        CourierOblique.boundingBoxes[64] = new Rectangle(127, -15, 455, 637);
        CourierOblique.width[227] = 600;
        CourierOblique.boundingBoxes[227] = new Rectangle(76, -15, 553, 621);
        CourierOblique.width[98] = 600;
        CourierOblique.boundingBoxes[98] = new Rectangle(29, -15, 596, 644);
        CourierOblique.width[92] = 600;
        CourierOblique.boundingBoxes[92] = new Rectangle(249, -80, 219, 709);
        CourierOblique.width[124] = 600;
        CourierOblique.boundingBoxes[124] = new Rectangle(222, -250, 263, 1000);
        CourierOblique.width[123] = 600;
        CourierOblique.boundingBoxes[123] = new Rectangle(233, -108, 336, 730);
        CourierOblique.width[125] = 600;
        CourierOblique.boundingBoxes[125] = new Rectangle(140, -108, 337, 730);
        CourierOblique.width[91] = 600;
        CourierOblique.boundingBoxes[91] = new Rectangle(246, -108, 328, 730);
        CourierOblique.width[93] = 600;
        CourierOblique.boundingBoxes[93] = new Rectangle(135, -108, 328, 730);
        CourierOblique.width[166] = 600;
        CourierOblique.boundingBoxes[166] = new Rectangle(238, -175, 231, 850);
        CourierOblique.width[149] = 600;
        CourierOblique.boundingBoxes[149] = new Rectangle(224, 130, 261, 253);
        CourierOblique.width[99] = 600;
        CourierOblique.boundingBoxes[99] = new Rectangle(106, -15, 502, 456);
        CourierOblique.width[231] = 600;
        CourierOblique.boundingBoxes[231] = new Rectangle(106, -151, 508, 592);
        CourierOblique.width[184] = 600;
        CourierOblique.boundingBoxes[184] = new Rectangle(197, -151, 147, 161);
        CourierOblique.width[162] = 600;
        CourierOblique.boundingBoxes[162] = new Rectangle(151, -49, 437, 663);
        CourierOblique.width[136] = 600;
        CourierOblique.boundingBoxes[136] = new Rectangle(229, 477, 352, 177);
        CourierOblique.width[58] = 600;
        CourierOblique.boundingBoxes[58] = new Rectangle(238, -15, 203, 400);
        CourierOblique.width[44] = 600;
        CourierOblique.boundingBoxes[44] = new Rectangle(157, -112, 213, 234);
        CourierOblique.width[169] = 600;
        CourierOblique.boundingBoxes[169] = new Rectangle(53, -18, 614, 598);
        CourierOblique.width[164] = 600;
        CourierOblique.boundingBoxes[164] = new Rectangle(94, 58, 534, 448);
        CourierOblique.width[100] = 600;
        CourierOblique.boundingBoxes[100] = new Rectangle(85, -15, 555, 644);
        CourierOblique.width[134] = 600;
        CourierOblique.boundingBoxes[134] = new Rectangle(217, -78, 329, 658);
        CourierOblique.width[135] = 600;
        CourierOblique.boundingBoxes[135] = new Rectangle(163, -78, 383, 658);
        CourierOblique.width[176] = 600;
        CourierOblique.boundingBoxes[176] = new Rectangle(214, 269, 362, 353);
        CourierOblique.width[168] = 600;
        CourierOblique.boundingBoxes[168] = new Rectangle(272, 537, 307, 103);
        CourierOblique.width[247] = 600;
        CourierOblique.boundingBoxes[247] = new Rectangle(136, 48, 437, 419);
        CourierOblique.width[36] = 600;
        CourierOblique.boundingBoxes[36] = new Rectangle(108, -126, 488, 788);
        CourierOblique.width[101] = 600;
        CourierOblique.boundingBoxes[101] = new Rectangle(106, -15, 492, 456);
        CourierOblique.width[233] = 600;
        CourierOblique.boundingBoxes[233] = new Rectangle(106, -15, 506, 687);
        CourierOblique.width[234] = 600;
        CourierOblique.boundingBoxes[234] = new Rectangle(106, -15, 492, 669);
        CourierOblique.width[235] = 600;
        CourierOblique.boundingBoxes[235] = new Rectangle(106, -15, 492, 635);
        CourierOblique.width[232] = 600;
        CourierOblique.boundingBoxes[232] = new Rectangle(106, -15, 492, 687);
        CourierOblique.width[56] = 600;
        CourierOblique.boundingBoxes[56] = new Rectangle(132, -15, 456, 637);
        CourierOblique.width[133] = 600;
        CourierOblique.boundingBoxes[133] = new Rectangle(46, -15, 529, 126);
        CourierOblique.width[151] = 600;
        CourierOblique.boundingBoxes[151] = new Rectangle(49, 231, 612, 54);
        CourierOblique.width[150] = 600;
        CourierOblique.boundingBoxes[150] = new Rectangle(124, 231, 462, 54);
        CourierOblique.width[61] = 600;
        CourierOblique.boundingBoxes[61] = new Rectangle(109, 138, 491, 238);
        CourierOblique.width[240] = 600;
        CourierOblique.boundingBoxes[240] = new Rectangle(102, -15, 537, 644);
        CourierOblique.width[33] = 600;
        CourierOblique.boundingBoxes[33] = new Rectangle(243, -15, 221, 587);
        CourierOblique.width[161] = 600;
        CourierOblique.boundingBoxes[161] = new Rectangle(225, -157, 220, 587);
        CourierOblique.width[102] = 600;
        CourierOblique.boundingBoxes[102] = new Rectangle(114, 0, 548, 629);
        CourierOblique.width[53] = 600;
        CourierOblique.boundingBoxes[53] = new Rectangle(99, -15, 490, 622);
        CourierOblique.width[131] = 600;
        CourierOblique.boundingBoxes[131] = new Rectangle(-26, -143, 697, 765);
        CourierOblique.width[52] = 600;
        CourierOblique.boundingBoxes[52] = new Rectangle(108, 0, 433, 622);
        CourierOblique.width[103] = 600;
        CourierOblique.boundingBoxes[103] = new Rectangle(61, -157, 596, 598);
        CourierOblique.width[223] = 600;
        CourierOblique.boundingBoxes[223] = new Rectangle(48, -15, 569, 644);
        CourierOblique.width[96] = 600;
        CourierOblique.boundingBoxes[96] = new Rectangle(294, 497, 190, 175);
        CourierOblique.width[62] = 600;
        CourierOblique.boundingBoxes[62] = new Rectangle(85, 42, 514, 430);
        CourierOblique.width[171] = 600;
        CourierOblique.boundingBoxes[171] = new Rectangle(92, 70, 560, 376);
        CourierOblique.width[187] = 600;
        CourierOblique.boundingBoxes[187] = new Rectangle(58, 70, 560, 376);
        CourierOblique.width[139] = 600;
        CourierOblique.boundingBoxes[139] = new Rectangle(204, 70, 336, 376);
        CourierOblique.width[155] = 600;
        CourierOblique.boundingBoxes[155] = new Rectangle(170, 70, 336, 376);
        CourierOblique.width[104] = 600;
        CourierOblique.boundingBoxes[104] = new Rectangle(33, 0, 559, 629);
        CourierOblique.width[45] = 600;
        CourierOblique.boundingBoxes[45] = new Rectangle(152, 231, 406, 54);
        CourierOblique.width[105] = 600;
        CourierOblique.boundingBoxes[105] = new Rectangle(95, 0, 420, 657);
        CourierOblique.width[237] = 600;
        CourierOblique.boundingBoxes[237] = new Rectangle(95, 0, 517, 672);
        CourierOblique.width[238] = 600;
        CourierOblique.boundingBoxes[238] = new Rectangle(95, 0, 456, 654);
        CourierOblique.width[239] = 600;
        CourierOblique.boundingBoxes[239] = new Rectangle(95, 0, 450, 620);
        CourierOblique.width[236] = 600;
        CourierOblique.boundingBoxes[236] = new Rectangle(95, 0, 420, 672);
        CourierOblique.width[106] = 600;
        CourierOblique.boundingBoxes[106] = new Rectangle(52, -157, 498, 814);
        CourierOblique.width[107] = 600;
        CourierOblique.boundingBoxes[107] = new Rectangle(58, 0, 575, 629);
        CourierOblique.width[108] = 600;
        CourierOblique.boundingBoxes[108] = new Rectangle(95, 0, 420, 629);
        CourierOblique.width[60] = 600;
        CourierOblique.boundingBoxes[60] = new Rectangle(96, 42, 514, 430);
        CourierOblique.width[172] = 600;
        CourierOblique.boundingBoxes[172] = new Rectangle(155, 108, 436, 261);
        CourierOblique.width[109] = 600;
        CourierOblique.boundingBoxes[109] = new Rectangle(-5, 0, 620, 441);
        CourierOblique.width[175] = 600;
        CourierOblique.boundingBoxes[175] = new Rectangle(232, 525, 368, 40);
        CourierOblique.width[181] = 600;
        CourierOblique.boundingBoxes[181] = new Rectangle(72, -157, 500, 583);
        CourierOblique.width[215] = 600;
        CourierOblique.boundingBoxes[215] = new Rectangle(103, 43, 504, 427);
        CourierOblique.width[110] = 600;
        CourierOblique.boundingBoxes[110] = new Rectangle(26, 0, 559, 441);
        CourierOblique.width[57] = 600;
        CourierOblique.boundingBoxes[57] = new Rectangle(93, -15, 481, 637);
        CourierOblique.width[241] = 600;
        CourierOblique.boundingBoxes[241] = new Rectangle(26, 0, 603, 606);
        CourierOblique.width[35] = 600;
        CourierOblique.boundingBoxes[35] = new Rectangle(133, -32, 463, 671);
        CourierOblique.width[111] = 600;
        CourierOblique.boundingBoxes[111] = new Rectangle(102, -15, 486, 456);
        CourierOblique.width[243] = 600;
        CourierOblique.boundingBoxes[243] = new Rectangle(102, -15, 510, 687);
        CourierOblique.width[244] = 600;
        CourierOblique.boundingBoxes[244] = new Rectangle(102, -15, 486, 669);
        CourierOblique.width[246] = 600;
        CourierOblique.boundingBoxes[246] = new Rectangle(102, -15, 486, 635);
        CourierOblique.width[156] = 600;
        CourierOblique.boundingBoxes[156] = new Rectangle(54, -15, 561, 456);
        CourierOblique.width[242] = 600;
        CourierOblique.boundingBoxes[242] = new Rectangle(102, -15, 486, 687);
        CourierOblique.width[49] = 600;
        CourierOblique.boundingBoxes[49] = new Rectangle(98, 0, 417, 622);
        CourierOblique.width[189] = 600;
        CourierOblique.boundingBoxes[189] = new Rectangle(65, -57, 604, 722);
        CourierOblique.width[188] = 600;
        CourierOblique.boundingBoxes[188] = new Rectangle(65, -57, 609, 722);
        CourierOblique.width[185] = 600;
        CourierOblique.boundingBoxes[185] = new Rectangle(231, 249, 260, 373);
        CourierOblique.width[170] = 600;
        CourierOblique.boundingBoxes[170] = new Rectangle(209, 249, 303, 331);
        CourierOblique.width[186] = 600;
        CourierOblique.boundingBoxes[186] = new Rectangle(210, 249, 325, 331);
        CourierOblique.width[248] = 600;
        CourierOblique.boundingBoxes[248] = new Rectangle(102, -80, 486, 586);
        CourierOblique.width[245] = 600;
        CourierOblique.boundingBoxes[245] = new Rectangle(102, -15, 527, 621);
        CourierOblique.width[112] = 600;
        CourierOblique.boundingBoxes[112] = new Rectangle(-24, -157, 629, 598);
        CourierOblique.width[182] = 600;
        CourierOblique.boundingBoxes[182] = new Rectangle(100, -78, 530, 640);
        CourierOblique.width[40] = 600;
        CourierOblique.boundingBoxes[40] = new Rectangle(313, -108, 259, 730);
        CourierOblique.width[41] = 600;
        CourierOblique.boundingBoxes[41] = new Rectangle(137, -108, 259, 730);
        CourierOblique.width[37] = 600;
        CourierOblique.boundingBoxes[37] = new Rectangle(134, -15, 465, 637);
        CourierOblique.width[46] = 600;
        CourierOblique.boundingBoxes[46] = new Rectangle(238, -15, 144, 124);
        CourierOblique.width[183] = 600;
        CourierOblique.boundingBoxes[183] = new Rectangle(275, 189, 159, 138);
        CourierOblique.width[137] = 600;
        CourierOblique.boundingBoxes[137] = new Rectangle(59, -15, 568, 637);
        CourierOblique.width[43] = 600;
        CourierOblique.boundingBoxes[43] = new Rectangle(129, 44, 451, 426);
        CourierOblique.width[177] = 600;
        CourierOblique.boundingBoxes[177] = new Rectangle(96, 44, 498, 514);
        CourierOblique.width[113] = 600;
        CourierOblique.boundingBoxes[113] = new Rectangle(85, -157, 597, 598);
        CourierOblique.width[63] = 600;
        CourierOblique.boundingBoxes[63] = new Rectangle(222, -15, 361, 587);
        CourierOblique.width[191] = 600;
        CourierOblique.boundingBoxes[191] = new Rectangle(105, -157, 361, 587);
        CourierOblique.width[34] = 600;
        CourierOblique.boundingBoxes[34] = new Rectangle(273, 328, 259, 234);
        CourierOblique.width[132] = 600;
        CourierOblique.boundingBoxes[132] = new Rectangle(115, -134, 363, 234);
        CourierOblique.width[147] = 600;
        CourierOblique.boundingBoxes[147] = new Rectangle(262, 328, 279, 234);
        CourierOblique.width[148] = 600;
        CourierOblique.boundingBoxes[148] = new Rectangle(213, 328, 363, 234);
        CourierOblique.width[145] = 600;
        CourierOblique.boundingBoxes[145] = new Rectangle(343, 328, 114, 234);
        CourierOblique.width[146] = 600;
        CourierOblique.boundingBoxes[146] = new Rectangle(283, 328, 212, 234);
        CourierOblique.width[130] = 600;
        CourierOblique.boundingBoxes[130] = new Rectangle(185, -134, 212, 234);
        CourierOblique.width[39] = 600;
        CourierOblique.boundingBoxes[39] = new Rectangle(345, 328, 115, 234);
        CourierOblique.width[114] = 600;
        CourierOblique.boundingBoxes[114] = new Rectangle(60, 0, 576, 441);
        CourierOblique.width[174] = 600;
        CourierOblique.boundingBoxes[174] = new Rectangle(53, -18, 614, 598);
        CourierOblique.width[115] = 600;
        CourierOblique.boundingBoxes[115] = new Rectangle(78, -15, 506, 456);
        CourierOblique.width[154] = 600;
        CourierOblique.boundingBoxes[154] = new Rectangle(78, -15, 536, 684);
        CourierOblique.width[167] = 600;
        CourierOblique.boundingBoxes[167] = new Rectangle(104, -78, 486, 658);
        CourierOblique.width[59] = 600;
        CourierOblique.boundingBoxes[59] = new Rectangle(157, -112, 284, 497);
        CourierOblique.width[55] = 600;
        CourierOblique.boundingBoxes[55] = new Rectangle(182, 0, 430, 607);
        CourierOblique.width[54] = 600;
        CourierOblique.boundingBoxes[54] = new Rectangle(155, -15, 474, 637);
        CourierOblique.width[47] = 600;
        CourierOblique.boundingBoxes[47] = new Rectangle(112, -80, 492, 709);
        CourierOblique.width[32] = 600;
        CourierOblique.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        CourierOblique.width[163] = 600;
        CourierOblique.boundingBoxes[163] = new Rectangle(124, -21, 497, 632);
        CourierOblique.width[116] = 600;
        CourierOblique.boundingBoxes[116] = new Rectangle(167, -15, 394, 576);
        CourierOblique.width[254] = 600;
        CourierOblique.boundingBoxes[254] = new Rectangle(-24, -157, 629, 786);
        CourierOblique.width[51] = 600;
        CourierOblique.boundingBoxes[51] = new Rectangle(82, -15, 456, 637);
        CourierOblique.width[190] = 600;
        CourierOblique.boundingBoxes[190] = new Rectangle(73, -56, 586, 722);
        CourierOblique.width[179] = 600;
        CourierOblique.boundingBoxes[179] = new Rectangle(213, 240, 288, 382);
        CourierOblique.width[152] = 600;
        CourierOblique.boundingBoxes[152] = new Rectangle(212, 489, 417, 117);
        CourierOblique.width[153] = 600;
        CourierOblique.boundingBoxes[153] = new Rectangle(75, 263, 667, 299);
        CourierOblique.width[50] = 600;
        CourierOblique.boundingBoxes[50] = new Rectangle(70, 0, 498, 622);
        CourierOblique.width[178] = 600;
        CourierOblique.boundingBoxes[178] = new Rectangle(230, 249, 305, 373);
        CourierOblique.width[117] = 600;
        CourierOblique.boundingBoxes[117] = new Rectangle(101, -15, 471, 441);
        CourierOblique.width[250] = 600;
        CourierOblique.boundingBoxes[250] = new Rectangle(101, -15, 501, 687);
        CourierOblique.width[251] = 600;
        CourierOblique.boundingBoxes[251] = new Rectangle(101, -15, 471, 669);
        CourierOblique.width[252] = 600;
        CourierOblique.boundingBoxes[252] = new Rectangle(101, -15, 474, 635);
        CourierOblique.width[249] = 600;
        CourierOblique.boundingBoxes[249] = new Rectangle(101, -15, 471, 687);
        CourierOblique.width[95] = 600;
        CourierOblique.boundingBoxes[95] = new Rectangle(-27, -125, 611, 50);
        CourierOblique.width[118] = 600;
        CourierOblique.boundingBoxes[118] = new Rectangle(90, -10, 591, 436);
        CourierOblique.width[119] = 600;
        CourierOblique.boundingBoxes[119] = new Rectangle(76, -10, 619, 436);
        CourierOblique.width[120] = 600;
        CourierOblique.boundingBoxes[120] = new Rectangle(20, 0, 635, 426);
        CourierOblique.width[121] = 600;
        CourierOblique.boundingBoxes[121] = new Rectangle(-4, -157, 687, 583);
        CourierOblique.width[253] = 600;
        CourierOblique.boundingBoxes[253] = new Rectangle(-4, -157, 687, 829);
        CourierOblique.width[255] = 600;
        CourierOblique.boundingBoxes[255] = new Rectangle(-4, -157, 687, 777);
        CourierOblique.width[165] = 600;
        CourierOblique.boundingBoxes[165] = new Rectangle(120, 0, 573, 562);
        CourierOblique.width[122] = 600;
        CourierOblique.boundingBoxes[122] = new Rectangle(99, 0, 494, 426);
        CourierOblique.width[158] = 600;
        CourierOblique.boundingBoxes[158] = new Rectangle(99, 0, 525, 669);
        CourierOblique.width[48] = 600;
        CourierOblique.boundingBoxes[48] = new Rectangle(154, -15, 421, 637);
        familyNames = new HashSet();
        familyNames.add("Courier");
    }
}

