/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileFilter;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMap<Key, Value>
extends PersistentEnumeratorDelegate<Key> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PersistentHashMap");
    private static final boolean myDoTrace = SystemProperties.getBooleanProperty("idea.trace.persistent.map", false);
    private static final int DEAD_KEY_NUMBER_MASK = -1;
    private final File myStorageFile;
    private final KeyDescriptor<Key> myKeyDescriptor;
    private PersistentHashMapValueStorage myValueStorage;
    protected final DataExternalizer<Value> myValueExternalizer;
    private static final long NULL_ADDR = 0L;
    private static final int INITIAL_INDEX_SIZE;
    @NonNls
    public static final String DATA_FILE_EXTENSION = ".values";
    private long myLiveAndGarbageKeysCounter;
    private int myReadCompactionGarbageSize;
    private static final long LIVE_KEY_MASK = 0x100000000L;
    private static final long USED_LONG_VALUE_MASK = 0x4000000000000000L;
    private static final int POSITIVE_VALUE_SHIFT = 1;
    private final int myParentValueRefOffset;
    @NotNull
    private final byte[] myRecordBuffer;
    @NotNull
    private final byte[] mySmallRecordBuffer;
    private final boolean myIntMapping;
    private final boolean myDirectlyStoreLongFileOffsetMode;
    private final boolean myCanReEnumerate;
    private int myLargeIndexWatermarkId;
    private boolean myIntAddressForNewRecord;
    private static final boolean doHardConsistencyChecks = false;
    private volatile boolean myBusyReading;
    private final LimitedPool<BufferExposingByteArrayOutputStream> myStreamPool;
    private final SLRUCache<Key, BufferExposingByteArrayOutputStream> myAppendCache;
    private final LowMemoryWatcher myAppendCacheFlusher;
    private static final ThreadLocalCachedValue<AppendStream> ourFlyweightAppenderStream;
    private int smallKeys;
    private int largeKeys;
    private int transformedKeys;
    private int requests;

    private boolean canUseIntAddressForNewRecord(long size) {
        return this.myCanReEnumerate ? size + 1L < Integer.MAX_VALUE : false;
    }

    public PersistentHashMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentHashMap", "<init>"));
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/util/io/PersistentHashMap", "<init>"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/io/PersistentHashMap", "<init>"));
        }
        this(file, keyDescriptor, valueExternalizer, INITIAL_INDEX_SIZE);
    }

    public PersistentHashMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentHashMap", "<init>"));
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/util/io/PersistentHashMap", "<init>"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/io/PersistentHashMap", "<init>"));
        }
        super(PersistentHashMap.checkDataFiles(file), keyDescriptor, initialSize);
        this.myStreamPool = new LimitedPool<BufferExposingByteArrayOutputStream>(10, new LimitedPool.ObjectFactory<BufferExposingByteArrayOutputStream>(){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream create() {
                BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = new BufferExposingByteArrayOutputStream();
                if (bufferExposingByteArrayOutputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentHashMap$1", "create"));
                }
                return bufferExposingByteArrayOutputStream;
            }

            @Override
            public void cleanup(@NotNull BufferExposingByteArrayOutputStream appendStream) {
                if (appendStream == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appendStream", "com/intellij/util/io/PersistentHashMap$1", "cleanup"));
                }
                appendStream.reset();
            }
        });
        this.myAppendCacheFlusher = LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                PersistentHashMap.this.dropMemoryCaches();
            }
        });
        this.myStorageFile = file;
        this.myKeyDescriptor = keyDescriptor;
        this.myAppendCache = this.createAppendCache(keyDescriptor);
        final PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler = this.myEnumerator.getRecordHandler();
        this.myParentValueRefOffset = recordHandler.getRecordBuffer(this.myEnumerator).length;
        this.myIntMapping = valueExternalizer instanceof IntInlineKeyDescriptor && this.wantNonnegativeIntegralValues();
        this.myDirectlyStoreLongFileOffsetMode = keyDescriptor instanceof InlineKeyDescriptor && this.myEnumerator instanceof PersistentBTreeEnumerator;
        this.myRecordBuffer = this.myDirectlyStoreLongFileOffsetMode ? new byte[]{} : new byte[this.myParentValueRefOffset + 8];
        this.mySmallRecordBuffer = this.myDirectlyStoreLongFileOffsetMode ? new byte[]{} : new byte[this.myParentValueRefOffset + 4];
        this.myEnumerator.setRecordHandler(new PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase>(){

            @Override
            int recordWriteOffset(PersistentEnumeratorBase enumerator, byte[] buf) {
                return recordHandler.recordWriteOffset(enumerator, buf);
            }

            @Override
            @NotNull
            byte[] getRecordBuffer(PersistentEnumeratorBase enumerator) {
                byte[] byArray = PersistentHashMap.this.myIntAddressForNewRecord ? PersistentHashMap.this.mySmallRecordBuffer : PersistentHashMap.this.myRecordBuffer;
                if (byArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentHashMap$3", "getRecordBuffer"));
                }
                return byArray;
            }

            @Override
            void setupRecord(PersistentEnumeratorBase enumerator, int hashCode, int dataOffset, @NotNull byte[] buf) {
                if (buf == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/util/io/PersistentHashMap$3", "setupRecord"));
                }
                recordHandler.setupRecord(enumerator, hashCode, dataOffset, buf);
                for (int i = PersistentHashMap.this.myParentValueRefOffset; i < buf.length; ++i) {
                    buf[i] = 0;
                }
            }
        });
        this.myEnumerator.setMarkCleanCallback(new Flushable(){

            @Override
            public void flush() throws IOException {
                PersistentHashMap.this.myEnumerator.putMetaData(PersistentHashMap.this.myLiveAndGarbageKeysCounter);
                PersistentHashMap.this.myEnumerator.putMetaData2((long)PersistentHashMap.this.myLargeIndexWatermarkId | (long)PersistentHashMap.this.myReadCompactionGarbageSize << 32);
            }
        });
        if (myDoTrace) {
            LOG.info("Opened " + file);
        }
        try {
            this.myValueExternalizer = valueExternalizer;
            this.myValueStorage = PersistentHashMapValueStorage.create(PersistentHashMap.getDataFile(file).getPath());
            this.myLiveAndGarbageKeysCounter = this.myEnumerator.getMetaData();
            long data2 = this.myEnumerator.getMetaData2();
            this.myLargeIndexWatermarkId = (int)(data2 & 0xFFFFFFFFFFFFFFFFL);
            this.myReadCompactionGarbageSize = (int)(data2 >>> 32);
            this.myCanReEnumerate = this.myEnumerator.canReEnumerate();
            if (this.makesSenseToCompact()) {
                this.compact();
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            LOG.error(t);
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new PersistentEnumeratorBase.CorruptedException(file);
        }
    }

    protected boolean wantNonnegativeIntegralValues() {
        return false;
    }

    private SLRUCache<Key, BufferExposingByteArrayOutputStream> createAppendCache(KeyDescriptor<Key> keyDescriptor) {
        return new SLRUCache<Key, BufferExposingByteArrayOutputStream>(16384, 4096, keyDescriptor){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream createValue(Key key) {
                BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)PersistentHashMap.this.myStreamPool.alloc();
                if (bufferExposingByteArrayOutputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentHashMap$5", "createValue"));
                }
                return bufferExposingByteArrayOutputStream;
            }

            @Override
            protected void onDropFromCache(Key key, @NotNull BufferExposingByteArrayOutputStream bytes) {
                if (bytes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/util/io/PersistentHashMap$5", "onDropFromCache"));
                }
                PersistentHashMap.this.myEnumerator.lockStorage();
                try {
                    int id;
                    long previousRecord;
                    if (PersistentHashMap.this.myDirectlyStoreLongFileOffsetMode) {
                        previousRecord = ((PersistentBTreeEnumerator)PersistentHashMap.this.myEnumerator).getNonnegativeValue(key);
                        id = -1;
                    } else {
                        id = PersistentHashMap.this.enumerate(key);
                        previousRecord = PersistentHashMap.this.readValueId(id);
                    }
                    long headerRecord = PersistentHashMap.this.myValueStorage.appendBytes(bytes.getInternalBuffer(), 0, bytes.size(), previousRecord);
                    if (PersistentHashMap.this.myDirectlyStoreLongFileOffsetMode) {
                        ((PersistentBTreeEnumerator)PersistentHashMap.this.myEnumerator).putNonnegativeValue(key, headerRecord);
                    } else {
                        PersistentHashMap.this.updateValueId(id, headerRecord, previousRecord, key, 0);
                    }
                    if (previousRecord == 0L) {
                        PersistentHashMap.this.myLiveAndGarbageKeysCounter = PersistentHashMap.this.myLiveAndGarbageKeysCounter + 0x100000000L;
                    }
                    PersistentHashMap.this.myStreamPool.recycle(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    PersistentHashMap.this.myEnumerator.unlockStorage();
                }
            }
        };
    }

    private boolean doNewCompact() {
        return System.getProperty("idea.persistent.hash.map.oldcompact") == null;
    }

    private boolean forceNewCompact() {
        return System.getProperty("idea.persistent.hash.map.newcompact") != null && (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropMemoryCaches() {
        if (myDoTrace) {
            LOG.info("Drop memory caches " + this.myStorageFile);
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myEnumerator.lockStorage();
            try {
                this.clearAppenderCaches();
            }
            finally {
                this.myEnumerator.unlockStorage();
            }
        }
    }

    public int getGarbageSize() {
        return (int)this.myLiveAndGarbageKeysCounter;
    }

    public File getBaseFile() {
        return this.myEnumerator.myFile;
    }

    public boolean makesSenseToCompact() {
        long fileSize = this.myValueStorage.getSize();
        int megabyte = 0x100000;
        if (fileSize > 0x500000L) {
            int liveKeys = (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
            int deadKeys = (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL);
            if (fileSize > 0x3200000L && this.forceNewCompact()) {
                return true;
            }
            if (deadKeys < 50) {
                return false;
            }
            int benefitSize = 0x6400000;
            long avgValueSize = fileSize / (long)(liveKeys + deadKeys);
            return deadKeys > liveKeys || avgValueSize * (long)deadKeys > 0x6400000L || (long)this.myReadCompactionGarbageSize > fileSize / 2L;
        }
        return false;
    }

    @NotNull
    private static File checkDataFiles(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentHashMap", "checkDataFiles"));
        }
        if (!file.exists()) {
            PersistentHashMap.deleteFilesStartingWith(PersistentHashMap.getDataFile(file));
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentHashMap", "checkDataFiles"));
        }
        return file2;
    }

    public static void deleteFilesStartingWith(@NotNull File prefixFile) {
        if (prefixFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixFile", "com/intellij/util/io/PersistentHashMap", "deleteFilesStartingWith"));
        }
        IOUtil.deleteAllFilesStartingWith(prefixFile);
    }

    @NotNull
    private static File getDataFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentHashMap", "getDataFile"));
        }
        File file2 = new File(file.getParentFile(), file.getName() + DATA_FILE_EXTENSION);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentHashMap", "getDataFile"));
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Key key, Value value) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Key key, Value value) throws IOException {
        long newValueOffset = -1L;
        if (!this.myIntMapping) {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
            appenderStream.setOut(bytes);
            this.myValueExternalizer.save(appenderStream, value);
            appenderStream.setOut(null);
            newValueOffset = this.myValueStorage.appendBytes(bytes.getInternalBuffer(), 0, bytes.size(), 0L);
        }
        this.myEnumerator.lockStorage();
        try {
            long oldValueOffset;
            this.myEnumerator.markDirty(true);
            this.myAppendCache.remove(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                if (this.myIntMapping) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonnegativeValue(key, ((Integer)value).intValue());
                    return;
                }
                oldValueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonnegativeValue(key);
                ((PersistentBTreeEnumerator)this.myEnumerator).putNonnegativeValue(key, newValueOffset);
            } else {
                int id = this.enumerate(key);
                if (this.myIntMapping) {
                    this.myEnumerator.myStorage.putInt(id + this.myParentValueRefOffset, (Integer)value);
                    return;
                }
                oldValueOffset = this.readValueId(id);
                this.updateValueId(id, newValueOffset, oldValueOffset, key, 0);
            }
            this.myLiveAndGarbageKeysCounter = oldValueOffset != 0L ? ++this.myLiveAndGarbageKeysCounter : (this.myLiveAndGarbageKeysCounter += 0x100000000L);
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int enumerate(Key name) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myIntAddressForNewRecord = this.canUseIntAddressForNewRecord(this.myValueStorage.getSize());
            return super.enumerate(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appender", "com/intellij/util/io/PersistentHashMap", "appendData"));
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doAppendData(key, appender);
        }
    }

    protected void doAppendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appender", "com/intellij/util/io/PersistentHashMap", "doAppendData"));
        }
        assert (!this.myIntMapping);
        this.myEnumerator.markDirty(true);
        AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
        BufferExposingByteArrayOutputStream stream2 = this.myAppendCache.get(key);
        appenderStream.setOut(stream2);
        appender.append(appenderStream);
        appenderStream.setOut(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean processKeys(Processor<Key> processor) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myAppendCache.clear();
            return this.myEnumerator.iterateData(processor);
        }
    }

    @NotNull
    public Collection<Key> getAllKeysWithExistingMapping() throws IOException {
        ArrayList values = new ArrayList();
        this.processKeysWithExistingMapping(new CommonProcessors.CollectProcessor(values));
        ArrayList arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentHashMap", "getAllKeysWithExistingMapping"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean processKeysWithExistingMapping(Processor<Key> processor) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myAppendCache.clear();
            return this.myEnumerator.processAllDataObject(processor, new PersistentEnumeratorBase.DataFilter(){

                @Override
                public boolean accept(int id) {
                    return PersistentHashMap.this.readValueId(id) != 0L;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Value get(Key key) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myBusyReading = true;
            Value Value2 = this.doGet(key);
            return Value2;
            finally {
                this.myBusyReading = false;
            }
        }
    }

    public boolean isBusyReading() {
        return this.myBusyReading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Value doGet(Key key) throws IOException {
        int id;
        long valueOffset;
        this.myEnumerator.lockStorage();
        try {
            this.myAppendCache.remove(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                valueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonnegativeValue(key);
                if (this.myIntMapping) {
                    Integer n = (int)valueOffset;
                    return (Value)n;
                }
                id = -1;
            } else {
                id = this.tryEnumerate(key);
                if (id == 0) {
                    Value Value2 = null;
                    return Value2;
                }
                if (this.myIntMapping) {
                    Integer n = this.myEnumerator.myStorage.getInt(id + this.myParentValueRefOffset);
                    return (Value)n;
                }
                valueOffset = this.readValueId(id);
            }
            if (valueOffset == 0L) {
                Value Value3 = null;
                return Value3;
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
        PersistentHashMapValueStorage.ReadResult readResult = this.myValueStorage.readBytes(valueOffset);
        if (readResult.offset != valueOffset) {
            this.myEnumerator.lockStorage();
            try {
                this.myEnumerator.markDirty(true);
                if (this.myDirectlyStoreLongFileOffsetMode) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonnegativeValue(key, readResult.offset);
                } else {
                    this.updateValueId(id, readResult.offset, valueOffset, key, 0);
                }
                ++this.myLiveAndGarbageKeysCounter;
                this.myReadCompactionGarbageSize += readResult.buffer.length;
            }
            finally {
                this.myEnumerator.unlockStorage();
            }
        }
        DataInputStream input = new DataInputStream(new UnsyncByteArrayInputStream(readResult.buffer));
        try {
            Value Value4 = this.myValueExternalizer.read(input);
            return Value4;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsMapping(Key key) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            return this.doContainsMapping(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doContainsMapping(Key key) throws IOException {
        this.myEnumerator.lockStorage();
        try {
            this.myAppendCache.remove(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                boolean bl = ((PersistentBTreeEnumerator)this.myEnumerator).getNonnegativeValue(key) != 0L;
                return bl;
            }
            int id = this.tryEnumerate(key);
            if (id == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.myIntMapping) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.readValueId(id) != 0L;
            return bl;
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Key key) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doRemove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(Key key) throws IOException {
        this.myEnumerator.lockStorage();
        try {
            long record2;
            this.myAppendCache.remove(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                assert (!this.myIntMapping);
                record2 = ((PersistentBTreeEnumerator)this.myEnumerator).getNonnegativeValue(key);
                ((PersistentBTreeEnumerator)this.myEnumerator).putNonnegativeValue(key, 0L);
            } else {
                int id = this.tryEnumerate(key);
                if (id == 0) {
                    return;
                }
                assert (!this.myIntMapping);
                this.myEnumerator.markDirty(true);
                record2 = this.readValueId(id);
                this.updateValueId(id, 0L, record2, key, 0);
            }
            if (record2 != 0L) {
                ++this.myLiveAndGarbageKeysCounter;
                this.myLiveAndGarbageKeysCounter -= 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void force() {
        if (myDoTrace) {
            LOG.info("Forcing " + this.myStorageFile);
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doForce();
        }
    }

    protected void doForce() {
        this.myEnumerator.lockStorage();
        try {
            try {
                this.clearAppenderCaches();
            }
            finally {
                super.force();
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    private void clearAppenderCaches() {
        this.myAppendCache.clear();
        this.myValueStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (myDoTrace) {
            LOG.info("Closed " + this.myStorageFile);
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        this.myEnumerator.lockStorage();
        try {
            try {
                this.myAppendCacheFlusher.stop();
                this.myAppendCache.clear();
            }
            finally {
                PersistentHashMapValueStorage valueStorage = this.myValueStorage;
                try {
                    if (valueStorage != null) {
                        valueStorage.dispose();
                    }
                }
                finally {
                    super.close();
                }
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.force();
            LOG.info("Compacting " + this.myEnumerator.myFile.getPath());
            LOG.info("Live keys:" + (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L) + ", dead keys:" + (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL) + ", read compaction size:" + this.myReadCompactionGarbageSize);
            long now = System.currentTimeMillis();
            File oldDataFile = PersistentHashMap.getDataFile(this.myEnumerator.myFile);
            String oldDataFileBaseName = oldDataFile.getName();
            File[] oldFiles = PersistentHashMap.getFilesInDirectoryWithNameStartingWith(oldDataFile, oldDataFileBaseName);
            String newPath = PersistentHashMap.getDataFile(this.myEnumerator.myFile).getPath() + ".new";
            final PersistentHashMapValueStorage newStorage = PersistentHashMapValueStorage.create(newPath);
            this.myValueStorage.switchToCompactionMode();
            this.myEnumerator.markDirty(true);
            long sizeBefore = this.myValueStorage.getSize();
            this.myLiveAndGarbageKeysCounter = 0L;
            this.myReadCompactionGarbageSize = 0;
            try {
                if (this.doNewCompact()) {
                    this.newCompact(newStorage);
                } else {
                    this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                        @Override
                        public boolean process(int keyId) throws IOException {
                            long record2 = PersistentHashMap.this.readValueId(keyId);
                            if (record2 != 0L) {
                                PersistentHashMapValueStorage.ReadResult readResult = PersistentHashMap.this.myValueStorage.readBytes(record2);
                                long value = newStorage.appendBytes(readResult.buffer, 0, readResult.buffer.length, 0L);
                                PersistentHashMap.this.updateValueId(keyId, value, record2, null, this.getCurrentKey());
                                PersistentHashMap.this.myLiveAndGarbageKeysCounter = PersistentHashMap.this.myLiveAndGarbageKeysCounter + 0x100000000L;
                            }
                            return true;
                        }
                    });
                }
            }
            finally {
                newStorage.dispose();
            }
            this.myValueStorage.dispose();
            if (oldFiles != null) {
                for (File f : oldFiles) {
                    assert (FileUtil.deleteWithRenaming(f));
                }
            }
            long newSize = newStorage.getSize();
            File newDataFile = new File(newPath);
            String newBaseName = newDataFile.getName();
            File[] newFiles = PersistentHashMap.getFilesInDirectoryWithNameStartingWith(newDataFile, newBaseName);
            if (newFiles != null) {
                File parentFile = newDataFile.getParentFile();
                for (File f : newFiles) {
                    String nameAfterRename = StringUtil.replace(f.getName(), newBaseName, oldDataFileBaseName);
                    FileUtil.rename(f, new File(parentFile, nameAfterRename));
                }
            }
            this.myValueStorage = PersistentHashMapValueStorage.create(oldDataFile.getPath());
            LOG.info("Compacted " + this.myEnumerator.myFile.getPath() + ":" + sizeBefore + " bytes into " + newSize + " bytes in " + (System.currentTimeMillis() - now) + "ms.");
            this.myEnumerator.putMetaData(this.myLiveAndGarbageKeysCounter);
            this.myEnumerator.putMetaData2(this.myLargeIndexWatermarkId);
            if (myDoTrace) {
                LOG.assertTrue(this.myEnumerator.isDirty());
            }
        }
    }

    private static File[] getFilesInDirectoryWithNameStartingWith(File fileFromDirectory, final String baseFileName) {
        File parentFile = fileFromDirectory.getParentFile();
        return parentFile != null ? parentFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(baseFileName);
            }
        }) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newCompact(PersistentHashMapValueStorage newStorage) throws IOException {
        long started = System.currentTimeMillis();
        final ArrayList<CompactionRecordInfo> infos = new ArrayList<CompactionRecordInfo>(10000);
        this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

            @Override
            public boolean process(int keyId) throws IOException {
                long record2 = PersistentHashMap.this.readValueId(keyId);
                if (record2 != 0L) {
                    infos.add(new CompactionRecordInfo(this.getCurrentKey(), record2, keyId));
                }
                return true;
            }
        });
        LOG.info("Loaded mappings:" + (System.currentTimeMillis() - started) + "ms, keys:" + infos.size());
        started = System.currentTimeMillis();
        long fragments2 = 0L;
        if (!infos.isEmpty()) {
            try {
                fragments2 = this.myValueStorage.compactValues(infos, newStorage);
            }
            catch (Throwable t) {
                if (!(t instanceof IOException)) {
                    throw new IOException("Compaction failed", t);
                }
                throw (IOException)t;
            }
        }
        LOG.info("Compacted values for:" + (System.currentTimeMillis() - started) + "ms fragments:" + (int)fragments2 + ", newfragments:" + (fragments2 >> 32));
        started = System.currentTimeMillis();
        try {
            this.myEnumerator.lockStorage();
            for (int i = 0; i < infos.size(); ++i) {
                CompactionRecordInfo info = (CompactionRecordInfo)infos.get(i);
                this.updateValueId(info.address, info.newValueAddress, info.valueAddress, null, info.key);
                this.myLiveAndGarbageKeysCounter += 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
        LOG.info("Updated mappings:" + (System.currentTimeMillis() - started) + " ms");
    }

    private long readValueId(int keyId) {
        if (this.myDirectlyStoreLongFileOffsetMode) {
            return ((PersistentBTreeEnumerator)this.myEnumerator).keyIdToNonnegattiveOffset(keyId);
        }
        long address = this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset);
        if (address == 0L || address == -1L) {
            return 0L;
        }
        if (address < 0L) {
            address = -address - 1L;
        } else {
            long value = (long)this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset + 4) & 0xFFFFFFFFL;
            address = (address << 32) + value & 0xBFFFFFFFFFFFFFFFL;
        }
        return address;
    }

    private int updateValueId(int keyId, long value, long oldValue, @Nullable Key key, int processingKey) throws IOException {
        boolean newKey;
        if (this.myDirectlyStoreLongFileOffsetMode) {
            ((PersistentBTreeEnumerator)this.myEnumerator).putNonnegativeValue(((InlineKeyDescriptor)this.myKeyDescriptor).fromInt(processingKey), value);
            return keyId;
        }
        boolean bl = newKey = oldValue == 0L;
        if (newKey) {
            ++this.requests;
        }
        boolean defaultSizeInfo = true;
        if (this.myCanReEnumerate) {
            if (this.canUseIntAddressForNewRecord(value)) {
                defaultSizeInfo = false;
                this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, -((int)(value + 1L)));
                if (newKey) {
                    ++this.smallKeys;
                }
            } else if ((keyId < this.myLargeIndexWatermarkId || this.myLargeIndexWatermarkId == 0) && (newKey || this.canUseIntAddressForNewRecord(oldValue))) {
                this.myIntAddressForNewRecord = false;
                keyId = this.myEnumerator.reenumerate(key == null ? this.myEnumerator.getValue(keyId, processingKey) : key);
                ++this.transformedKeys;
                if (this.myLargeIndexWatermarkId == 0) {
                    this.myLargeIndexWatermarkId = keyId;
                }
            }
        }
        if (defaultSizeInfo) {
            this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, (int)((value |= 0x4000000000000000L) >>> 32));
            this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset + 4, (int)value);
            if (newKey) {
                ++this.largeKeys;
            }
        }
        if (newKey && IOStatistics.DEBUG && (this.requests & 0xFFFF) == 0) {
            IOStatistics.dump("small:" + this.smallKeys + ", large:" + this.largeKeys + ", transformed:" + this.transformedKeys + ",@" + this.getBaseFile().getPath());
        }
        return keyId;
    }

    public String toString() {
        return super.toString() + ":" + this.myStorageFile;
    }

    static {
        String property = System.getProperty("idea.initialIndexSize");
        INITIAL_INDEX_SIZE = property == null ? 4096 : Integer.valueOf(property);
        ourFlyweightAppenderStream = new ThreadLocalCachedValue<AppendStream>(){

            @Override
            protected AppendStream create() {
                return new AppendStream();
            }
        };
    }

    static class CompactionRecordInfo {
        final int key;
        final int address;
        long valueAddress;
        long newValueAddress;
        byte[] value;

        public CompactionRecordInfo(int _key, long _valueAddress, int _address) {
            this.key = _key;
            this.address = _address;
            this.valueAddress = _valueAddress;
        }
    }

    public static interface ValueDataAppender {
        public void append(DataOutput var1) throws IOException;
    }

    private static class AppendStream
    extends DataOutputStream {
        private AppendStream() {
            super(null);
        }

        private void setOut(BufferExposingByteArrayOutputStream stream2) {
            this.out = stream2;
        }
    }
}

