/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;

public class BasicComponentParameter
implements Serializable,
Parameter {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    @Override
    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        return this.resolveAdapter(container, adapter, expectedType) != null;
    }

    @Override
    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
        if (componentAdapter != null) {
            return container.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private ComponentAdapter resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter result2 = this.getTargetAdapter(container, expectedType, adapter);
        if (result2 == null) {
            return null;
        }
        if (!expectedType.isAssignableFrom(result2.getComponentImplementation())) {
            if (expectedType.isPrimitive()) {
                try {
                    Field field = result2.getComponentImplementation().getField("TYPE");
                    Class type2 = (Class)field.get(result2.getComponentInstance(null));
                    if (expectedType.isAssignableFrom(type2)) {
                        return result2;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }
        return result2;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container, Class expectedType, ComponentAdapter excludeAdapter) {
        if (this.componentKey != null) {
            return container.getComponentAdapter(this.componentKey);
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapterOfType(expectedType);
        }
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter byKey = container.getComponentAdapter(expectedType);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return byKey;
        }
        List found = container.getComponentAdaptersOfType(expectedType);
        ComponentAdapter exclude = null;
        for (ComponentAdapter work : found) {
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found.remove(exclude);
        if (found.size() == 0) {
            if (container.getParent() != null) {
                return container.getParent().getComponentAdapterOfType(expectedType);
            }
            return null;
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = ((ComponentAdapter)found.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType, foundClasses);
    }
}

