/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.internal;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.java.model.internal.KotlinAnnotationProxyMakerKt;
import sun.reflect.annotation.AnnotationParser;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J$\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/java/model/internal/KotlinAnnotationProxyMaker;", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "annotationClass", "Lcom/intellij/psi/PsiClass;", "annotationType", "Ljava/lang/Class;", "", "(Lcom/intellij/psi/PsiAnnotation;Lcom/intellij/psi/PsiClass;Ljava/lang/Class;)V", "getAnnotation", "()Lcom/intellij/psi/PsiAnnotation;", "getAnnotationClass", "()Lcom/intellij/psi/PsiClass;", "getAnnotationType", "()Ljava/lang/Class;", "generate", "getAllPsiValues", "", "Lorg/jetbrains/kotlin/java/model/internal/KotlinAnnotationProxyMaker$AnnotationParameterData;", "getAllValuesForParser", "", "", "values", "AnnotationParameterData", "annotation-processing"})
public final class KotlinAnnotationProxyMaker {
    @NotNull
    private final PsiAnnotation annotation;
    @NotNull
    private final PsiClass annotationClass;
    @NotNull
    private final Class<? extends Annotation> annotationType;

    @NotNull
    public final Annotation generate() {
        Annotation annotation = AnnotationParser.annotationForMap(this.annotationType, this.getAllValuesForParser(this.getAllPsiValues()));
        Intrinsics.checkExpressionValueIsNotNull((Object)annotation, (String)"AnnotationParser.annotat\u2026arser(getAllPsiValues()))");
        return annotation;
    }

    private final List<AnnotationParameterData> getAllPsiValues() {
        List values = CollectionsKt.mutableListOf((Object[])new AnnotationParameterData[0]);
        PsiMethod[] psiMethodArray = this.annotationClass.getMethods();
        for (int i = 0; i < psiMethodArray.length; ++i) {
            Method method;
            PsiMethod method2 = psiMethodArray[i];
            if (!(method2 instanceof PsiAnnotationMethod) || ((PsiAnnotationMethod)method2).getReturnType() == null) continue;
            try {
                method = this.annotationType.getMethod(((PsiAnnotationMethod)method2).getName(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            Method jMethod = method;
            PsiAnnotationMemberValue psiAnnotationMemberValue = this.annotation.findAttributeValue(((PsiAnnotationMethod)method2).getName());
            if (psiAnnotationMemberValue == null) {
                psiAnnotationMemberValue = ((PsiAnnotationMethod)method2).getDefaultValue();
            }
            if (psiAnnotationMemberValue == null) {
                continue;
            }
            PsiAnnotationMemberValue value = psiAnnotationMemberValue;
            Collection collection = values;
            PsiAnnotationMethod psiAnnotationMethod = (PsiAnnotationMethod)method2;
            Method method3 = jMethod;
            Intrinsics.checkExpressionValueIsNotNull((Object)method3, (String)"jMethod");
            AnnotationParameterData annotationParameterData = new AnnotationParameterData(psiAnnotationMethod, value, method3);
            collection.add(annotationParameterData);
        }
        return values;
    }

    private final Map<String, Object> getAllValuesForParser(List<AnnotationParameterData> values) {
        Map parserValues = MapsKt.mutableMapOf((Pair[])new Pair[0]);
        PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance((Project)this.annotation.getProject()).getConstantEvaluationHelper();
        for (AnnotationParameterData annotationParameterData : values) {
            Class<?> jReturnType;
            PsiAnnotationMethod method = annotationParameterData.component1();
            PsiAnnotationMemberValue value = annotationParameterData.component2();
            Method jMethod = annotationParameterData.component3();
            if (jMethod.getReturnType() == null) {
                Void void_ = KotlinAnnotationProxyMakerKt.access$unexpectedType("no return type for " + jMethod.getName());
                throw null;
            }
            String string = method.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
            PsiType psiType = method.getReturnType();
            if (psiType == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"method.returnType!!");
            PsiConstantEvaluationHelper psiConstantEvaluationHelper = evaluator;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiConstantEvaluationHelper, (String)"evaluator");
            parserValues.put(string, KotlinAnnotationProxyMakerKt.access$getConstantValue(value, psiType, jReturnType, psiConstantEvaluationHelper));
        }
        return parserValues;
    }

    @NotNull
    public final PsiAnnotation getAnnotation() {
        return this.annotation;
    }

    @NotNull
    public final PsiClass getAnnotationClass() {
        return this.annotationClass;
    }

    @NotNull
    public final Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public KotlinAnnotationProxyMaker(@NotNull PsiAnnotation annotation, @NotNull PsiClass annotationClass, @NotNull Class<? extends Annotation> annotationType) {
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkParameterIsNotNull(annotationType, (String)"annotationType");
        this.annotation = annotation;
        this.annotationClass = annotationClass;
        this.annotationType = annotationType;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/java/model/internal/KotlinAnnotationProxyMaker$AnnotationParameterData;", "", "method", "Lcom/intellij/psi/PsiAnnotationMethod;", "value", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "jMethod", "Ljava/lang/reflect/Method;", "(Lcom/intellij/psi/PsiAnnotationMethod;Lcom/intellij/psi/PsiAnnotationMemberValue;Ljava/lang/reflect/Method;)V", "getJMethod", "()Ljava/lang/reflect/Method;", "getMethod", "()Lcom/intellij/psi/PsiAnnotationMethod;", "getValue", "()Lcom/intellij/psi/PsiAnnotationMemberValue;", "component1", "component2", "component3", "copy", "annotation-processing"})
    private static final class AnnotationParameterData {
        @NotNull
        private final PsiAnnotationMethod method;
        @NotNull
        private final PsiAnnotationMemberValue value;
        @NotNull
        private final Method jMethod;

        @NotNull
        public final PsiAnnotationMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final PsiAnnotationMemberValue getValue() {
            return this.value;
        }

        @NotNull
        public final Method getJMethod() {
            return this.jMethod;
        }

        public AnnotationParameterData(@NotNull PsiAnnotationMethod method, @NotNull PsiAnnotationMemberValue value, @NotNull Method jMethod) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)jMethod, (String)"jMethod");
            this.method = method;
            this.value = value;
            this.jMethod = jMethod;
        }

        @NotNull
        public final PsiAnnotationMethod component1() {
            return this.method;
        }

        @NotNull
        public final PsiAnnotationMemberValue component2() {
            return this.value;
        }

        @NotNull
        public final Method component3() {
            return this.jMethod;
        }

        @NotNull
        public final AnnotationParameterData copy(@NotNull PsiAnnotationMethod method, @NotNull PsiAnnotationMemberValue value, @NotNull Method jMethod) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)jMethod, (String)"jMethod");
            return new AnnotationParameterData(method, value, jMethod);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ AnnotationParameterData copy$default(AnnotationParameterData annotationParameterData, PsiAnnotationMethod psiAnnotationMethod, PsiAnnotationMemberValue psiAnnotationMemberValue, Method method, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                psiAnnotationMethod = annotationParameterData.method;
            }
            if ((n & 2) != 0) {
                psiAnnotationMemberValue = annotationParameterData.value;
            }
            if ((n & 4) != 0) {
                method = annotationParameterData.jMethod;
            }
            return annotationParameterData.copy(psiAnnotationMethod, psiAnnotationMemberValue, method);
        }

        public String toString() {
            return "AnnotationParameterData(method=" + this.method + ", value=" + this.value + ", jMethod=" + this.jMethod + ")";
        }

        public int hashCode() {
            PsiAnnotationMethod psiAnnotationMethod = this.method;
            PsiAnnotationMemberValue psiAnnotationMemberValue = this.value;
            Method method = this.jMethod;
            return ((psiAnnotationMethod != null ? psiAnnotationMethod.hashCode() : 0) * 31 + (psiAnnotationMemberValue != null ? psiAnnotationMemberValue.hashCode() : 0)) * 31 + (method != null ? ((Object)method).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AnnotationParameterData)) break block3;
                    AnnotationParameterData annotationParameterData = (AnnotationParameterData)object;
                    if (!Intrinsics.areEqual((Object)this.method, (Object)annotationParameterData.method) || !Intrinsics.areEqual((Object)this.value, (Object)annotationParameterData.value) || !Intrinsics.areEqual((Object)this.jMethod, (Object)annotationParameterData.jMethod)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

