/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class TexturePaint
implements Paint {
    BufferedImage bufImg;
    double tx;
    double ty;
    double sx;
    double sy;

    public TexturePaint(BufferedImage txtr, Rectangle2D anchor) {
        this.bufImg = txtr;
        this.tx = anchor.getX();
        this.ty = anchor.getY();
        this.sx = anchor.getWidth() / (double)this.bufImg.getWidth();
        this.sy = anchor.getHeight() / (double)this.bufImg.getHeight();
    }

    public BufferedImage getImage() {
        return this.bufImg;
    }

    public Rectangle2D getAnchorRect() {
        return new Rectangle2D.Double(this.tx, this.ty, this.sx * (double)this.bufImg.getWidth(), this.sy * (double)this.bufImg.getHeight());
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        xform = xform == null ? new AffineTransform() : (AffineTransform)xform.clone();
        xform.translate(this.tx, this.ty);
        xform.scale(this.sx, this.sy);
        return TexturePaintContext.getContext(this.bufImg, xform, hints, deviceBounds);
    }

    @Override
    public int getTransparency() {
        return this.bufImg.getColorModel().getTransparency();
    }
}

