/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class DetailsSupport {
    private static final LinkedHashMap<String, List<ProviderClassPair>> PROVIDERS_CACHE = new LinkedHashMap<String, List<ProviderClassPair>>(10000){

        @Override
        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 5000;
        }
    };
    private static Lookup.Result<DetailsProvider> PROVIDERS;

    public static String getDetailsString(Instance instance, Heap heap) {
        List<ProviderClassPair> list = DetailsSupport.getCompatibleProviders(instance.getJavaClass());
        for (ProviderClassPair providerClassPair : list) {
            String string;
            String string2 = providerClassPair.classKey;
            if (providerClassPair.subclasses) {
                string2 = string2 + "+";
            }
            if ((string = providerClassPair.provider.getDetailsString(string2, instance, heap)) == null) continue;
            return string;
        }
        return null;
    }

    public static DetailsProvider.View getDetailsView(Instance instance, Heap heap) {
        List<ProviderClassPair> list = DetailsSupport.getCompatibleProviders(instance.getJavaClass());
        for (ProviderClassPair providerClassPair : list) {
            DetailsProvider.View view;
            String string = providerClassPair.classKey;
            if (providerClassPair.subclasses) {
                string = string + "+";
            }
            if ((view = providerClassPair.provider.getDetailsView(string, instance, heap)) == null) continue;
            return view;
        }
        return null;
    }

    private static Collection<? extends DetailsProvider> getProviders() {
        if (PROVIDERS == null) {
            PROVIDERS = Lookup.getDefault().lookupResult(DetailsProvider.class);
            PROVIDERS.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    PROVIDERS_CACHE.clear();
                }
            });
        }
        return PROVIDERS.allInstances();
    }

    private static List<ProviderClassPair> getCompatibleProviders(JavaClass javaClass) {
        Object object;
        String string = javaClass.getName();
        List<ProviderClassPair> list = PROVIDERS_CACHE.get(string);
        if (list != null) {
            return list;
        }
        ArrayList<ProviderClassPair> arrayList = new ArrayList<ProviderClassPair>();
        ArrayList<ProviderClassPair> arrayList2 = new ArrayList<ProviderClassPair>();
        Collection<? extends DetailsProvider> collection = DetailsSupport.getProviders();
        for (DetailsProvider detailsProvider : collection) {
            object = detailsProvider.getSupportedClasses();
            if (object != null && ((String[])object).length > 0) {
                for (Object object2 : object) {
                    arrayList.add(new ProviderClassPair(detailsProvider, (String)object2));
                }
                continue;
            }
            arrayList2.add(new ProviderClassPair(detailsProvider, null));
        }
        ArrayList arrayList3 = new ArrayList();
        if (!arrayList.isEmpty()) {
            boolean bl = false;
            while (javaClass != null) {
                boolean bl2;
                object = javaClass.getName();
                for (ProviderClassPair providerClassPair : arrayList) {
                    if (!providerClassPair.subclasses && bl2 || !((String)object).equals(providerClassPair.classKey)) continue;
                    arrayList3.add(providerClassPair);
                }
                javaClass = javaClass.getSuperClass();
                bl2 = true;
            }
        }
        arrayList3.addAll(arrayList2);
        PROVIDERS_CACHE.put(string, arrayList3);
        return arrayList3;
    }

    private static class ProviderClassPair {
        final DetailsProvider provider;
        final String classKey;
        final boolean subclasses;

        ProviderClassPair(DetailsProvider detailsProvider, String string) {
            this.subclasses = string != null && string.endsWith("+");
            this.provider = detailsProvider;
            this.classKey = !this.subclasses ? string : string.substring(0, string.length() - 1);
        }
    }
}

