/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.PropertySetModelEvent;
import org.openide.explorer.propertysheet.PropertySetModelListener;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class PropertySetModelImpl
implements PropertySetModel,
Runnable {
    private static boolean filterHiddenProperties = !Boolean.getBoolean("netbeans.ps.showHiddenProperties");
    static Set<String> closedSets = new HashSet<String>(5);
    private boolean[] expanded = null;
    private List<FeatureDescriptor> fds = new ArrayList<FeatureDescriptor>();
    private Comparator<Node.Property> comparator = null;
    private transient List<PropertySetModelListener> listenerList;
    private Node.PropertySet[] sets = null;
    private transient int setCount = 0;
    private transient PropertySetModelEvent event = null;

    public PropertySetModelImpl() {
    }

    public PropertySetModelImpl(Node.PropertySet[] propertySetArray) {
        if (propertySetArray == null) {
            propertySetArray = new Node.PropertySet[]{};
        }
        this.setPropertySets(propertySetArray);
    }

    @Override
    public int getCount() {
        return this.fds.size();
    }

    @Override
    public FeatureDescriptor getFeatureDescriptor(int n) {
        if (n == -1 || n >= this.fds.size()) {
            return null;
        }
        return this.fds.get(n);
    }

    @Override
    public int indexOf(FeatureDescriptor featureDescriptor) {
        return this.fds.indexOf(featureDescriptor);
    }

    @Override
    public boolean isProperty(int n) {
        return this.getFeatureDescriptor(n) instanceof Node.Property;
    }

    @Override
    public void setComparator(Comparator<Node.Property> comparator) {
        if (comparator != this.comparator) {
            this.firePendingChange(true);
            this.comparator = comparator;
            this.fds.clear();
            this.init();
            this.fireChange(true);
        }
    }

    @Override
    public void setPropertySets(Node.PropertySet[] propertySetArray) {
        int n = this.setCount = propertySetArray == null ? 0 : propertySetArray.length;
        if (propertySetArray == null) {
            propertySetArray = new Node.PropertySet[]{};
        }
        if (this.setCount == 0 && !SwingUtilities.isEventDispatchThread()) {
            this.sets = new Node.PropertySet[0];
            this.resetArray(propertySetArray);
            this.fds.clear();
            SwingUtilities.invokeLater(this);
            return;
        }
        this.firePendingChange(false);
        this.sets = propertySetArray;
        this.resetArray(propertySetArray);
        this.init();
        this.run();
    }

    @Override
    public void run() {
        this.fireChange(false);
    }

    private void init() {
        this.fds.clear();
        if (this.comparator == null) {
            this.initExpandable();
        } else {
            this.initPlain();
        }
    }

    private void initPlain() {
        if (this.sets == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.sets.length; ++i) {
            Node.Property[] propertyArray = this.sets[i].getProperties();
            if (propertyArray == null) {
                throw new NullPointerException("Null is not a legal return value for PropertySet.getProperties()");
            }
            n += propertyArray.length;
        }
        Node.Property[] propertyArray = new Node.Property[n];
        int n2 = 0;
        for (int i = 0; i < this.sets.length; ++i) {
            Node.Property[] propertyArray2 = this.sets[i].getProperties();
            System.arraycopy(propertyArray2, 0, propertyArray, n2, propertyArray2.length);
            n2 += propertyArray2.length;
        }
        Arrays.sort(propertyArray, this.comparator);
        this.fds.addAll(this.propsToList(propertyArray));
    }

    private void initExpandable() {
        if (this.sets == null || this.sets.length == 0) {
            return;
        }
        for (int i = 0; i < this.sets.length; ++i) {
            if (PropUtils.hideSingleExpansion) {
                if (this.sets.length > 1 || this.sets.length == 1 && !NbBundle.getMessage(PropertySetModelImpl.class, (String)"CTL_PropertiesNoMnemonic").equals(this.sets[0].getDisplayName())) {
                    this.fds.add((FeatureDescriptor)this.sets[i]);
                }
            } else if (!PropertySheet.forceTabs) {
                this.fds.add((FeatureDescriptor)this.sets[i]);
            }
            if (!this.expanded[i]) continue;
            Node.Property[] propertyArray = this.sets[i].getProperties();
            if (propertyArray == null) {
                throw new NullPointerException("Null is not a legal return value for PropertySet.getProperties()");
            }
            if (propertyArray.length > 0) {
                this.fds.addAll(this.propsToList(propertyArray));
                continue;
            }
            this.fds.remove(this.sets[i]);
        }
    }

    private List<Node.Property> propsToList(Node.Property[] propertyArray) {
        List<Node.Property> list;
        if (filterHiddenProperties) {
            list = new ArrayList<Node.Property>();
            for (int i = 0; i < propertyArray.length; ++i) {
                if (propertyArray[i].isHidden()) continue;
                list.add(propertyArray[i]);
            }
        } else {
            list = Arrays.asList(propertyArray);
        }
        return list;
    }

    private void resetArray(Node.PropertySet[] propertySetArray) {
        int n = propertySetArray.length;
        if (this.expanded == null || this.expanded.length < n) {
            this.expanded = new boolean[n];
        }
        for (int i = 0; i < propertySetArray.length; ++i) {
            this.expanded[i] = !closedSets.contains(propertySetArray[i].getDisplayName());
        }
    }

    private int lookupSet(FeatureDescriptor featureDescriptor) {
        if (this.sets != null) {
            List<Node.PropertySet> list = Arrays.asList(this.sets);
            return list.indexOf(featureDescriptor);
        }
        return -1;
    }

    @Override
    public boolean isExpanded(FeatureDescriptor featureDescriptor) {
        int n = this.lookupSet(featureDescriptor);
        if (n == -1) {
            return false;
        }
        return this.expanded[n];
    }

    @Override
    public void toggleExpanded(int n) {
        FeatureDescriptor featureDescriptor = this.getFeatureDescriptor(n);
        if (featureDescriptor instanceof Node.Property) {
            throw new IllegalArgumentException("Cannot expand a property.");
        }
        int n2 = this.lookupSet(featureDescriptor);
        int n3 = this.expanded[n2] ? 0 : 1;
        List<Node.Property> list = this.propsToList(this.sets[n2].getProperties());
        int n4 = list.size();
        this.expanded[n2] = !this.expanded[n2];
        this.firePendingChange(n3, n + 1, n + n4, false);
        if (!this.expanded[n2]) {
            closedSets.add(featureDescriptor.getDisplayName());
        } else {
            closedSets.remove(featureDescriptor.getDisplayName());
        }
        if (this.expanded[n2]) {
            this.fds.addAll(n + 1, list);
        } else {
            for (int i = n + n4; i > n; --i) {
                this.fds.remove(i);
            }
        }
        this.fireChange(n3, n + 1, n + n4);
        PropUtils.putSavedClosedSetNames(closedSets);
    }

    @Override
    public final void addPropertySetModelListener(PropertySetModelListener propertySetModelListener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<PropertySetModelListener>();
        }
        this.listenerList.add(propertySetModelListener);
    }

    @Override
    public final void removePropertySetModelListener(PropertySetModelListener propertySetModelListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(propertySetModelListener);
        }
    }

    private PropertySetModelEvent getEvent() {
        if (this.event == null) {
            this.event = new PropertySetModelEvent(this);
        }
        return this.event;
    }

    private final void firePendingChange(int n, int n2, int n3, boolean bl) {
        if (this.listenerList == null) {
            return;
        }
        Iterator<PropertySetModelListener> iterator = this.listenerList.iterator();
        this.getEvent().type = 2;
        this.event.start = n2;
        this.event.end = n3;
        this.event.type = n;
        this.event.reordering = bl;
        while (iterator.hasNext()) {
            PropertySetModelListener propertySetModelListener = iterator.next();
            propertySetModelListener.pendingChange(this.event);
        }
    }

    private final void fireChange(boolean bl) {
        if (this.listenerList == null) {
            return;
        }
        Iterator<PropertySetModelListener> iterator = this.listenerList.iterator();
        this.getEvent().type = 2;
        this.event.reordering = bl;
        while (iterator.hasNext()) {
            PropertySetModelListener propertySetModelListener = iterator.next();
            propertySetModelListener.wholesaleChange(this.event);
        }
    }

    private final void firePendingChange(boolean bl) {
        if (this.listenerList == null) {
            return;
        }
        Iterator<PropertySetModelListener> iterator = this.listenerList.iterator();
        this.getEvent().type = 2;
        this.event.reordering = bl;
        while (iterator.hasNext()) {
            PropertySetModelListener propertySetModelListener = iterator.next();
            propertySetModelListener.pendingChange(this.event);
        }
    }

    private final void fireChange(int n, int n2, int n3) {
        if (this.listenerList == null) {
            return;
        }
        this.getEvent().start = n2;
        this.event.end = n3;
        this.event.type = n;
        this.event.reordering = false;
        for (PropertySetModelListener propertySetModelListener : this.listenerList) {
            propertySetModelListener.boundedChange(this.event);
        }
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public int getSetCount() {
        return this.setCount;
    }

    static {
        closedSets.addAll(Arrays.asList(PropUtils.getSavedClosedSetNames()));
    }
}

