/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.util.SecurityUtil;
import jogamp.common.os.DynamicLinkerImpl;

abstract class UnixDynamicLinkerImpl
extends DynamicLinkerImpl {
    UnixDynamicLinkerImpl() {
    }

    protected static native int dlclose(long var0);

    protected static native String dlerror();

    protected static native long dlopen(String var0, int var1);

    protected static native long dlsym(long var0, String var2);

    protected final long openLibraryImpl(String string, int n, boolean bl) throws SecurityException {
        SecurityUtil.checkLinkPermission(string);
        long l = UnixDynamicLinkerImpl.dlopen(string, n);
        if (0L != l) {
            this.incrLibRefCount(l, string);
        } else if (DEBUG || bl) {
            System.err.println("dlopen \"" + string + "\" failed, error: " + UnixDynamicLinkerImpl.dlerror());
        }
        return l;
    }

    protected final long lookupSymbolGlobalImpl(long l, String string) throws SecurityException {
        SecurityUtil.checkAllLinkPermission();
        long l2 = UnixDynamicLinkerImpl.dlsym(l, string);
        if (DEBUG_LOOKUP) {
            System.err.println("DynamicLinkerImpl.lookupSymbolGlobal(" + string + ") -> 0x" + Long.toHexString(l2));
        }
        return l2;
    }

    @Override
    public final long lookupSymbol(long l, String string) throws IllegalArgumentException {
        if (null == this.getLibRef(l)) {
            throw new IllegalArgumentException("Library handle 0x" + Long.toHexString(l) + " unknown.");
        }
        long l2 = UnixDynamicLinkerImpl.dlsym(l, string);
        if (DEBUG_LOOKUP) {
            System.err.println("DynamicLinkerImpl.lookupSymbol(0x" + Long.toHexString(l) + ", " + string + ") -> 0x" + Long.toHexString(l2));
        }
        return l2;
    }

    @Override
    public final void closeLibrary(long l) throws IllegalArgumentException {
        if (null == this.decrLibRefCount(l)) {
            throw new IllegalArgumentException("Library handle 0x" + Long.toHexString(l) + " unknown.");
        }
        UnixDynamicLinkerImpl.dlclose(l);
    }

    @Override
    public final String getLastError() {
        return UnixDynamicLinkerImpl.dlerror();
    }
}

