/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.DeclarationWriterWrapper;
import com.ibm.xmi.framework.DefinitionWriter;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.WriterFactory;
import com.ibm.xmi.framework.XMIDTD;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

abstract class DTDWriter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private XMIDTD dtd;
    protected DeclarationWriterWrapper wrapper;
    protected boolean date;

    public DTDWriter(XMIDTD xMIDTD) {
        this.dtd = xMIDTD;
    }

    public XMIDTD getDTD() {
        return this.dtd;
    }

    public void setDate(boolean bl) {
        this.date = bl;
    }

    public void setDTD(XMIDTD xMIDTD) {
        this.dtd = xMIDTD;
    }

    public void setWrapper(DeclarationWriterWrapper declarationWriterWrapper) {
        this.wrapper = declarationWriterWrapper;
    }

    public void write(int n, int n2) throws Exception {
        PrintXML.setEncoding(this.getDTD().getEncoding());
        this.writeHeader(0, n2);
        this.writeContent(0, n2);
        PrintXML.printEndDocument();
    }

    protected void writeContent(int n, int n2) throws Exception {
        PrintXML.printBlankLine();
        Iterator iterator = this.getDTD().getDeclarations().iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        DefinitionWriter definitionWriter = WriterFactory.makeCompositionsWriter(vector, this.dtd.getXMIVersion());
        definitionWriter.setDTD(this.getDTD());
        definitionWriter.setWrapper(this.wrapper);
        definitionWriter.write(n, n2);
        int n3 = 0;
        while (n3 < vector.size()) {
            definitionWriter = WriterFactory.makeDeclWriter(vector.elementAt(n3), this.dtd.getXMIVersion(), "DTD");
            definitionWriter.setDTD(this.getDTD());
            definitionWriter.setWrapper(this.wrapper);
            definitionWriter.write(n, n2);
            ++n3;
        }
    }

    protected void writeHeader(int n, int n2) throws Exception {
        PrintXML.printXMLPI("1.0");
        PrintXML.printBlankLine();
        PrintXML.printCommentLine("Generated by: XMI Framework 1.2", false, 0);
        if (this.date) {
            PrintXML.printCommentLine("Date: " + new Date(), false, 0);
        }
        if (this.getDTD().getModel() != null) {
            PrintXML.printCommentLine("Model: " + this.getDTD().getModel(), false, 0);
        }
        PrintXML.printBlankLine();
    }
}

