/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;
import org.elasticsearch.painless.node.EConstant;
import org.elasticsearch.painless.node.EStatic;
import org.elasticsearch.painless.node.PSubArrayLength;
import org.elasticsearch.painless.node.PSubDefField;
import org.elasticsearch.painless.node.PSubField;
import org.elasticsearch.painless.node.PSubListShortcut;
import org.elasticsearch.painless.node.PSubMapShortcut;
import org.elasticsearch.painless.node.PSubShortcut;

public final class PField
extends AStoreable {
    private final String value;
    private AStoreable sub = null;

    public PField(Location location, AExpression prefix, String value) {
        super(location, prefix);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.prefix.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        this.prefix.analyze(locals);
        this.prefix.expected = this.prefix.actual;
        this.prefix = this.prefix.cast(locals);
        Definition.Sort sort = this.prefix.actual.sort;
        if (sort == Definition.Sort.ARRAY) {
            this.sub = new PSubArrayLength(this.location, this.prefix.actual.name, this.value);
        } else if (sort == Definition.Sort.DEF) {
            this.sub = new PSubDefField(this.location, this.value);
        } else {
            Definition.Field field;
            Definition.Struct struct = this.prefix.actual.struct;
            Definition.Field field2 = field = this.prefix instanceof EStatic ? struct.staticMembers.get(this.value) : struct.members.get(this.value);
            if (field != null) {
                this.sub = new PSubField(this.location, field);
            } else {
                Definition.Method getter = struct.methods.get(new Definition.MethodKey("get" + Character.toUpperCase(this.value.charAt(0)) + this.value.substring(1), 0));
                if (getter == null) {
                    getter = struct.methods.get(new Definition.MethodKey("is" + Character.toUpperCase(this.value.charAt(0)) + this.value.substring(1), 0));
                }
                Definition.Method setter = struct.methods.get(new Definition.MethodKey("set" + Character.toUpperCase(this.value.charAt(0)) + this.value.substring(1), 1));
                if (getter != null || setter != null) {
                    this.sub = new PSubShortcut(this.location, this.value, this.prefix.actual.name, getter, setter);
                } else {
                    EConstant index = new EConstant(this.location, this.value);
                    index.analyze(locals);
                    if (Map.class.isAssignableFrom(this.prefix.actual.clazz)) {
                        this.sub = new PSubMapShortcut(this.location, struct, index);
                    }
                    if (List.class.isAssignableFrom(this.prefix.actual.clazz)) {
                        this.sub = new PSubListShortcut(this.location, struct, index);
                    }
                }
            }
        }
        if (this.sub == null) {
            throw this.createError(new IllegalArgumentException("Unknown field [" + this.value + "] for type [" + this.prefix.actual.name + "]."));
        }
        this.sub.write = this.write;
        this.sub.read = this.read;
        this.sub.expected = this.expected;
        this.sub.explicit = this.explicit;
        this.sub.analyze(locals);
        this.actual = this.sub.actual;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        this.prefix.write(writer, globals);
        this.sub.write(writer, globals);
    }

    @Override
    boolean isDefOptimized() {
        return this.sub.isDefOptimized();
    }

    @Override
    void updateActual(Definition.Type actual) {
        this.sub.updateActual(actual);
        this.actual = actual;
    }

    @Override
    int accessElementCount() {
        return this.sub.accessElementCount();
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
        this.prefix.write(writer, globals);
        this.sub.setup(writer, globals);
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        this.sub.load(writer, globals);
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        this.sub.store(writer, globals);
    }
}

