/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;

public final class SIfElse
extends AStatement {
    private AExpression condition;
    private final SBlock ifblock;
    private final SBlock elseblock;

    public SIfElse(Location location, AExpression condition, SBlock ifblock, SBlock elseblock) {
        super(location);
        this.condition = Objects.requireNonNull(condition);
        this.ifblock = ifblock;
        this.elseblock = elseblock;
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.condition.extractVariables(variables);
        if (this.ifblock != null) {
            this.ifblock.extractVariables(variables);
        }
        if (this.elseblock != null) {
            this.elseblock.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        this.condition.expected = Definition.BOOLEAN_TYPE;
        this.condition.analyze(locals);
        this.condition = this.condition.cast(locals);
        if (this.condition.constant != null) {
            throw this.createError(new IllegalArgumentException("Extraneous if statement."));
        }
        if (this.ifblock == null) {
            throw this.createError(new IllegalArgumentException("Extraneous if statement."));
        }
        this.ifblock.lastSource = this.lastSource;
        this.ifblock.inLoop = this.inLoop;
        this.ifblock.lastLoop = this.lastLoop;
        this.ifblock.analyze(Locals.newLocalScope(locals));
        this.anyContinue = this.ifblock.anyContinue;
        this.anyBreak = this.ifblock.anyBreak;
        this.statementCount = this.ifblock.statementCount;
        if (this.elseblock == null) {
            throw this.createError(new IllegalArgumentException("Extraneous else statement."));
        }
        this.elseblock.lastSource = this.lastSource;
        this.elseblock.inLoop = this.inLoop;
        this.elseblock.lastLoop = this.lastLoop;
        this.elseblock.analyze(Locals.newLocalScope(locals));
        this.methodEscape = this.ifblock.methodEscape && this.elseblock.methodEscape;
        this.loopEscape = this.ifblock.loopEscape && this.elseblock.loopEscape;
        this.allEscape = this.ifblock.allEscape && this.elseblock.allEscape;
        this.anyContinue |= this.elseblock.anyContinue;
        this.anyBreak |= this.elseblock.anyBreak;
        this.statementCount = Math.max(this.ifblock.statementCount, this.elseblock.statementCount);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        Label fals = new Label();
        Label end = new Label();
        this.condition.write(writer, globals);
        writer.ifZCmp(153, fals);
        this.ifblock.continu = this.continu;
        this.ifblock.brake = this.brake;
        this.ifblock.write(writer, globals);
        if (!this.ifblock.allEscape) {
            writer.goTo(end);
        }
        writer.mark(fals);
        this.elseblock.continu = this.continu;
        this.elseblock.brake = this.brake;
        this.elseblock.write(writer, globals);
        writer.mark(end);
    }
}

