/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.ingest.PipelineExecutionService;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.tasks.Task;

public final class IngestActionFilter
extends AbstractComponent
implements ActionFilter {
    private final PipelineExecutionService executionService;

    @Inject
    public IngestActionFilter(Settings settings, NodeService nodeService) {
        super(settings);
        this.executionService = nodeService.getIngestService().getPipelineExecutionService();
    }

    @Override
    public <Request extends ActionRequest<Request>, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        switch (action) {
            case "indices:data/write/index": {
                IndexRequest indexRequest = (IndexRequest)request;
                if (Strings.hasText(indexRequest.getPipeline())) {
                    this.processIndexRequest(task, action, listener, chain, (IndexRequest)request);
                    break;
                }
                chain.proceed(task, action, request, listener);
                break;
            }
            case "indices:data/write/bulk": {
                BulkRequest bulkRequest = (BulkRequest)request;
                if (bulkRequest.hasIndexRequestsWithPipelines()) {
                    ActionListener<BulkResponse> actionListener = listener;
                    this.processBulkIndexRequest(task, bulkRequest, action, chain, actionListener);
                    break;
                }
                chain.proceed(task, action, request, listener);
                break;
            }
            default: {
                chain.proceed(task, action, request, listener);
            }
        }
    }

    @Override
    public <Response extends ActionResponse> void apply(String action, Response response, ActionListener<Response> listener, ActionFilterChain<?, Response> chain) {
        chain.proceed(action, response, listener);
    }

    void processIndexRequest(Task task, String action, ActionListener listener, ActionFilterChain chain, IndexRequest indexRequest) {
        this.executionService.executeIndexRequest(indexRequest, t -> {
            this.logger.error(() -> new ParameterizedMessage("failed to execute pipeline [{}]", (Object)indexRequest.getPipeline()), (Throwable)t);
            listener.onFailure((Exception)t);
        }, success -> {
            indexRequest.setPipeline(null);
            chain.proceed(task, action, indexRequest, listener);
        });
    }

    void processBulkIndexRequest(Task task, BulkRequest original, String action, ActionFilterChain chain, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = System.nanoTime();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        this.executionService.executeBulkRequest(() -> bulkRequestModifier, (indexRequest, exception) -> {
            this.logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}/{}]", new Object[]{indexRequest.getPipeline(), indexRequest.index(), indexRequest.type(), indexRequest.id()}), (Throwable)exception);
            bulkRequestModifier.markCurrentItemAsFailed((Exception)exception);
        }, exception -> {
            if (exception != null) {
                this.logger.error("failed to execute pipeline for a bulk request", (Throwable)exception);
                listener.onFailure((Exception)exception);
            } else {
                long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ingestStartTimeInNanos);
                BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
                ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, listener);
                if (bulkRequest.requests().isEmpty()) {
                    actionListener.onResponse(new BulkResponse(new BulkItemResponse[0], 0L));
                } else {
                    chain.proceed(task, action, bulkRequest, actionListener);
                }
            }
        });
    }

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    static final class IngestBulkResponseListener
    implements ActionListener<BulkResponse> {
        private final long ingestTookInMillis;
        private final int[] originalSlots;
        private final List<BulkItemResponse> itemResponses;
        private final ActionListener<BulkResponse> actionListener;

        IngestBulkResponseListener(long ingestTookInMillis, int[] originalSlots, List<BulkItemResponse> itemResponses, ActionListener<BulkResponse> actionListener) {
            this.ingestTookInMillis = ingestTookInMillis;
            this.itemResponses = itemResponses;
            this.actionListener = actionListener;
            this.originalSlots = originalSlots;
        }

        @Override
        public void onResponse(BulkResponse response) {
            for (int i = 0; i < response.getItems().length; ++i) {
                this.itemResponses.add(this.originalSlots[i], response.getItems()[i]);
            }
            this.actionListener.onResponse(new BulkResponse(this.itemResponses.toArray(new BulkItemResponse[this.itemResponses.size()]), response.getTookInMillis(), this.ingestTookInMillis));
        }

        @Override
        public void onFailure(Exception e) {
            this.actionListener.onFailure(e);
        }
    }

    static final class BulkRequestModifier
    implements Iterator<ActionRequest<?>> {
        final BulkRequest bulkRequest;
        final Set<Integer> failedSlots;
        final List<BulkItemResponse> itemResponses;
        int currentSlot = -1;
        int[] originalSlots;

        BulkRequestModifier(BulkRequest bulkRequest) {
            this.bulkRequest = bulkRequest;
            this.failedSlots = new HashSet<Integer>();
            this.itemResponses = new ArrayList<BulkItemResponse>(bulkRequest.requests().size());
        }

        @Override
        public ActionRequest next() {
            return this.bulkRequest.requests().get(++this.currentSlot);
        }

        @Override
        public boolean hasNext() {
            return this.currentSlot + 1 < this.bulkRequest.requests().size();
        }

        BulkRequest getBulkRequest() {
            if (this.itemResponses.isEmpty()) {
                return this.bulkRequest;
            }
            BulkRequest modifiedBulkRequest = new BulkRequest();
            modifiedBulkRequest.setRefreshPolicy(this.bulkRequest.getRefreshPolicy());
            modifiedBulkRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
            modifiedBulkRequest.timeout(this.bulkRequest.timeout());
            int slot = 0;
            this.originalSlots = new int[this.bulkRequest.requests().size() - this.failedSlots.size()];
            for (int i = 0; i < this.bulkRequest.requests().size(); ++i) {
                ActionRequest<?> request = this.bulkRequest.requests().get(i);
                if (this.failedSlots.contains(i)) continue;
                modifiedBulkRequest.add(request);
                this.originalSlots[slot++] = i;
            }
            return modifiedBulkRequest;
        }

        ActionListener<BulkResponse> wrapActionListenerIfNeeded(final long ingestTookInMillis, final ActionListener<BulkResponse> actionListener) {
            if (this.itemResponses.isEmpty()) {
                return new ActionListener<BulkResponse>(){

                    @Override
                    public void onResponse(BulkResponse response) {
                        actionListener.onResponse(new BulkResponse(response.getItems(), response.getTookInMillis(), ingestTookInMillis));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        actionListener.onFailure(e);
                    }
                };
            }
            return new IngestBulkResponseListener(ingestTookInMillis, this.originalSlots, this.itemResponses, actionListener);
        }

        void markCurrentItemAsFailed(Exception e) {
            IndexRequest indexRequest = (IndexRequest)this.bulkRequest.requests().get(this.currentSlot);
            this.failedSlots.add(this.currentSlot);
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), e);
            this.itemResponses.add(new BulkItemResponse(this.currentSlot, indexRequest.opType().lowercase(), failure));
        }
    }
}

