/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Settings;

public class RebalanceOnlyWhenActiveAllocationDecider
extends AllocationDecider {
    public static final String NAME = "rebalance_only_when_active";

    public RebalanceOnlyWhenActiveAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (!allocation.routingNodes().allReplicasActive(shardRouting.shardId(), allocation.metaData())) {
            return allocation.decision(Decision.NO, NAME, "rebalancing can not occur if not all replicas are active in the cluster", new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, "all replicas are active in the cluster, rebalancing can occur", new Object[0]);
    }
}

