/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.elasticsearch.common.SuppressLoggerChecks;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class DeprecationLogger {
    private final Logger logger;
    public static final String DEPRECATION_HEADER = "Warning";
    private static final CopyOnWriteArraySet<ThreadContext> THREAD_CONTEXT = new CopyOnWriteArraySet();

    public static void setThreadContext(ThreadContext threadContext) {
        assert (threadContext != null);
        if (!THREAD_CONTEXT.add(threadContext)) {
            throw new IllegalStateException("Double-setting ThreadContext not allowed!");
        }
    }

    public static void removeThreadContext(ThreadContext threadContext) {
        assert (threadContext != null);
        if (!THREAD_CONTEXT.remove(threadContext)) {
            throw new IllegalStateException("Removing unknown ThreadContext not allowed!");
        }
    }

    public DeprecationLogger(Logger parentLogger) {
        String name = parentLogger.getName();
        name = name.startsWith("org.elasticsearch") ? name.replace("org.elasticsearch.", "org.elasticsearch.deprecation.") : "deprecation." + name;
        this.logger = LogManager.getLogger((String)name, (MessageFactory)parentLogger.getMessageFactory());
    }

    public void deprecated(String msg, Object ... params) {
        this.deprecated(THREAD_CONTEXT, msg, params);
    }

    @SuppressLoggerChecks(reason="safely delegates to logger")
    void deprecated(Set<ThreadContext> threadContexts, String message, Object ... params) {
        Iterator<ThreadContext> iterator = threadContexts.iterator();
        if (iterator.hasNext()) {
            String formattedMessage = LoggerMessageFormat.format(message, params);
            while (iterator.hasNext()) {
                try {
                    iterator.next().addResponseHeader(DEPRECATION_HEADER, formattedMessage);
                }
                catch (IllegalStateException illegalStateException) {}
            }
            this.logger.warn(formattedMessage);
        } else {
            this.logger.warn(message, params);
        }
    }
}

