/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Objects;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;

public class SourceToParse {
    private final Origin origin;
    private final BytesReference source;
    private final String index;
    private final String type;
    private final String id;
    private String routing;
    private String parentId;
    private long timestamp;
    private long ttl;

    public static SourceToParse source(String index, String type, String id, BytesReference source) {
        return SourceToParse.source(Origin.PRIMARY, index, type, id, source);
    }

    public static SourceToParse source(Origin origin, String index, String type, String id, BytesReference source) {
        return new SourceToParse(origin, index, type, id, source);
    }

    private SourceToParse(Origin origin, String index, String type, String id, BytesReference source) {
        this.origin = Objects.requireNonNull(origin);
        this.index = Objects.requireNonNull(index);
        this.type = Objects.requireNonNull(type);
        this.id = Objects.requireNonNull(id);
        this.source = new BytesArray(source.toBytesRef());
    }

    public Origin origin() {
        return this.origin;
    }

    public BytesReference source() {
        return this.source;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String parent() {
        return this.parentId;
    }

    public SourceToParse parent(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SourceToParse routing(String routing) {
        this.routing = routing;
        return this;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public SourceToParse timestamp(String timestamp) {
        this.timestamp = Long.parseLong(timestamp);
        return this;
    }

    public SourceToParse timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public long ttl() {
        return this.ttl;
    }

    public SourceToParse ttl(TimeValue ttl) {
        if (ttl == null) {
            this.ttl = -1L;
            return this;
        }
        this.ttl = ttl.millis();
        return this;
    }

    public SourceToParse ttl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public static enum Origin {
        PRIMARY,
        REPLICA;

    }
}

