/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.BaseTranslogReader;
import org.elasticsearch.index.translog.ChannelFactory;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogReader;

public class TranslogWriter
extends BaseTranslogReader
implements Closeable {
    public static final String TRANSLOG_CODEC = "translog";
    public static final int VERSION_CHECKSUMS = 1;
    public static final int VERSION_CHECKPOINTS = 2;
    public static final int VERSION = 2;
    private final ShardId shardId;
    private final ChannelFactory channelFactory;
    private volatile long lastSyncedOffset;
    private volatile int operationCounter;
    private volatile Exception tragedy;
    private final OutputStream outputStream;
    private volatile long totalOffset;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object syncLock = new Object();

    public TranslogWriter(ChannelFactory channelFactory, ShardId shardId, long generation, FileChannel channel, Path path, ByteSizeValue bufferSize) throws IOException {
        super(generation, channel, path, channel.position());
        this.shardId = shardId;
        this.channelFactory = channelFactory;
        this.outputStream = new BufferedChannelOutputStream(Channels.newOutputStream(channel), bufferSize.bytesAsInt());
        this.totalOffset = this.lastSyncedOffset = channel.position();
    }

    static int getHeaderLength(String translogUUID) {
        return TranslogWriter.getHeaderLength(new BytesRef((CharSequence)translogUUID).length);
    }

    static int getHeaderLength(int uuidLength) {
        return CodecUtil.headerLength((String)TRANSLOG_CODEC) + uuidLength + 4;
    }

    static void writeHeader(OutputStreamDataOutput out, BytesRef ref) throws IOException {
        CodecUtil.writeHeader((DataOutput)out, (String)TRANSLOG_CODEC, (int)2);
        out.writeInt(ref.length);
        out.writeBytes(ref.bytes, ref.offset, ref.length);
    }

    public static TranslogWriter create(ShardId shardId, String translogUUID, long fileGeneration, Path file, ChannelFactory channelFactory, ByteSizeValue bufferSize) throws IOException {
        BytesRef ref = new BytesRef((CharSequence)translogUUID);
        int headerLength = TranslogWriter.getHeaderLength(ref.length);
        FileChannel channel = channelFactory.open(file);
        try {
            OutputStreamDataOutput out = new OutputStreamDataOutput(Channels.newOutputStream(channel));
            TranslogWriter.writeHeader(out, ref);
            channel.force(true);
            TranslogWriter.writeCheckpoint(channelFactory, headerLength, 0, file.getParent(), fileGeneration);
            TranslogWriter writer = new TranslogWriter(channelFactory, shardId, fileGeneration, channel, file, bufferSize);
            return writer;
        }
        catch (Exception exception) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{channel});
            throw exception;
        }
    }

    public Exception getTragicException() {
        return this.tragedy;
    }

    private synchronized void closeWithTragicEvent(Exception exception) throws IOException {
        assert (exception != null);
        if (this.tragedy == null) {
            this.tragedy = exception;
        } else if (this.tragedy != exception) {
            this.tragedy.addSuppressed(exception);
        }
        this.close();
    }

    public synchronized Translog.Location add(BytesReference data) throws IOException {
        this.ensureOpen();
        long offset = this.totalOffset;
        try {
            data.writeTo(this.outputStream);
        }
        catch (Exception ex) {
            try {
                this.closeWithTragicEvent(ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
        this.totalOffset += (long)data.length();
        ++this.operationCounter;
        return new Translog.Location(this.generation, offset, data.length());
    }

    public void sync() throws IOException {
        this.syncUpTo(Long.MAX_VALUE);
    }

    public boolean syncNeeded() {
        return this.totalOffset != this.lastSyncedOffset;
    }

    @Override
    public int totalOperations() {
        return this.operationCounter;
    }

    @Override
    public long sizeInBytes() {
        return this.totalOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TranslogReader closeIntoReader() throws IOException {
        Object object = this.syncLock;
        synchronized (object) {
            TranslogWriter translogWriter = this;
            synchronized (translogWriter) {
                TranslogReader translogReader;
                try {
                    this.sync();
                }
                catch (IOException e) {
                    try {
                        this.closeWithTragicEvent(e);
                        throw e;
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                    throw e;
                }
                if (!this.closed.compareAndSet(false, true)) throw new AlreadyClosedException("translog [" + this.getGeneration() + "] is already closed (path [" + this.path + "]", (Throwable)this.tragedy);
                boolean success = false;
                try {
                    TranslogReader reader = new TranslogReader(this.generation, this.channel, this.path, this.firstOperationOffset, this.getWrittenOffset(), this.operationCounter);
                    success = true;
                    translogReader = reader;
                    if (success) return translogReader;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.channel});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.channel});
                return translogReader;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Translog.Snapshot newSnapshot() {
        Object object = this.syncLock;
        synchronized (object) {
            TranslogWriter translogWriter = this;
            synchronized (translogWriter) {
                this.ensureOpen();
                try {
                    this.sync();
                }
                catch (IOException e) {
                    throw new TranslogException(this.shardId, "exception while syncing before creating a snapshot", e);
                }
                return super.newSnapshot();
            }
        }
    }

    private long getWrittenOffset() throws IOException {
        return this.channel.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncUpTo(long offset) throws IOException {
        if (this.lastSyncedOffset < offset && this.syncNeeded()) {
            Object object = this.syncLock;
            synchronized (object) {
                if (this.lastSyncedOffset < offset && this.syncNeeded()) {
                    int opsCounter;
                    long offsetToSync;
                    TranslogWriter translogWriter = this;
                    synchronized (translogWriter) {
                        this.ensureOpen();
                        try {
                            this.outputStream.flush();
                            offsetToSync = this.totalOffset;
                            opsCounter = this.operationCounter;
                        }
                        catch (Exception ex) {
                            try {
                                this.closeWithTragicEvent(ex);
                            }
                            catch (Exception inner) {
                                ex.addSuppressed(inner);
                            }
                            throw ex;
                        }
                    }
                    try {
                        this.channel.force(false);
                        TranslogWriter.writeCheckpoint(this.channelFactory, offsetToSync, opsCounter, this.path.getParent(), this.generation);
                    }
                    catch (Exception ex) {
                        try {
                            this.closeWithTragicEvent(ex);
                        }
                        catch (Exception inner) {
                            ex.addSuppressed(inner);
                        }
                        throw ex;
                    }
                    assert (this.lastSyncedOffset <= offsetToSync) : "illegal state: " + this.lastSyncedOffset + " <= " + offsetToSync;
                    this.lastSyncedOffset = offsetToSync;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readBytes(ByteBuffer targetBuffer, long position) throws IOException {
        if (position + (long)targetBuffer.remaining() > this.getWrittenOffset()) {
            TranslogWriter translogWriter = this;
            synchronized (translogWriter) {
                if (position + (long)targetBuffer.remaining() > this.getWrittenOffset()) {
                    this.outputStream.flush();
                }
            }
        }
        org.elasticsearch.common.io.Channels.readFromFileChannelWithEofException(this.channel, position, targetBuffer);
    }

    private static void writeCheckpoint(ChannelFactory channelFactory, long syncPosition, int numOperations, Path translogFile, long generation) throws IOException {
        Path checkpointFile = translogFile.resolve("translog.ckp");
        Checkpoint checkpoint = new Checkpoint(syncPosition, numOperations, generation);
        Checkpoint.write(channelFactory::open, checkpointFile, checkpoint, StandardOpenOption.WRITE);
    }

    protected final void ensureOpen() {
        if (this.isClosed()) {
            throw new AlreadyClosedException("translog [" + this.getGeneration() + "] is already closed", (Throwable)this.tragedy);
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channel.close();
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }

    private final class BufferedChannelOutputStream
    extends BufferedOutputStream {
        public BufferedChannelOutputStream(OutputStream out, int size) throws IOException {
            super(out, size);
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.count > 0) {
                try {
                    TranslogWriter.this.ensureOpen();
                    super.flush();
                }
                catch (Exception ex) {
                    try {
                        TranslogWriter.this.closeWithTragicEvent(ex);
                    }
                    catch (Exception inner) {
                        ex.addSuppressed(inner);
                    }
                    throw ex;
                }
            }
        }

        @Override
        public void close() throws IOException {
            throw new IllegalStateException("never close this stream");
        }
    }
}

