/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Map;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.cli.SettingCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.internal.InternalSettingsPreparer;

final class RemovePluginCommand
extends SettingCommand {
    private final OptionSpec<String> arguments;

    RemovePluginCommand() {
        super("Removes a plugin from elasticsearch");
        this.arguments = this.parser.nonOptions("plugin name");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Map<String, String> settings) throws Exception {
        String arg = (String)this.arguments.value(options);
        this.execute(terminal, arg, settings);
    }

    void execute(Terminal terminal, String pluginName, Map<String, String> settings) throws Exception {
        Environment env = InternalSettingsPreparer.prepareEnvironment(Settings.EMPTY, terminal, settings);
        terminal.println("-> Removing " + Strings.coalesceToEmpty(pluginName) + "...");
        Path pluginDir = env.pluginsFile().resolve(pluginName);
        if (!Files.exists(pluginDir, new LinkOption[0])) {
            throw new UserException(64, "plugin " + pluginName + " not found; run 'elasticsearch-plugin list' to get list of installed plugins");
        }
        ArrayList<Path> pluginPaths = new ArrayList<Path>();
        Path pluginBinDir = env.binFile().resolve(pluginName);
        if (Files.exists(pluginBinDir, new LinkOption[0])) {
            if (!Files.isDirectory(pluginBinDir, new LinkOption[0])) {
                throw new UserException(74, "Bin dir for " + pluginName + " is not a directory");
            }
            pluginPaths.add(pluginBinDir);
            terminal.println(Terminal.Verbosity.VERBOSE, "Removing: " + pluginBinDir);
        }
        terminal.println(Terminal.Verbosity.VERBOSE, "Removing: " + pluginDir);
        Path tmpPluginDir = env.pluginsFile().resolve(".removing-" + pluginName);
        Files.move(pluginDir, tmpPluginDir, StandardCopyOption.ATOMIC_MOVE);
        pluginPaths.add(tmpPluginDir);
        IOUtils.rm((Path[])pluginPaths.toArray(new Path[pluginPaths.size()]));
        Path pluginConfigDir = env.configFile().resolve(pluginName);
        if (Files.exists(pluginConfigDir, new LinkOption[0])) {
            terminal.println("-> Preserving plugin config files [" + pluginConfigDir + "] in case of upgrade, delete manually if not needed");
        }
    }
}

