/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.scripts.IndicScriptProcessor;
import org.apache.fop.complexscripts.util.CharAssociation;
import org.apache.fop.complexscripts.util.GlyphSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GurmukhiScriptProcessor
extends IndicScriptProcessor {
    private static final Log log = LogFactory.getLog(GurmukhiScriptProcessor.class);
    static final short C_U = 0;
    static final short C_C = 1;
    static final short C_V = 2;
    static final short C_M = 3;
    static final short C_S = 4;
    static final short C_T = 5;
    static final short C_A = 6;
    static final short C_P = 7;
    static final short C_D = 8;
    static final short C_H = 9;
    static final short C_O = 10;
    static final short C_N = 256;
    static final short C_R = 512;
    static final short C_PRE = 1024;
    static final short C_M_TYPE = 255;
    static final short C_M_FLAGS = 32512;
    static final int CCA_START = 2560;
    static final int CCA_END = 2688;
    static final short[] CCA = new short[]{0, 10, 10, 10, 0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 2, 2, 0, 0, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 513, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 256, 0, 3, 1027, 3, 3, 3, 0, 0, 0, 0, 3, 3, 0, 0, 3, 3, 9, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 257, 257, 257, 257, 0, 257, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 2, 2, 4, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    GurmukhiScriptProcessor(String script) {
        super(script);
    }

    protected Class<? extends GurmukhiSyllabizer> getSyllabizerClass() {
        return GurmukhiSyllabizer.class;
    }

    @Override
    protected int findPreBaseMatra(GlyphSequence gs) {
        int ng = gs.getGlyphCount();
        int lk = -1;
        for (int i = ng; i > 0; --i) {
            int k = i - 1;
            if (!GurmukhiScriptProcessor.containsPreBaseMatra(gs, k)) continue;
            lk = k;
            break;
        }
        return lk;
    }

    @Override
    protected int findPreBaseMatraTarget(GlyphSequence gs, int source) {
        int i;
        int ng = gs.getGlyphCount();
        int lk = -1;
        int n = i = source < ng ? source : ng;
        while (i > 0) {
            int k = i - 1;
            if (GurmukhiScriptProcessor.containsConsonant(gs, k)) {
                if (GurmukhiScriptProcessor.containsHalfConsonant(gs, k)) {
                    lk = k;
                } else {
                    if (lk != -1) break;
                    lk = k;
                }
            }
            --i;
        }
        return lk;
    }

    private static boolean containsPreBaseMatra(GlyphSequence gs, int k) {
        CharAssociation a = gs.getAssociation(k);
        int[] ca = gs.getCharacterArray(false);
        int e = a.getEnd();
        for (int i = a.getStart(); i < e; ++i) {
            if (!GurmukhiScriptProcessor.isPreM(ca[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsConsonant(GlyphSequence gs, int k) {
        CharAssociation a = gs.getAssociation(k);
        int[] ca = gs.getCharacterArray(false);
        int e = a.getEnd();
        for (int i = a.getStart(); i < e; ++i) {
            if (!GurmukhiScriptProcessor.isC(ca[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsHalfConsonant(GlyphSequence gs, int k) {
        Boolean half = (Boolean)gs.getAssociation(k).getPredication("half");
        return half != null ? half : false;
    }

    @Override
    protected int findReph(GlyphSequence gs) {
        int ng = gs.getGlyphCount();
        int li = -1;
        for (int i = 0; i < ng; ++i) {
            if (!GurmukhiScriptProcessor.containsReph(gs, i)) continue;
            li = i;
            break;
        }
        return li;
    }

    @Override
    protected int findRephTarget(GlyphSequence gs, int source) {
        int i;
        int ng = gs.getGlyphCount();
        int c1 = -1;
        int c2 = -1;
        for (i = 0; i < ng; ++i) {
            if (i == source || !GurmukhiScriptProcessor.containsConsonant(gs, i) || GurmukhiScriptProcessor.containsHalfConsonant(gs, i)) continue;
            c1 = i + 1;
            break;
        }
        int n = i = c1 >= 0 ? c1 : 0;
        while (i < ng) {
            if (GurmukhiScriptProcessor.containsMatra(gs, i) && !GurmukhiScriptProcessor.containsPreBaseMatra(gs, i)) {
                c2 = i + 1;
            } else if (GurmukhiScriptProcessor.containsOtherMark(gs, i)) {
                c2 = i;
                break;
            }
            ++i;
        }
        if (c2 >= 0) {
            return c2;
        }
        if (c1 >= 0) {
            return c1;
        }
        return source;
    }

    private static boolean containsReph(GlyphSequence gs, int k) {
        Boolean rphf = (Boolean)gs.getAssociation(k).getPredication("rphf");
        return rphf != null ? rphf : false;
    }

    private static boolean containsMatra(GlyphSequence gs, int k) {
        CharAssociation a = gs.getAssociation(k);
        int[] ca = gs.getCharacterArray(false);
        int e = a.getEnd();
        for (int i = a.getStart(); i < e; ++i) {
            if (!GurmukhiScriptProcessor.isM(ca[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsOtherMark(GlyphSequence gs, int k) {
        CharAssociation a = gs.getAssociation(k);
        int[] ca = gs.getCharacterArray(false);
        int e = a.getEnd();
        for (int i = a.getStart(); i < e; ++i) {
            switch (GurmukhiScriptProcessor.typeOf(ca[i])) {
                case 5: 
                case 6: 
                case 10: {
                    return true;
                }
            }
        }
        return false;
    }

    static int typeOf(int c) {
        if (c >= 2560 && c < 2688) {
            return CCA[c - 2560] & 0xFF;
        }
        return 0;
    }

    static boolean isType(int c, int t) {
        return GurmukhiScriptProcessor.typeOf(c) == t;
    }

    static boolean hasFlag(int c, int f) {
        if (c >= 2560 && c < 2688) {
            return (CCA[c - 2560] & f) == f;
        }
        return false;
    }

    static boolean isC(int c) {
        return GurmukhiScriptProcessor.isType(c, 1);
    }

    static boolean isR(int c) {
        return GurmukhiScriptProcessor.isType(c, 1) && GurmukhiScriptProcessor.hasR(c);
    }

    static boolean isV(int c) {
        return GurmukhiScriptProcessor.isType(c, 2);
    }

    static boolean isN(int c) {
        return c == 2620;
    }

    static boolean isH(int c) {
        return c == 2637;
    }

    static boolean isM(int c) {
        return GurmukhiScriptProcessor.isType(c, 3);
    }

    static boolean isPreM(int c) {
        return GurmukhiScriptProcessor.isType(c, 3) && GurmukhiScriptProcessor.hasFlag(c, 1024);
    }

    static boolean isX(int c) {
        switch (GurmukhiScriptProcessor.typeOf(c)) {
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    static boolean hasR(int c) {
        return GurmukhiScriptProcessor.hasFlag(c, 512);
    }

    static boolean hasN(int c) {
        return GurmukhiScriptProcessor.hasFlag(c, 256);
    }

    private static class GurmukhiSyllabizer
    extends IndicScriptProcessor.DefaultSyllabizer {
        GurmukhiSyllabizer(String script, String language) {
            super(script, language);
        }

        protected int findStartOfSyllable(int[] ca, int s, int e) {
            int c;
            if (s < 0 || s >= e) {
                return -1;
            }
            while (s < e && !GurmukhiScriptProcessor.isC(c = ca[s])) {
                ++s;
            }
            return s;
        }

        protected int findEndOfSyllable(int[] ca, int s, int e) {
            int i;
            if (s < 0 || s >= e) {
                return -1;
            }
            int nd = 0;
            int nl = 0;
            while ((i = this.isDeadConsonant(ca, s, e)) > s) {
                s = i;
                ++nd;
            }
            i = this.isLiveConsonant(ca, s, e);
            if (i > s) {
                s = i;
                ++nl;
            }
            return nd > 0 || nl > 0 ? s : -1;
        }

        private int isDeadConsonant(int[] ca, int s, int e) {
            int nh;
            int nc;
            int i;
            block7: {
                int c;
                block6: {
                    if (s < 0) {
                        return -1;
                    }
                    i = 0;
                    nc = 0;
                    nh = 0;
                    if (s + i >= e) break block6;
                    c = ca[s + i];
                    if (!GurmukhiScriptProcessor.isC(c)) break block7;
                    ++i;
                    ++nc;
                }
                if (s + i < e && GurmukhiScriptProcessor.isN(c = ca[s + 1])) {
                    ++i;
                }
                if (s + i < e && GurmukhiScriptProcessor.isH(c = ca[s + i])) {
                    ++i;
                    ++nh;
                }
            }
            return nc > 0 && nh > 0 ? s + i : -1;
        }

        private int isLiveConsonant(int[] ca, int s, int e) {
            int c;
            int nx;
            int nv;
            int nc;
            int i;
            block12: {
                block10: {
                    block11: {
                        if (s < 0) {
                            return -1;
                        }
                        i = 0;
                        nc = 0;
                        nv = 0;
                        nx = 0;
                        if (s + i >= e) break block10;
                        c = ca[s + i];
                        if (!GurmukhiScriptProcessor.isC(c)) break block11;
                        ++i;
                        ++nc;
                        break block10;
                    }
                    if (!GurmukhiScriptProcessor.isV(c)) break block12;
                    ++i;
                    ++nv;
                }
                if (s + i < e && GurmukhiScriptProcessor.isN(c = ca[s + i])) {
                    ++i;
                }
                while (s + i < e && GurmukhiScriptProcessor.isX(c = ca[s + i])) {
                    ++i;
                    ++nx;
                }
            }
            if (nx == 0 && s + i < e && GurmukhiScriptProcessor.isH(c = ca[s + i])) {
                if (nc > 0) {
                    --nc;
                } else if (nv > 0) {
                    --nv;
                }
            }
            return nc > 0 || nv > 0 ? s + i : -1;
        }
    }
}

