/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.ScriptRuntime;

public class Conversions {
    public static final int EIGHT_BIT = 256;
    public static final int SIXTEEN_BIT = 65536;
    public static final long THIRTYTWO_BIT = 0x100000000L;

    public static int toInt8(Object object) {
        int n = object instanceof Integer ? (Integer)object : ScriptRuntime.toInt32(object);
        int n2 = n % 256;
        return n2 >= 128 ? n2 - 256 : n2;
    }

    public static int toUint8(Object object) {
        int n = object instanceof Integer ? (Integer)object : ScriptRuntime.toInt32(object);
        return n % 256;
    }

    public static int toUint8Clamp(Object object) {
        double d = ScriptRuntime.toNumber(object);
        if (d <= 0.0) {
            return 0;
        }
        if (d >= 255.0) {
            return 255;
        }
        double d2 = Math.floor(d);
        if (d2 + 0.5 < d) {
            return (int)(d2 + 1.0);
        }
        if (d < d2 + 0.5) {
            return (int)d2;
        }
        if ((int)d2 % 2 != 0) {
            return (int)d2 + 1;
        }
        return (int)d2;
    }

    public static int toInt16(Object object) {
        int n = object instanceof Integer ? (Integer)object : ScriptRuntime.toInt32(object);
        int n2 = n % 65536;
        return n2 >= 32768 ? n2 - 65536 : n2;
    }

    public static int toUint16(Object object) {
        int n = object instanceof Integer ? (Integer)object : ScriptRuntime.toInt32(object);
        return n % 65536;
    }

    public static int toInt32(Object object) {
        long l = (long)ScriptRuntime.toNumber(object);
        long l2 = l % 0x100000000L;
        return (int)(l2 >= 0x80000000L ? l2 - 0x100000000L : l2);
    }

    public static long toUint32(Object object) {
        long l = (long)ScriptRuntime.toNumber(object);
        return l % 0x100000000L;
    }
}

