/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.ClassSetAnalysisUpdater;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotWriter;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

class IncrementalCompilationFinalizer
implements Compiler<JavaCompileSpec> {
    private final Compiler<JavaCompileSpec> delegate;
    private final JarClasspathSnapshotWriter writer;
    private final ClassSetAnalysisUpdater updater;

    public IncrementalCompilationFinalizer(Compiler<JavaCompileSpec> delegate, JarClasspathSnapshotWriter writer, ClassSetAnalysisUpdater updater) {
        this.delegate = delegate;
        this.writer = writer;
        this.updater = updater;
    }

    public WorkResult execute(JavaCompileSpec spec) {
        WorkResult out = this.delegate.execute((CompileSpec)spec);
        if (!(out instanceof RecompilationNotNecessary)) {
            this.updater.updateAnalysis(spec);
        }
        this.writer.storeJarSnapshots(spec.getClasspath());
        return out;
    }
}

