/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerClientsManager;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemon;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonClient;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

@ThreadSafe
public class CompilerDaemonManager
implements CompilerDaemonFactory,
Stoppable {
    private CompilerClientsManager clientsManager;

    public CompilerDaemonManager(CompilerClientsManager clientsManager) {
        this.clientsManager = clientsManager;
    }

    @Override
    public CompilerDaemon getDaemon(final File workingDir, final DaemonForkOptions forkOptions) {
        return new CompilerDaemon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T extends CompileSpec> CompileResult execute(Compiler<T> compiler, T spec) {
                CompilerDaemonClient client = CompilerDaemonManager.this.clientsManager.reserveIdleClient(forkOptions);
                if (client == null) {
                    client = CompilerDaemonManager.this.clientsManager.reserveNewClient(workingDir, forkOptions);
                }
                try {
                    CompileResult compileResult = client.execute(compiler, spec);
                    return compileResult;
                }
                finally {
                    CompilerDaemonManager.this.clientsManager.release(client);
                }
            }
        };
    }

    public void stop() {
        this.clientsManager.stop();
    }
}

