/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.prebuilt;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryRequirement;
import org.gradle.nativeplatform.PrebuiltLibraries;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.Repositories;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;

public class PrebuiltLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final ProjectModelResolver projectModelResolver;

    public PrebuiltLibraryBinaryLocator(ProjectModelResolver projectModelResolver) {
        this.projectModelResolver = projectModelResolver;
    }

    @Override
    public DomainObjectSet<NativeLibraryBinary> getBinaries(NativeLibraryRequirement requirement) {
        ModelRegistry projectModel = this.projectModelResolver.resolveProjectModel(requirement.getProjectPath());
        NamedDomainObjectSet repositories = ((Repositories)projectModel.realize("repositories", Repositories.class)).withType(PrebuiltLibraries.class);
        if (repositories.isEmpty()) {
            return null;
        }
        PrebuiltLibrary prebuiltLibrary = this.getPrebuiltLibrary((NamedDomainObjectSet<PrebuiltLibraries>)repositories, requirement.getLibraryName());
        return prebuiltLibrary != null ? prebuiltLibrary.getBinaries() : null;
    }

    private PrebuiltLibrary getPrebuiltLibrary(NamedDomainObjectSet<PrebuiltLibraries> repositories, String libraryName) {
        for (PrebuiltLibraries prebuiltLibraries : repositories) {
            PrebuiltLibrary prebuiltLibrary = prebuiltLibraries.resolveLibrary(libraryName);
            if (prebuiltLibrary == null) continue;
            return prebuiltLibrary;
        }
        return null;
    }
}

