/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

public class RangeCodegenUtil {
    private static final ImmutableMap<FqName, PrimitiveType> RANGE_TO_ELEMENT_TYPE;
    private static final ImmutableMap<FqName, PrimitiveType> PROGRESSION_TO_ELEMENT_TYPE;

    @NotNull
    public static List<PrimitiveType> supportedRangeTypes() {
        List<PrimitiveType> list2 = Arrays.asList(PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.LONG);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "supportedRangeTypes"));
        }
        return list2;
    }

    private RangeCodegenUtil() {
    }

    public static boolean isRange(KotlinType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveRangeElementType(rangeType) != null;
    }

    public static boolean isProgression(KotlinType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveProgressionElementType(rangeType) != null;
    }

    @Nullable
    public static ResolvedCall<? extends CallableDescriptor> getLoopRangeResolvedCall(@NotNull KtForExpression forExpression, @NotNull BindingContext bindingContext) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getLoopRangeResolvedCall"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getLoopRangeResolvedCall"));
        }
        KtExpression loopRange = KtPsiUtil.deparenthesize(forExpression.getLoopRange());
        if (loopRange instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)loopRange;
            KtExpression selector = qualifiedExpression.getSelectorExpression();
            if (selector instanceof KtCallExpression || selector instanceof KtSimpleNameExpression) {
                return CallUtilKt.getResolvedCall(selector, bindingContext);
            }
        } else {
            if (loopRange instanceof KtSimpleNameExpression || loopRange instanceof KtCallExpression) {
                return CallUtilKt.getResolvedCall(loopRange, bindingContext);
            }
            if (loopRange instanceof KtBinaryExpression) {
                return CallUtilKt.getResolvedCall(((KtBinaryExpression)loopRange).getOperationReference(), bindingContext);
            }
        }
        return null;
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeElementType(KotlinType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, RANGE_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveProgressionElementType(KotlinType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, PROGRESSION_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull KotlinType rangeOrProgression, @NotNull ImmutableMap<FqName, PrimitiveType> map2) {
        if (rangeOrProgression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeOrProgression", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        ClassifierDescriptor declarationDescriptor = rangeOrProgression.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor == null) {
            return null;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(declarationDescriptor);
        if (!fqName2.isSafe()) {
            return null;
        }
        return map2.get(fqName2.toSafe());
    }

    @Nullable
    public static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull FqName rangeOrProgressionName) {
        if (rangeOrProgressionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeOrProgressionName", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        PrimitiveType result2 = RANGE_TO_ELEMENT_TYPE.get(rangeOrProgressionName);
        return result2 != null ? result2 : PROGRESSION_TO_ELEMENT_TYPE.get(rangeOrProgressionName);
    }

    public static boolean isRangeOrProgression(@NotNull FqName className2) {
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isRangeOrProgression"));
        }
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(className2) != null;
    }

    public static boolean isOptimizableRangeTo(CallableDescriptor rangeTo) {
        return "rangeTo".equals(rangeTo.getName().asString()) && AsmUtil.isPrimitiveNumberClassDescriptor(rangeTo.getContainingDeclaration());
    }

    public static boolean isOptimizableDownTo(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isOptimizableDownTo"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "downTo", "kotlin.ranges")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver2 == null) {
            return false;
        }
        ClassifierDescriptor extensionReceiverClassifier = extensionReceiver2.getType().getConstructor().getDeclarationDescriptor();
        return AsmUtil.isPrimitiveNumberClassDescriptor(extensionReceiverClassifier);
    }

    public static boolean isArrayOrPrimitiveArrayIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isArrayOrPrimitiveArrayIndices"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.collections")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver2 == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver2.getType();
        return KotlinBuiltIns.isArray(extensionReceiverType) || KotlinBuiltIns.isPrimitiveArray(extensionReceiverType);
    }

    public static boolean isCollectionIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isCollectionIndices"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.collections")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver2 == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver2.getType();
        return KotlinBuiltIns.isCollectionOrNullableCollection(extensionReceiverType);
    }

    public static boolean isCharSequenceIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isCharSequenceIndices"));
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.text")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver2 == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver2.getType();
        return KotlinBuiltIns.isCharSequenceOrNullableCharSequence(extensionReceiverType);
    }

    private static boolean isTopLevelInPackage(@NotNull CallableDescriptor descriptor2, @NotNull String name, @NotNull String packageName) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isTopLevelInPackage"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isTopLevelInPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isTopLevelInPackage"));
        }
        if (!name.equals(descriptor2.getName().asString())) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(containingDeclaration instanceof PackageFragmentDescriptor)) {
            return false;
        }
        String packageFqName = ((PackageFragmentDescriptor)containingDeclaration).getFqName().asString();
        return packageName.equals(packageFqName);
    }

    static {
        ImmutableMap.Builder<FqName, PrimitiveType> rangeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<FqName, PrimitiveType> progressionBuilder = ImmutableMap.builder();
        for (PrimitiveType primitiveType : RangeCodegenUtil.supportedRangeTypes()) {
            FqName rangeClassFqName = KotlinBuiltIns.RANGES_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Range"));
            FqName progressionClassFqName = KotlinBuiltIns.RANGES_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Progression"));
            rangeBuilder.put(rangeClassFqName, primitiveType);
            progressionBuilder.put(progressionClassFqName, primitiveType);
        }
        RANGE_TO_ELEMENT_TYPE = rangeBuilder.build();
        PROGRESSION_TO_ELEMENT_TYPE = progressionBuilder.build();
    }
}

