/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.SerializationFilter;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.AbstractCollection;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Text;

abstract class AbstractCollectionBinding
extends Binding
implements MultiNodeBinding {
    private Map<Class<?>, Binding> itemBindings;
    protected final Class<?> itemType;
    private final AbstractCollection annotation;

    public AbstractCollectionBinding(@NotNull Class elementType, @Nullable MutableAccessor accessor) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "<init>"));
        }
        super(accessor);
        this.itemType = elementType;
        this.annotation = accessor == null ? null : accessor.getAnnotation(AbstractCollection.class);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init(@NotNull Type originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "init"));
        }
        if (this.annotation == null || this.annotation.surroundWithTag()) {
            return;
        }
        if (StringUtil.isEmpty(this.annotation.elementTag()) || this.annotation.elementTag().equals("option") && XmlSerializerImpl.getBinding(this.itemType) == null) {
            throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
        }
    }

    @NotNull
    private synchronized Map<Class<?>, Binding> getElementBindings() {
        if (this.itemBindings == null) {
            Binding binding = XmlSerializerImpl.getBinding(this.itemType);
            if (this.annotation == null || this.annotation.elementTypes().length == 0) {
                this.itemBindings = binding == null ? Collections.emptyMap() : Collections.singletonMap(this.itemType, binding);
            } else {
                this.itemBindings = new THashMap();
                if (binding != null) {
                    this.itemBindings.put(this.itemType, binding);
                }
                for (Class aClass2 : this.annotation.elementTypes()) {
                    Binding b = XmlSerializerImpl.getBinding(aClass2);
                    if (b == null) continue;
                    this.itemBindings.put(aClass2, b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyMap();
                }
            }
        }
        Map<Class<?>, Binding> map2 = this.itemBindings;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "getElementBindings"));
        }
        return map2;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "getElementBinding"));
        }
        for (Binding binding : this.getElementBindings().values()) {
            if (!binding.isBoundTo(element)) continue;
            return binding;
        }
        return null;
    }

    abstract Object processResult(Collection var1, Object var2);

    @NotNull
    abstract Collection<Object> getIterable(@NotNull Object var1);

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter2) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "serialize"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "serialize"));
        }
        Collection<Object> collection = this.getIterable(o);
        String tagName = this.getTagName(o);
        if (tagName == null) {
            SmartList result2 = new SmartList();
            if (!ContainerUtil.isEmpty(collection)) {
                for (Object item : collection) {
                    ContainerUtil.addAllNotNull(result2, this.serializeItem(item, result2, filter2));
                }
            }
            return result2;
        }
        Element result3 = new Element(tagName);
        if (!ContainerUtil.isEmpty(collection)) {
            for (Object item : collection) {
                Content child = (Content)this.serializeItem(item, result3, filter2);
                if (child == null) continue;
                result3.addContent(child);
            }
        }
        return result3;
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<Element> elements) {
        Collection<Object> result2;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeList"));
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result2 = (SmartList)context;
                result2.clear();
            } else {
                result2 = new SmartList();
            }
            for (Element node : elements) {
                result2.add(this.deserializeItem(node, context));
            }
            if (result2 == context) {
                return result2;
            }
        } else {
            assert (elements.size() == 1);
            result2 = this.deserializeSingle(context, elements.get(0));
        }
        return this.processResult(result2, context);
    }

    @Nullable
    private Object serializeItem(@Nullable Object value, Object context, @NotNull SerializationFilter filter2) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "serializeItem"));
        }
        if (value == null) {
            LOG.warn("Collection " + this.myAccessor + " contains 'null' object");
            return null;
        }
        Binding binding = XmlSerializerImpl.getBinding(value.getClass());
        if (binding == null) {
            Element serializedItem = new Element(this.annotation == null ? "option" : this.annotation.elementTag());
            String attributeName = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
            String serialized = XmlSerializerImpl.convertToString(value);
            if (attributeName.isEmpty()) {
                if (!serialized.isEmpty()) {
                    serializedItem.addContent(new Text(serialized));
                }
            } else {
                serializedItem.setAttribute(attributeName, serialized);
            }
            return serializedItem;
        }
        return binding.serialize(value, context, filter2);
    }

    private Object deserializeItem(@NotNull Element node, Object context) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeItem"));
        }
        Binding binding = this.getElementBinding(node);
        if (binding == null) {
            String attributeName = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
            String value = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value, this.itemType);
        }
        return binding.deserialize(context, node);
    }

    @Override
    public Object deserialize(Object context, @NotNull Element element) {
        SmartList<Object> result2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "deserialize"));
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result2 = (Collection)context;
                result2.clear();
            } else {
                result2 = new SmartList<Object>();
            }
            result2.add(this.deserializeItem(element, context));
            if (result2 == context) {
                return result2;
            }
        } else {
            result2 = this.deserializeSingle(context, element);
        }
        return this.processResult(result2, context);
    }

    @NotNull
    private Collection deserializeSingle(Object context, @NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeSingle"));
        }
        Collection result2 = this.createCollection(node.getName());
        for (Element child : node.getChildren()) {
            result2.add(this.deserializeItem(child, context));
        }
        Collection collection = result2;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeSingle"));
        }
        return collection;
    }

    protected Collection createCollection(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "createCollection"));
        }
        return new SmartList();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/AbstractCollectionBinding", "isBoundTo"));
        }
        String tagName = this.getTagName(element);
        if (tagName == null) {
            if (element.getName().equals(this.annotation == null ? "option" : this.annotation.elementTag())) {
                return true;
            }
            if (this.getElementBinding(element) != null) {
                return true;
            }
        }
        return element.getName().equals(tagName);
    }

    @Nullable
    private String getTagName(@Nullable Object target) {
        return this.annotation == null || this.annotation.surroundWithTag() ? this.getCollectionTagName(target) : null;
    }

    protected abstract String getCollectionTagName(@Nullable Object var1);
}

